/*
 * Decompiled with CFR 0.152.
 */
package cofh.hud;

import cofh.CoFHCore;
import cofh.hud.IKeyBinding;
import cofh.network.IGeneralPacketHandler;
import cofh.network.PacketHandler;
import cofh.network.PacketUtils;
import cofh.network.Payload;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;

public class CoFHServerKeyHandler
implements IGeneralPacketHandler {
    public static final CoFHServerKeyHandler instance = new CoFHServerKeyHandler();
    public static final HashMap<String, IKeyBinding> serverBinds = new HashMap();
    public static int packetId;

    public static void initialize() {
        packetId = PacketHandler.getAvailablePacketIdAndRegister(instance);
    }

    public static boolean addServerKeyBind(IKeyBinding theBind, String keyName) {
        if (!serverBinds.containsKey(keyName)) {
            serverBinds.put(keyName, theBind);
            return true;
        }
        return false;
    }

    @Override
    public void handlePacket(int id, Payload payload, EntityPlayer player) throws Exception {
        String bindUUID = payload.getString();
        if (serverBinds.containsKey(bindUUID)) {
            if (payload.getBool()) {
                serverBinds.get(bindUUID).keyUpServer(bindUUID, payload.getBool(), player);
            } else {
                serverBinds.get(bindUUID).keyDownServer(bindUUID, payload.getBool(), payload.getBool(), player);
            }
        } else {
            CoFHCore.log.severe("Invalid Key Packet! Unregistered Server Key! UUID: " + bindUUID);
        }
    }

    public static void sendKeyPacket(String key, boolean keyUp, boolean isRepeat, boolean tickEnd) {
        Payload payload = Payload.getPayload(packetId);
        payload.addString(key);
        payload.addBool(keyUp);
        payload.addBool(tickEnd);
        if (!keyUp) {
            payload.addBool(isRepeat);
        }
        PacketUtils.sendToServer(payload.getPacket());
    }
}

