/*
 * Decompiled with CFR 0.152.
 */
package cofh.gui.element;

import cofh.gui.GuiBase;
import cofh.gui.element.ElementBase;
import cofh.render.RenderHelper;
import cofh.util.StringHelper;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.IFluidTank;

public class ElementFluidTank
extends ElementBase {
    public static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("cofh:textures/gui/elements/FluidTank.png");
    public static final int DEFAULT_SCALE = 60;
    protected IFluidTank tank;
    protected int gaugeType;

    public ElementFluidTank(GuiBase gui, int posX, int posY, IFluidTank tank) {
        super(gui, posX, posY);
        this.tank = tank;
        this.texture = DEFAULT_TEXTURE;
        this.texW = 64;
        this.texH = 64;
        this.sizeX = 16;
        this.sizeY = 60;
    }

    public ElementFluidTank(GuiBase gui, int posX, int posY, IFluidTank tank, String texture) {
        super(gui, posX, posY);
        this.tank = tank;
        this.texture = new ResourceLocation(texture);
        this.texW = 64;
        this.texH = 64;
        this.sizeX = 16;
        this.sizeY = 60;
    }

    public ElementFluidTank setGauge(int gaugeType) {
        this.gaugeType = gaugeType;
        return this;
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        int amount = this.getScaled();
        if (this.tank.getFluid() != null) {
            if (this.tank.getFluid().getFluid().getDensity(this.tank.getFluid()) < 0) {
                this.gui.drawFluid(this.posX, this.posY, this.tank.getFluid(), this.sizeX, amount);
            } else {
                this.gui.drawFluid(this.posX, this.posY + this.sizeY - amount, this.tank.getFluid(), this.sizeX, amount);
            }
        }
        RenderHelper.bindTexture(this.texture);
        this.drawTexturedModalRect(this.posX, this.posY, 32 + this.gaugeType * 16, 1, this.sizeX, this.sizeY);
    }

    @Override
    public void addTooltip(List<String> list) {
        if (this.tank.getFluid() != null && this.tank.getFluidAmount() > 0) {
            list.add(StringHelper.getFluidName(this.tank.getFluid()));
        }
        list.add("" + this.tank.getFluidAmount() + " / " + this.tank.getCapacity() + " mB");
    }

    @Override
    public boolean handleMouseClicked(int x, int y, int mouseButton) {
        return false;
    }

    int getScaled() {
        return this.tank.getFluidAmount() * this.sizeY / this.tank.getCapacity();
    }
}

