/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.modifiers.tools;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import tconstruct.library.tools.ToolCore;
import tconstruct.modifiers.tools.ToolModTypeFilter;

public class ModLapis
extends ToolModTypeFilter {
    String tooltipName = "\u00a79Luck";
    int max = 450;

    public ModLapis(int effect, ItemStack[] items, int[] values) {
        super(effect, "Lapis", items, values);
    }

    @Override
    protected boolean canModify(ItemStack tool, ItemStack[] input) {
        ToolCore toolItem = (ToolCore)tool.func_77973_b();
        if (!this.validType(toolItem)) {
            return false;
        }
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        if (tags.func_74767_n("Silk Touch")) {
            return false;
        }
        if (!tags.func_74764_b(this.key)) {
            return tags.func_74762_e("Modifiers") > 0 && this.matchingAmount(input) <= this.max;
        }
        int[] keyPair = tags.func_74759_k(this.key);
        return keyPair[0] + this.matchingAmount(input) <= this.max;
    }

    @Override
    public void modify(ItemStack[] input, ItemStack tool) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        if (!tags.func_74764_b(this.key)) {
            tags.func_74757_a(this.key, true);
            String modName = "\u00a79Lapis (0/450)";
            int tooltipIndex = this.addToolTip(tool, "\u00a79Luck", modName);
            int[] keyPair = new int[]{0, tooltipIndex};
            tags.func_74783_a(this.key, keyPair);
            int modifiers = tags.func_74762_e("Modifiers");
            tags.func_74768_a("Modifiers", --modifiers);
        }
        int increase = this.matchingAmount(input);
        int[] keyPair = tags.func_74759_k(this.key);
        keyPair[0] = keyPair[0] + increase;
        tags.func_74783_a(this.key, keyPair);
        ToolCore toolcore = (ToolCore)tool.func_77973_b();
        String[] types = toolcore.toolCategories();
        boolean weapon = false;
        boolean harvest = false;
        for (String s : types) {
            if (s.equals("harvest")) {
                harvest = true;
                continue;
            }
            if (!s.equals("weapon")) continue;
            weapon = true;
        }
        if (weapon) {
            if (keyPair[0] >= 450) {
                this.addEnchantment(tool, Enchantment.field_77335_o, 3);
            } else if (keyPair[0] >= 300) {
                this.addEnchantment(tool, Enchantment.field_77335_o, 2);
            } else if (keyPair[0] >= 100) {
                this.addEnchantment(tool, Enchantment.field_77335_o, 1);
            }
        }
        if (harvest) {
            if (keyPair[0] >= 450) {
                this.addEnchantment(tool, Enchantment.field_77346_s, 3);
            } else if (keyPair[0] >= 300) {
                this.addEnchantment(tool, Enchantment.field_77346_s, 2);
            } else if (keyPair[0] >= 100) {
                this.addEnchantment(tool, Enchantment.field_77346_s, 1);
            }
        }
        this.updateModTag(tool, keyPair);
    }

    public void midStreamModify(ItemStack tool, ToolCore toolItem) {
        int chance;
        List<String> list;
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        if (!tags.func_74764_b(this.key)) {
            return;
        }
        int[] keyPair = tags.func_74759_k(this.key);
        if (keyPair[0] == this.max) {
            return;
        }
        if (random.nextInt(50) == 0) {
            keyPair[0] = keyPair[0] + 1;
            tags.func_74783_a(this.key, keyPair);
            this.updateModTag(tool, keyPair);
        }
        if ((list = Arrays.asList(toolItem.toolCategories())).contains("weapon")) {
            if (keyPair[0] >= 450) {
                this.addEnchantment(tool, Enchantment.field_77335_o, 3);
            } else if (keyPair[0] >= 350) {
                chance = keyPair[0] - 300;
                if (random.nextInt(1000 - chance) == 0) {
                    this.addEnchantment(tool, Enchantment.field_77335_o, 3);
                }
            } else if (keyPair[0] >= 125) {
                chance = keyPair[0] - 175;
                if (random.nextInt(600 - chance) == 0) {
                    this.addEnchantment(tool, Enchantment.field_77335_o, 2);
                }
            } else if (keyPair[0] >= 10 && random.nextInt(250 - (chance = keyPair[0] - 25)) == 0) {
                this.addEnchantment(tool, Enchantment.field_77335_o, 1);
            }
        }
        if (list.contains("harvest")) {
            if (keyPair[0] >= 450) {
                this.addEnchantment(tool, Enchantment.field_77346_s, 3);
            } else if (keyPair[0] >= 350) {
                chance = keyPair[0] - 300;
                if (random.nextInt(1000 - chance) == 0) {
                    this.addEnchantment(tool, Enchantment.field_77346_s, 3);
                }
            } else if (keyPair[0] >= 125) {
                chance = keyPair[0] - 175;
                if (random.nextInt(600 - chance) == 0) {
                    this.addEnchantment(tool, Enchantment.field_77346_s, 2);
                }
            } else if (keyPair[0] >= 10 && random.nextInt(250 - (chance = keyPair[0] - 25)) == 0) {
                this.addEnchantment(tool, Enchantment.field_77346_s, 1);
            }
        }
    }

    public void addEnchantment(ItemStack tool, Enchantment enchant, int level) {
        NBTTagCompound enchantTag;
        NBTTagList tags = new NBTTagList("ench");
        Map enchantMap = EnchantmentHelper.func_82781_a((ItemStack)tool);
        Iterator iterator = enchantMap.keySet().iterator();
        boolean hasEnchant = false;
        while (iterator.hasNext()) {
            enchantTag = new NBTTagCompound();
            int index = (Integer)iterator.next();
            int lvl = (Integer)enchantMap.get(index);
            if (index == enchant.field_77352_x) {
                hasEnchant = true;
                enchantTag.func_74777_a("id", (short)index);
                enchantTag.func_74777_a("lvl", (short)((byte)level));
                tags.func_74742_a((NBTBase)enchantTag);
                continue;
            }
            enchantTag.func_74777_a("id", (short)index);
            enchantTag.func_74777_a("lvl", (short)((byte)lvl));
            tags.func_74742_a((NBTBase)enchantTag);
        }
        if (!hasEnchant) {
            enchantTag = new NBTTagCompound();
            enchantTag.func_74777_a("id", (short)enchant.field_77352_x);
            enchantTag.func_74777_a("lvl", (short)((byte)level));
            tags.func_74742_a((NBTBase)enchantTag);
        }
        tool.field_77990_d.func_74782_a("ench", (NBTBase)tags);
    }

    void updateModTag(ItemStack tool, int[] keys) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        String tip = "ModifierTip" + keys[1];
        String modName = "\u00a79Lapis (" + keys[0] + "/" + this.max + ")";
        tags.func_74778_a(tip, modName);
    }

    @Override
    public boolean validType(ToolCore tool) {
        List<String> list = Arrays.asList(tool.toolCategories());
        return list.contains("weapon") || list.contains("harvest");
    }
}

