/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.modifiers.armor;

import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import tconstruct.library.armor.ArmorCore;
import tconstruct.library.armor.ArmorModTypeFilter;
import tconstruct.library.armor.EnumArmorPart;

public class AModHealthBoost
extends ArmorModTypeFilter {
    final boolean modifierType;
    final int modifyAmount = 3;
    private static final UUID head = UUID.fromString("a2eac357-cae3-4a8f-994c-a8bcbbd6dab8");
    private static final UUID chest = UUID.fromString("a2eac357-cae3-4a8f-994c-a8bcbbd6dab9");
    private static final UUID pants = UUID.fromString("a2eac357-cae3-4a8f-994c-a8bcbbd6daba");
    private static final UUID shoes = UUID.fromString("a2eac357-cae3-4a8f-994c-a8bcbbd6dabb");

    public AModHealthBoost(int effect, EnumSet<EnumArmorPart> armorTypes, ItemStack[] items, int[] values, boolean type) {
        super(effect, "ExoHealth" + (type ? "Percent" : "Flat"), armorTypes, items, values);
        this.modifierType = type;
    }

    @Override
    protected boolean canModify(ItemStack tool, ItemStack[] input) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l(this.getTagName());
        int amount = this.matchingItems(input) * 3;
        return tags.func_74762_e("Modifiers") >= amount;
    }

    @Override
    public void modify(ItemStack[] input, ItemStack armor) {
        NBTTagList attributes;
        NBTTagCompound baseTag = armor.func_77978_p();
        NBTTagCompound armorTag = armor.func_77978_p().func_74775_l(this.getTagName());
        int modifiers = armorTag.func_74762_e("Modifiers");
        armorTag.func_74768_a("Modifiers", modifiers -= this.matchingAmount(input) * 3);
        int amount = this.matchingAmount(input);
        if (armorTag.func_74764_b(this.key)) {
            amount += armorTag.func_74762_e(this.key);
        }
        armorTag.func_74768_a(this.key, amount);
        if (baseTag.func_74764_b("AttributeModifiers")) {
            attributes = baseTag.func_74761_m("AttributeModifiers");
            for (int iter = 0; iter < attributes.func_74745_c(); ++iter) {
                NBTTagCompound tag = (NBTTagCompound)attributes.func_74743_b(iter);
                if (!tag.func_74779_i("AttributeName").equals("generic.maxHealth")) continue;
                attributes.func_74744_a(iter);
            }
        } else {
            attributes = new NBTTagList();
            baseTag.func_74782_a("AttributeModifiers", (NBTBase)attributes);
        }
        attributes.func_74742_a((NBTBase)AModHealthBoost.getAttributeTag("generic.maxHealth", this.key, amount, this.modifierType, this.getUUIDFromItem(armor)));
    }

    UUID getUUIDFromItem(ItemStack stack) {
        ArmorCore item = (ArmorCore)stack.func_77973_b();
        switch (item.armorPart) {
            case HELMET: {
                return head;
            }
            case CHEST: {
                return chest;
            }
            case PANTS: {
                return pants;
            }
            case SHOES: {
                return shoes;
            }
        }
        return null;
    }
}

