/*
 * Decompiled with CFR 0.152.
 */
package tconstruct;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ICraftingHandler;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.crash.CallableMinecraftVersion;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.MinecraftForge;
import tconstruct.achievements.TAchievements;
import tconstruct.client.event.EventCloakRender;
import tconstruct.common.TContent;
import tconstruct.common.TProxyCommon;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.Detailing;
import tconstruct.library.crafting.LiquidCasting;
import tconstruct.library.util.TabTools;
import tconstruct.plugins.PluginController;
import tconstruct.util.EnvironmentChecks;
import tconstruct.util.TCraftingHandler;
import tconstruct.util.TEventHandler;
import tconstruct.util.TEventHandlerAchievement;
import tconstruct.util.config.BOPConfig;
import tconstruct.util.config.DimensionBlacklist;
import tconstruct.util.config.PHConstruct;
import tconstruct.util.config.TwilightForestConfig;
import tconstruct.util.landmine.behavior.Behavior;
import tconstruct.util.landmine.behavior.stackCombo.SpecialStackHandler;
import tconstruct.util.network.TPacketHandler;
import tconstruct.util.player.TPlayerHandler;
import tconstruct.worldgen.SlimeIslandGen;
import tconstruct.worldgen.TBaseWorldGenerator;
import tconstruct.worldgen.TerrainGenEventHandler;
import tconstruct.worldgen.village.ComponentSmeltery;
import tconstruct.worldgen.village.ComponentToolWorkshop;
import tconstruct.worldgen.village.TVillageTrades;
import tconstruct.worldgen.village.VillageSmelteryHandler;
import tconstruct.worldgen.village.VillageToolStationHandler;

@Mod(modid="TConstruct", name="TConstruct", version="1.6.X_1.5.5.7", dependencies="required-after:Forge@[8.9,);after:ForgeMultipart;after:MineFactoryReloaded;after:NotEnoughItems;after:Waila;after:ThermalExpansion")
@NetworkMod(serverSideRequired=false, clientSideRequired=true, channels={"TConstruct"}, packetHandler=TPacketHandler.class)
public class TConstruct {
    public static final int ingotLiquidValue = 144;
    public static final int oreLiquidValue = 288;
    public static final int blockLiquidValue = 1296;
    public static final int chunkLiquidValue = 72;
    public static final int nuggetLiquidValue = 16;
    public static final int liquidUpdateAmount = 6;
    public static final Logger logger = Logger.getLogger("TConstruct");
    @Mod.Instance(value="TConstruct")
    public static TConstruct instance;
    @SidedProxy(clientSide="tconstruct.client.TProxyClient", serverSide="tconstruct.common.TProxyCommon")
    public static TProxyCommon proxy;
    public static TContent content;
    public static TEventHandler events;
    public static TPlayerHandler playerTracker;
    public static LiquidCasting tableCasting;
    public static LiquidCasting basinCasting;
    public static Detailing chiselDetailing;

    public TConstruct() {
        logger.setParent(FMLCommonHandler.instance().getFMLLogger());
        if (Loader.isModLoaded((String)"Natura")) {
            logger.info("[TConstruct] Natura, what are we going to do tomorrow night?");
            logger.info("[Natura] TConstruct, we're going to take over the world!");
        } else {
            logger.info("[TConstruct] Preparing to take over the world");
        }
        EnvironmentChecks.verifyEnvironmentSanity();
        PluginController.getController().registerBuiltins();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        PHConstruct.initProps(event.getModConfigurationDirectory());
        TConstructRegistry.materialTab = new TabTools("TConstructMaterials");
        TConstructRegistry.toolTab = new TabTools("TConstructTools");
        TConstructRegistry.partTab = new TabTools("TConstructParts");
        TConstructRegistry.blockTab = new TabTools("TConstructBlocks");
        tableCasting = new LiquidCasting();
        basinCasting = new LiquidCasting();
        chiselDetailing = new Detailing();
        content = new TContent();
        events = new TEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)events);
        MinecraftForge.EVENT_BUS.register((Object)new TEventHandlerAchievement());
        content.oreRegistry();
        proxy.registerRenderer();
        proxy.addNames();
        proxy.readManuals();
        proxy.registerKeys();
        proxy.registerTickHandler();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new TBaseWorldGenerator());
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)new TerrainGenEventHandler());
        GameRegistry.registerFuelHandler((IFuelHandler)content);
        GameRegistry.registerCraftingHandler((ICraftingHandler)new TCraftingHandler());
        NetworkRegistry.instance().registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        if (PHConstruct.addToVillages) {
            VillagerRegistry.instance().registerVillagerId(78943);
            VillagerRegistry.instance().registerVillageTradeHandler(78943, (VillagerRegistry.IVillageTradeHandler)new TVillageTrades());
            VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillageToolStationHandler());
            VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillageSmelteryHandler());
            try {
                if (new CallableMinecraftVersion(null).func_71493_a().equals("1.6.4")) {
                    MapGenStructureIO.func_143031_a(ComponentToolWorkshop.class, (String)"TConstruct:ToolWorkshopStructure");
                    MapGenStructureIO.func_143031_a(ComponentSmeltery.class, (String)"TConstruct:SmelteryStructure");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        playerTracker = new TPlayerHandler();
        GameRegistry.registerPlayerTracker((IPlayerTracker)playerTracker);
        MinecraftForge.EVENT_BUS.register((Object)playerTracker);
        PluginController.getController().preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (event.getSide() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.register((Object)new EventCloakRender());
        }
        content.intermodCommunication();
        TwilightForestConfig.initProps(PHConstruct.cfglocation);
        BOPConfig.initProps(PHConstruct.cfglocation);
        DimensionBlacklist.getbaddimensions();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new SlimeIslandGen(TContent.slimePool.field_71990_ca, 0));
        PluginController.getController().init();
        if (PHConstruct.achievementsEnabled) {
            TAchievements.init();
        }
    }

    @Mod.EventHandler
    public void intermodCommunication(FMLInterModComms.IMCEvent event) {
        ImmutableList messages = event.getMessages();
        for (FMLInterModComms.IMCMessage message : messages) {
            try {
                if (!message.key.equals("Bind_Knapsack_Dimension")) continue;
                String string = message.getStringValue();
                Integer i = Integer.valueOf(string);
                TPlayerHandler.knapsackDimensions.add(i);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error parsing IMC message from " + message.getSender() == null ? "unknown" : message.getSender(), e);
            }
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        proxy.postInit();
        Behavior.registerBuiltInBehaviors();
        SpecialStackHandler.registerBuiltInStackHandlers();
        content.modIntegration();
        content.addOreDictionarySmelteryRecipes();
        content.createEntities();
        content.modRecipes();
        PluginController.getController().postInit();
    }

    public static LiquidCasting getTableCasting() {
        return tableCasting;
    }

    public static LiquidCasting getBasinCasting() {
        return basinCasting;
    }

    public static Detailing getChiselDetailing() {
        return chiselDetailing;
    }
}

