/*
 * Decompiled with CFR 0.152.
 */
package magicbees.world.feature;

import cpw.mods.fml.common.FMLLog;
import java.util.Random;
import magicbees.block.types.HiveType;
import magicbees.main.Config;
import magicbees.main.MagicBees;
import magicbees.world.feature.FeatureOreVein;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class FeatureHive {
    private static FeatureOreVein redstoneGen;
    private static FeatureOreVein netherQuartzGen;
    private static FeatureOreVein glowstoneGen;
    private static FeatureOreVein endStoneGen;
    private static boolean logSpawns;

    public static void initialize() {
        redstoneGen = new FeatureOreVein(Block.field_72047_aN, Block.field_71981_t);
        netherQuartzGen = new FeatureOreVein(Block.field_94342_cr, Block.field_72012_bb);
        glowstoneGen = new FeatureOreVein(Block.field_72014_bd, Block.field_71981_t);
        endStoneGen = new FeatureOreVein(Block.field_72082_bJ, Block.field_71981_t);
    }

    public static void generateHives(World world, Random random, int chunkX, int chunkZ, boolean initialGen) {
        for (HiveType type : HiveType.values()) {
            type.generateHive(world, random, chunkX, chunkZ, initialGen);
        }
    }

    public static boolean generateHiveCurious(World world, Random random, int coordX, int coordZ, boolean initialGen) {
        int coordY = FeatureHive.getHeight(world, random, coordX, coordZ);
        boolean doSpawn = false;
        Block b = Block.field_71973_m[world.func_72798_a(coordX, coordY + 1, coordZ)];
        if (world.func_72799_c(coordX, coordY - 1, coordZ) && world.func_72799_c(coordX, coordY, coordZ) && b != null && b.isLeaves(world, coordX, coordY + 1, coordZ)) {
            world.func_72832_d(coordX, coordY, coordZ, Config.hive.field_71990_ca, HiveType.CURIOUS.ordinal(), 3);
            if (logSpawns) {
                FMLLog.info((String)"Spawning %s hive at: X %d,  Z %d, Y %d", (Object[])new Object[]{"Curious", coordX, coordZ, coordY});
            }
            doSpawn = true;
        }
        return doSpawn;
    }

    public static boolean generateHiveUnusual(World world, Random random, int coordX, int coordZ, boolean initialGen) {
        int coordY = FeatureHive.getHeight(world, random, coordX, coordZ);
        boolean doSpawn = false;
        if (world.func_72799_c(coordX, coordY + 1, coordZ) && world.func_72799_c(coordX, coordY, coordZ) && FeatureHive.canBlockReplaceAt(world, coordX, coordY - 1, coordZ, Block.field_71979_v)) {
            doSpawn = true;
        }
        if (doSpawn) {
            world.func_72832_d(coordX, coordY, coordZ, Config.hive.field_71990_ca, HiveType.UNUSUAL.ordinal(), 3);
            if (logSpawns) {
                FMLLog.info((String)"Spawning %s hive at: X %d,  Z %d, Y %d", (Object[])new Object[]{"Unusual", coordX, coordZ, coordY});
            }
        }
        return doSpawn;
    }

    public static boolean generateHiveResonant(World world, Random random, int coordX, int coordZ, boolean initialGen) {
        int coordY = FeatureHive.getHeight(world, random, coordX, coordZ);
        boolean doSpawn = false;
        if (world.field_73012_v.nextInt() < 40 && world.func_72799_c(coordX, coordY + 1, coordZ) && (world.func_72799_c(coordX, coordY, coordZ) || FeatureHive.canBlockReplaceAt(world, coordX, coordY, coordZ, (Block)Block.field_71962_X)) && (FeatureHive.canBlockReplaceAt(world, coordX, coordY - 1, coordZ, Block.field_71979_v) || FeatureHive.canBlockReplaceAt(world, coordX, coordY - 1, coordZ, Block.field_71939_E))) {
            doSpawn = true;
        }
        if (doSpawn) {
            world.func_72832_d(coordX, coordY, coordZ, Config.hive.field_71990_ca, HiveType.RESONANT.ordinal(), 3);
            if (logSpawns) {
                FMLLog.info((String)"Spawning %s hive at: X %d,  Z %d, Y %d", (Object[])new Object[]{"Resonant", coordX, coordZ, coordY});
            }
        }
        return doSpawn;
    }

    public static boolean generateHiveDeep(World world, Random random, int coordX, int coordZ, boolean initialGen) {
        BiomeGenBase biome = world.func_72807_a(coordX, coordZ);
        int coordY = 10 + random.nextInt(10);
        boolean doSpawn = false;
        if (random.nextInt(100) < 40 && !world.func_72799_c(coordX, coordY, coordZ) && FeatureHive.canBlockReplaceAt(world, coordX, coordY, coordZ, Block.field_71981_t)) {
            boolean bl = doSpawn = FeatureHive.getSurroundCount(world, coordX, coordY, coordZ, Block.field_71981_t) >= 6;
        }
        if (doSpawn) {
            world.func_72832_d(coordX, coordY, coordZ, Config.hive.field_71990_ca, HiveType.DEEP.ordinal(), 3);
            if (logSpawns) {
                FMLLog.info((String)"Spawning %s hive at: X %d,  Z %d, Y %d", (Object[])new Object[]{"Deep", coordX, coordZ, coordY});
            }
            redstoneGen.generateVein(world, random, coordX + 1, coordY, coordZ, 2);
            redstoneGen.generateVein(world, random, coordX - 1, coordY, coordZ, 2);
            redstoneGen.generateVein(world, random, coordX, coordY + 1, coordZ, 2);
            redstoneGen.generateVein(world, random, coordX, coordY - 1, coordZ, 2);
            redstoneGen.generateVein(world, random, coordX, coordY, coordZ + 1, 2);
            redstoneGen.generateVein(world, random, coordX, coordY, coordZ - 1, 2);
        }
        return doSpawn;
    }

    public static boolean generateHiveInfernal(World world, Random random, int coordX, int coordZ, boolean initialGen) {
        boolean doSpawn = false;
        if (!world.field_73011_w.func_76569_d()) {
            int chop = random.nextInt(2) + 1;
            int coordY = random.nextInt(60 / chop) + random.nextInt(chop) * (120 / chop) - 5;
            if (!world.func_72799_c(coordX, coordY, coordZ) && Block.field_71973_m[world.func_72798_a(coordX, coordY, coordZ)] != null && Block.field_71973_m[world.func_72798_a(coordX, coordY, coordZ)].isGenMineableReplaceable(world, coordX, coordY, coordZ, Block.field_72012_bb.field_71990_ca)) {
                boolean bl = doSpawn = FeatureHive.getSurroundCount(world, coordX, coordY, coordZ, Block.field_72012_bb) >= 5;
            }
            if (doSpawn) {
                world.func_72832_d(coordX, coordY, coordZ, Config.hive.field_71990_ca, HiveType.INFERNAL.ordinal(), 3);
                if (logSpawns) {
                    FMLLog.info((String)"Spawning %s hive at: X %d,  Z %d, Y %d", (Object[])new Object[]{"Infernal", coordX, coordZ, coordY});
                }
                netherQuartzGen.generateVein(world, random, coordX + 1, coordY, coordZ, 4);
                netherQuartzGen.generateVein(world, random, coordX - 1, coordY, coordZ, 4);
                netherQuartzGen.generateVein(world, random, coordX, coordY + 1, coordZ, 4);
                netherQuartzGen.generateVein(world, random, coordX, coordY - 1, coordZ, 4);
                netherQuartzGen.generateVein(world, random, coordX, coordY, coordZ + 1, 4);
                netherQuartzGen.generateVein(world, random, coordX, coordY, coordZ - 1, 4);
            }
        } else if (MagicBees.getConfig().DoSpecialHiveGen && world.field_73012_v.nextInt() < 11) {
            int coordY = random.nextInt(13) + 5;
            if (!world.func_72799_c(coordX, coordY, coordZ) && FeatureHive.canBlockReplaceAt(world, coordX, coordY, coordZ, Block.field_71981_t)) {
                boolean bl = doSpawn = FeatureHive.getSurroundCount(world, coordX, coordY, coordZ, Block.field_71981_t) >= 6;
            }
            if (doSpawn) {
                world.func_72832_d(coordX, coordY, coordZ, Config.hive.field_71990_ca, HiveType.INFERNAL.ordinal(), 3);
                if (logSpawns) {
                    FMLLog.info((String)"Spawning %s hive at: X %d,  Z %d, Y %d", (Object[])new Object[]{"Infernal", coordX, coordZ, coordY});
                }
                glowstoneGen.generateVein(world, random, coordX + 1, coordY, coordZ, world.field_73012_v.nextInt(4) + 1);
                glowstoneGen.generateVein(world, random, coordX - 1, coordY, coordZ, world.field_73012_v.nextInt(4) + 1);
                if (FeatureHive.canBlockReplaceAt(world, coordX, coordY + 1, coordZ, Block.field_71981_t) || FeatureHive.canBlockReplaceAt(world, coordX, coordY + 1, coordZ, Block.field_72012_bb)) {
                    world.func_72832_d(coordX, coordY + 1, coordZ, Block.field_72014_bd.field_71990_ca, 0, 3);
                }
                if (FeatureHive.canBlockReplaceAt(world, coordX, coordY - 1, coordZ, Block.field_71981_t) || FeatureHive.canBlockReplaceAt(world, coordX, coordY + 1, coordZ, Block.field_72012_bb)) {
                    world.func_72832_d(coordX, coordY - 1, coordZ, Block.field_72014_bd.field_71990_ca, 0, 3);
                }
                glowstoneGen.generateVein(world, random, coordX, coordY, coordZ + 1, world.field_73012_v.nextInt(4) + 1);
                glowstoneGen.generateVein(world, random, coordX, coordY, coordZ - 1, world.field_73012_v.nextInt(4) + 1);
            }
        }
        return doSpawn;
    }

    public static boolean generateHiveOblivion(World world, Random random, int coordX, int coordZ, boolean initialGen) {
        boolean doSpawn = false;
        if (!world.field_73011_w.func_76569_d()) {
            int coordY = 10 + random.nextInt(25);
            if (world.func_72799_c(coordX, coordY - 2, coordZ) && FeatureHive.canBlockReplaceAt(world, coordX, coordY - 1, coordZ, Block.field_72082_bJ) && FeatureHive.canBlockReplaceAt(world, coordX, coordY, coordZ, Block.field_72082_bJ)) {
                doSpawn = true;
            }
            if (doSpawn) {
                world.func_72832_d(coordX, coordY, coordZ, Config.hive.field_71990_ca, HiveType.OBLIVION.ordinal(), 3);
                if (logSpawns) {
                    FMLLog.info((String)"Spawning %s hive at: X %d,  Z %d, Y %d", (Object[])new Object[]{"Oblivion", coordX, coordZ, coordY});
                }
                int obsidianSpikeHeight = random.nextInt(8) + 2;
                for (int i = 1; i < obsidianSpikeHeight && coordY - i > 0; ++i) {
                    world.func_72832_d(coordX, coordY - i, coordZ, Block.field_72089_ap.field_71990_ca, 0, 2);
                }
            }
        } else if (MagicBees.getConfig().DoSpecialHiveGen && world.field_73012_v.nextInt() < 8) {
            int coordY = random.nextInt(5) + 5;
            do {
                if ((world.func_72799_c(coordX, --coordY, coordZ) || !FeatureHive.canBlockReplaceAt(world, coordX, coordY, coordZ, Block.field_71981_t)) && !FeatureHive.canBlockReplaceAt(world, coordX, coordY, coordZ, Block.field_72082_bJ)) continue;
                boolean bl = doSpawn = FeatureHive.getSurroundCount(world, coordX, coordY, coordZ, Block.field_72082_bJ) >= 5 || FeatureHive.getSurroundCount(world, coordX, coordY, coordZ, Block.field_71981_t) >= 5;
            } while (!doSpawn && coordY > 5);
            if (doSpawn) {
                world.func_72832_d(coordX, coordY, coordZ, Config.hive.field_71990_ca, HiveType.OBLIVION.ordinal(), 3);
                if (logSpawns) {
                    FMLLog.info((String)"Spawning %s hive at: X %d,  Z %d, Y %d", (Object[])new Object[]{"Oblivion", coordX, coordZ, coordY});
                }
                endStoneGen.generateVein(world, random, coordX + 1, coordY, coordZ, world.field_73012_v.nextInt(6) + 1);
                endStoneGen.generateVein(world, random, coordX - 1, coordY, coordZ, world.field_73012_v.nextInt(6) + 1);
                endStoneGen.generateVein(world, random, coordX, coordY + 1, coordZ, world.field_73012_v.nextInt(3) + 1);
                endStoneGen.generateVein(world, random, coordX, coordY - 1, coordZ, world.field_73012_v.nextInt(3) + 1);
                endStoneGen.generateVein(world, random, coordX, coordY, coordZ + 1, world.field_73012_v.nextInt(6) + 1);
                endStoneGen.generateVein(world, random, coordX, coordY, coordZ - 1, world.field_73012_v.nextInt(6) + 1);
            }
        }
        return doSpawn;
    }

    private static int getHeight(World world, Random random, int coordX, int coordZ) {
        BiomeGenBase biome = world.func_72807_a(coordX, coordZ);
        int min = (int)(biome.field_76748_D * 64.0f + 62.0f);
        int max = (int)(biome.field_76749_E * 64.0f);
        min = min > 1 ? min : 1;
        max = max > 10 ? max : 10;
        return min + random.nextInt(max);
    }

    private static int getSurroundCount(World world, int x, int y, int z, Block blockType) {
        int surroundCount = 0;
        if (FeatureHive.canBlockReplaceAt(world, x + 1, y, z, blockType)) {
            ++surroundCount;
        }
        if (FeatureHive.canBlockReplaceAt(world, x - 1, y, z, blockType)) {
            ++surroundCount;
        }
        if (FeatureHive.canBlockReplaceAt(world, x, y + 1, z, blockType)) {
            ++surroundCount;
        }
        if (FeatureHive.canBlockReplaceAt(world, x, y - 1, z, blockType)) {
            ++surroundCount;
        }
        if (FeatureHive.canBlockReplaceAt(world, x, y, z + 1, blockType)) {
            ++surroundCount;
        }
        if (FeatureHive.canBlockReplaceAt(world, x, y, z - 1, blockType)) {
            ++surroundCount;
        }
        return surroundCount;
    }

    private static boolean canBlockReplaceAt(World world, int x, int y, int z, Block block) {
        return Block.field_71973_m[world.func_72798_a(x, y, z)] != null && Block.field_71973_m[world.func_72798_a(x, y, z)].isGenMineableReplaceable(world, x, y, z, block.field_71990_ca);
    }

    static {
        logSpawns = false;
    }
}

