/*
 * Decompiled with CFR 0.152.
 */
package magicbees.main.utils.compat;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameRegistry;
import magicbees.item.types.DropType;
import magicbees.main.Config;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidRegistry;

public class ThermalExpansionHelper {
    public static final String Name = "ThermalExpansion";
    private static boolean isThermalExpansionPresent = false;

    public static boolean isActive() {
        return isThermalExpansionPresent;
    }

    public static void preInit() {
        if (Loader.isModLoaded((String)Name)) {
            isThermalExpansionPresent = true;
        }
    }

    public static void init() {
        if (ThermalExpansionHelper.isActive()) {
            ThermalExpansionHelper.getFluids();
            ThermalExpansionHelper.setupCrafting();
        }
    }

    private static void getFluids() {
        Config.teFluidGlowstone = FluidRegistry.getFluidStack((String)"glowstone", (int)50);
        Config.teFluidCoal = FluidRegistry.getFluidStack((String)"coal", (int)50);
        Config.teFluidRedstone = FluidRegistry.getFluidStack((String)"redstone", (int)50);
        Config.teFluidEnder = FluidRegistry.getFluidStack((String)"ender", (int)50);
    }

    private static void setupCrafting() {
        ItemStack carbonDrop = Config.drops.getStackForType(DropType.CARBON);
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a("energy", 4000);
        toSend.func_74766_a("input", new NBTTagCompound());
        toSend.func_74766_a("output", new NBTTagCompound());
        carbonDrop.func_77955_b(toSend.func_74775_l("input"));
        Config.teFluidCoal.writeToNBT(toSend.func_74775_l("output"));
        FMLInterModComms.sendMessage((String)Name, (String)"CrucibleRecipe", (NBTTagCompound)toSend);
        ItemStack destabilizedDrop = Config.drops.getStackForType(DropType.DESTABILIZED);
        toSend = new NBTTagCompound();
        toSend.func_74768_a("energy", 4000);
        toSend.func_74766_a("input", new NBTTagCompound());
        toSend.func_74766_a("output", new NBTTagCompound());
        destabilizedDrop.func_77955_b(toSend.func_74775_l("input"));
        Config.teFluidRedstone.writeToNBT(toSend.func_74775_l("output"));
        FMLInterModComms.sendMessage((String)Name, (String)"CrucibleRecipe", (NBTTagCompound)toSend);
        ItemStack endearingDrop = Config.drops.getStackForType(DropType.ENDEARING);
        toSend = new NBTTagCompound();
        toSend.func_74768_a("energy", 4000);
        toSend.func_74766_a("input", new NBTTagCompound());
        toSend.func_74766_a("output", new NBTTagCompound());
        endearingDrop.func_77955_b(toSend.func_74775_l("input"));
        Config.teFluidEnder.writeToNBT(toSend.func_74775_l("output"));
        FMLInterModComms.sendMessage((String)Name, (String)"CrucibleRecipe", (NBTTagCompound)toSend);
        ItemStack luxDrop = Config.drops.getStackForType(DropType.LUX);
        toSend = new NBTTagCompound();
        toSend.func_74768_a("energy", 4000);
        toSend.func_74766_a("input", new NBTTagCompound());
        toSend.func_74766_a("output", new NBTTagCompound());
        luxDrop.func_77955_b(toSend.func_74775_l("input"));
        Config.teFluidGlowstone.writeToNBT(toSend.func_74775_l("output"));
        FMLInterModComms.sendMessage((String)Name, (String)"CrucibleRecipe", (NBTTagCompound)toSend);
    }

    public static void postInit() {
        if (ThermalExpansionHelper.isActive()) {
            ThermalExpansionHelper.getBlocks();
            ThermalExpansionHelper.getItems();
        }
    }

    private static void getBlocks() {
        Config.teEnderiumBlock = GameRegistry.findItemStack((String)Name, (String)"blockEnderium", (int)1);
        Config.teElectrumBlock = GameRegistry.findItemStack((String)Name, (String)"blockElectrum", (int)1);
        Config.teInvarBlock = GameRegistry.findItemStack((String)Name, (String)"blockInvar", (int)1);
        Config.teNickelBlock = GameRegistry.findItemStack((String)Name, (String)"blockNickel", (int)1);
        Config.tePlatinumBlock = GameRegistry.findItemStack((String)Name, (String)"blockPlatinum", (int)1);
        Config.teBronzeBlock = GameRegistry.findItemStack((String)Name, (String)"blockBronze", (int)1);
    }

    private static void getItems() {
        Config.teEnderiumNugget = GameRegistry.findItemStack((String)Name, (String)"nuggetEnderium", (int)1);
        Config.teInvarNugget = GameRegistry.findItemStack((String)Name, (String)"nuggetInvar", (int)1);
        Config.teElectrumNugget = GameRegistry.findItemStack((String)Name, (String)"nuggetElectrum", (int)1);
        Config.teNickelNugget = GameRegistry.findItemStack((String)Name, (String)"nuggetNickel", (int)1);
        Config.tePlatinumNugget = GameRegistry.findItemStack((String)Name, (String)"nuggetPlatinum", (int)1);
        Config.teDustCryotheum = GameRegistry.findItemStack((String)Name, (String)"dustCryotheum", (int)1);
        Config.teDustBlizz = GameRegistry.findItemStack((String)Name, (String)"dustBlizz", (int)1);
        Config.teDustPyrotheum = GameRegistry.findItemStack((String)Name, (String)"dustPyrotheum", (int)1);
        Config.teDustSulfur = GameRegistry.findItemStack((String)Name, (String)"dustSulfur", (int)1);
        Config.teDustPlatinum = GameRegistry.findItemStack((String)Name, (String)"dustPlatinum", (int)1);
    }

    public static enum Entity {
        BLIZZ("Blizz");

        public final String entityID;

        private Entity(String s) {
            this.entityID = s;
        }
    }

    public static enum NuggetType {
        ENDERIUM,
        ELECTRUM,
        BRONZE,
        INVAR,
        NICKEL,
        PLATINUM;

    }

    public static enum MiscResource {
        EnderiumBlock,
        ElectrumBlock,
        BronzeBlock,
        FluidCoal,
        FluidRedstone,
        FluidGlowstone,
        FluidEnder;

    }
}

