/*
 * Decompiled with CFR 0.152.
 */
package magicbees.main;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.apiculture.BeeManager;
import forestry.api.storage.BackpackManager;
import forestry.api.storage.EnumBackpackType;
import forestry.api.storage.IBackpackDefinition;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import magicbees.block.BlockEffectJar;
import magicbees.block.BlockHive;
import magicbees.block.BlockPlanks;
import magicbees.block.BlockWoodSlab;
import magicbees.block.types.HiveType;
import magicbees.item.ItemCapsule;
import magicbees.item.ItemComb;
import magicbees.item.ItemCrystalAspect;
import magicbees.item.ItemDrop;
import magicbees.item.ItemMagicHiveFrame;
import magicbees.item.ItemMiscResources;
import magicbees.item.ItemMoonDial;
import magicbees.item.ItemMysteriousMagnet;
import magicbees.item.ItemNugget;
import magicbees.item.ItemPollen;
import magicbees.item.ItemPropolis;
import magicbees.item.ItemWax;
import magicbees.item.types.CapsuleType;
import magicbees.item.types.HiveFrameType;
import magicbees.item.types.NuggetType;
import magicbees.item.types.ResourceType;
import magicbees.item.types.WaxType;
import magicbees.main.MagicBees;
import magicbees.main.utils.LocalizationManager;
import magicbees.main.utils.compat.ThaumcraftHelper;
import magicbees.storage.BackpackDefinition;
import magicbees.tileentity.TileEntityEffectJar;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemMultiTextureTile;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Property;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class Config {
    public boolean DrawParticleEffects;
    public boolean BeeInfusionsAdded;
    public boolean AddThaumcraftItemsToBackpacks;
    public boolean DisableUpdateNotification;
    public boolean AreMagicPlanksFlammable;
    public boolean UseImpregnatedStickInTools;
    public boolean MoonDialShowsPhaseInText;
    public boolean DoSpecialHiveGen;
    public String ThaumaturgeExtraItems;
    public int CapsuleStackSizeMax;
    public boolean DoHiveRetrogen;
    public boolean ForceHiveRegen;
    public float MagnetBaseRange;
    public float MagnetLevelMultiplier;
    public int MagnetMaxLevel;
    public boolean ForestryDebugEnabled;
    public static BlockPlanks planksWood;
    public static BlockWoodSlab slabWoodHalf;
    public static BlockWoodSlab slabWoodFull;
    public static BlockEffectJar effectJar;
    public static BlockHive hive;
    public static ItemComb combs;
    public static ItemWax wax;
    public static ItemPropolis propolis;
    public static ItemDrop drops;
    public static ItemPollen pollen;
    public static ItemCrystalAspect solidFlux;
    public static ItemMiscResources miscResources;
    public static ItemFood jellyBaby;
    public static Item thaumiumScoop;
    public static Item thaumiumGrafter;
    public static ItemNugget nuggets;
    public static ItemMoonDial moonDial;
    public static ItemMysteriousMagnet magnet;
    public static ItemCapsule magicCapsule;
    public static ItemCapsule voidCapsule;
    public static ItemMagicHiveFrame hiveFrameMagic;
    public static ItemMagicHiveFrame hiveFrameResilient;
    public static ItemMagicHiveFrame hiveFrameGentle;
    public static ItemMagicHiveFrame hiveFrameMetabolic;
    public static ItemMagicHiveFrame hiveFrameNecrotic;
    public static ItemMagicHiveFrame hiveFrameTemporal;
    public static ItemMagicHiveFrame hiveFrameOblivion;
    public static Item thaumaturgeBackpackT1;
    public static Item thaumaturgeBackpackT2;
    public static BackpackDefinition thaumaturgeBackpackDef;
    public static Block fHiveBlock;
    public static Block fAlvearyBlock;
    public static Item fBeeComb;
    public static Item fHoneydew;
    public static Item fHoneyDrop;
    public static Item fPollen;
    public static Item fCraftingResource;
    public static Block tcPlant;
    public static Block tcCandle;
    public static Block tcCrystal;
    public static Block tcMarker;
    public static Block tcJar;
    public static Block tcLog;
    public static Block tcLeaf;
    public static Block tcWarded;
    public static Item tcFilledJar;
    public static Item tcMiscResource;
    public static Item tcShard;
    public static Item tcGolem;
    public static Item tcNuggets;
    public static Item tcNuggetChicken;
    public static Item tcNuggetBeef;
    public static Item tcNuggetPork;
    public static Item eeMinuimShard;
    public static Block amResourceBlock;
    public static Block amBlackOrchid;
    public static Block amDesertNova;
    public static Block amAum;
    public static Block amWakebloom;
    public static Block amTarmaRoot;
    public static Item amItemResource;
    public static Item amEssence;
    public static ItemStack rsaFluxBlock;
    public static ItemStack rsaFluxNugget;
    public static ItemStack teEnderiumBlock;
    public static ItemStack teElectrumBlock;
    public static ItemStack teInvarBlock;
    public static ItemStack teNickelBlock;
    public static ItemStack tePlatinumBlock;
    public static ItemStack teBronzeBlock;
    public static ItemStack teEnderiumNugget;
    public static ItemStack teInvarNugget;
    public static ItemStack teElectrumNugget;
    public static ItemStack teNickelNugget;
    public static ItemStack tePlatinumNugget;
    public static ItemStack teDustCryotheum;
    public static ItemStack teDustBlizz;
    public static ItemStack teDustPyrotheum;
    public static ItemStack teDustSulfur;
    public static ItemStack teDustPlatinum;
    public static FluidStack teFluidGlowstone;
    public static FluidStack teFluidCoal;
    public static FluidStack teFluidRedstone;
    public static FluidStack teFluidEnder;
    private Configuration configuration;

    public Config(File configFile) {
        this.configuration = new Configuration(configFile);
        this.configuration.load();
        this.doMiscConfig();
        this.ForestryDebugEnabled = new File("./config/forestry/DEBUG.ON").exists();
    }

    public void saveConfigs() {
        this.configuration.save();
    }

    public void setupBlocks() {
        int blockIdBase = 1750;
        int plankId = this.configuration.getBlock("planksTC", blockIdBase++).getInt();
        int slabFullId = this.configuration.getBlock("slabFull", blockIdBase++).getInt();
        int slabHalfId = this.configuration.getBlock("slabHalf", blockIdBase++).getInt();
        effectJar = new BlockEffectJar(this.configuration.getBlock("effectJar", blockIdBase++).getInt());
        GameRegistry.registerBlock((Block)effectJar, (String)"effectJar");
        GameRegistry.registerTileEntity(TileEntityEffectJar.class, (String)"magicbees.effectJar");
        hive = new BlockHive(this.configuration.getBlock("hives", blockIdBase++).getInt());
        GameRegistry.registerBlock((Block)hive, (String)"hive");
        for (HiveType t : HiveType.values()) {
            MinecraftForge.setBlockHarvestLevel((Block)hive, (int)t.ordinal(), (String)"scoop", (int)0);
        }
        FMLLog.info((String)"Replacing stupid-block with 'Here,  have some delicious textures' ItemBlock. This is 100%% normal.", (Object[])new Object[0]);
        Item.field_77698_e[Config.hive.field_71990_ca] = null;
        Item.field_77698_e[Config.hive.field_71990_ca] = new ItemMultiTextureTile(Config.hive.field_71990_ca - 256, (Block)hive, HiveType.getAllNames());
    }

    public void setupItems() {
        int itemIDBase = 26090;
        combs = new ItemComb(this.configuration.getItem("combs", itemIDBase++).getInt() - 256);
        wax = new ItemWax(this.configuration.getItem("wax", itemIDBase++).getInt() - 256);
        propolis = new ItemPropolis(this.configuration.getItem("propolis", itemIDBase++).getInt() - 256);
        drops = new ItemDrop(this.configuration.getItem("drop", itemIDBase++).getInt() - 256);
        miscResources = new ItemMiscResources(this.configuration.getItem("miscResources", itemIDBase++).getInt() - 256);
        BeeManager.inducers.put(miscResources.getStackForType(ResourceType.AROMATIC_LUMP), 95);
        int tier1 = this.configuration.getItem("thaumaturgePack1", itemIDBase++).getInt() - 256;
        int tier2 = this.configuration.getItem("thaumaturgePack2", itemIDBase++).getInt() - 256;
        if (ThaumcraftHelper.isActive()) {
            try {
                String backpackName = LocalizationManager.getLocalizedString("backpack.thaumaturge");
                BackpackDefinition def = new BackpackDefinition("thaumaturge", backpackName, 8847558);
                thaumaturgeBackpackT1 = BackpackManager.backpackInterface.addBackpack(tier1, (IBackpackDefinition)def, EnumBackpackType.T1);
                thaumaturgeBackpackT1.func_77655_b("backpack.thaumaturgeT1");
                thaumaturgeBackpackT2 = BackpackManager.backpackInterface.addBackpack(tier2, (IBackpackDefinition)def, EnumBackpackType.T2);
                thaumaturgeBackpackT2.func_77655_b("backpack.thaumaturgeT2");
                if (MagicBees.getConfig().ThaumaturgeExtraItems.length() > 0) {
                    FMLLog.info((String)"Attempting to add extra items to Thaumaturge's backpack. If you get an error, check your MagicBees.conf.", (Object[])new Object[0]);
                    FMLInterModComms.sendMessage((String)"Forestry", (String)"add-backpack-items", (String)("thaumaturge@" + MagicBees.getConfig().ThaumaturgeExtraItems));
                }
            }
            catch (Exception e) {
                FMLLog.severe((String)"MagicBees encountered a problem during loading!", (Object[])new Object[0]);
                FMLLog.severe((String)"Could not register backpacks via Forestry. Check your FML Client log and see if Forestry crashed silently.", (Object[])new Object[0]);
            }
        }
        magicCapsule = new ItemCapsule(CapsuleType.MAGIC, this.configuration.getItem("magicCapsule", itemIDBase++).getInt() - 256, this.CapsuleStackSizeMax);
        pollen = new ItemPollen(this.configuration.getItem("pollen", itemIDBase++).getInt() - 256);
        int crystalId = this.configuration.getItem("fluxCrystal", itemIDBase++).getInt() - 256;
        hiveFrameMagic = new ItemMagicHiveFrame(this.configuration.getItem("frameMagic", itemIDBase++).getInt() - 256, HiveFrameType.MAGIC);
        hiveFrameResilient = new ItemMagicHiveFrame(this.configuration.getItem("frameResilient", itemIDBase++).getInt() - 256, HiveFrameType.RESILIENT);
        hiveFrameGentle = new ItemMagicHiveFrame(this.configuration.getItem("frameGentle", itemIDBase++).getInt() - 256, HiveFrameType.GENTLE);
        hiveFrameMetabolic = new ItemMagicHiveFrame(this.configuration.getItem("frameMetabolic", itemIDBase++).getInt() - 256, HiveFrameType.METABOLIC);
        hiveFrameNecrotic = new ItemMagicHiveFrame(this.configuration.getItem("frameNecrotic", itemIDBase++).getInt() - 256, HiveFrameType.NECROTIC);
        hiveFrameTemporal = new ItemMagicHiveFrame(this.configuration.getItem("frameTemporal", itemIDBase++).getInt() - 256, HiveFrameType.TEMPORAL);
        hiveFrameOblivion = new ItemMagicHiveFrame(this.configuration.getItem("frameOblivion", itemIDBase++).getInt() - 256, HiveFrameType.OBLIVION);
        ++itemIDBase;
        ++itemIDBase;
        ++itemIDBase;
        ++itemIDBase;
        ++itemIDBase;
        ++itemIDBase;
        ++itemIDBase;
        ChestGenHooks.addItem((String)"strongholdCorridor", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack((Item)hiveFrameOblivion), 1, 1, 18));
        ChestGenHooks.addItem((String)"strongholdLibrary", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack((Item)hiveFrameOblivion), 1, 3, 23));
        int n = ++itemIDBase;
        jellyBaby = new ItemFood(this.configuration.getItem("jellyBabies", n).getInt() - 256, 1, false).func_77848_i().func_77844_a(Potion.field_76424_c.field_76415_H, 5, 1, 1.0f);
        jellyBaby.func_77655_b("magicbees:jellyBabies").func_111206_d("magicbees:jellyBabies");
        GameRegistry.registerItem((Item)jellyBaby, (String)"magicbees:jellyBabies");
        int n2 = ++itemIDBase;
        voidCapsule = new ItemCapsule(CapsuleType.VOID, this.configuration.getItem("voidCapsule", n2).getInt() - 256, this.CapsuleStackSizeMax);
        int n3 = ++itemIDBase;
        int scoopID = this.configuration.getItem("thaumiumScoop", n3).getInt() - 256;
        int n4 = ++itemIDBase;
        ++itemIDBase;
        int grafterID = this.configuration.getItem("thaumiumGrafter", n4).getInt() - 256;
        if (ThaumcraftHelper.isActive()) {
            try {
                Constructor<?> ctor1 = Class.forName("magicbees.item.ItemThaumiumScoop").getConstructor(Integer.TYPE);
                thaumiumScoop = (Item)ctor1.newInstance(scoopID);
                MinecraftForge.setToolClass((Item)thaumiumScoop, (String)"scoop", (int)3);
                GameRegistry.registerItem((Item)thaumiumScoop, (String)thaumiumScoop.func_77658_a());
                Constructor<?> ctor2 = Class.forName("magicbees.item.ItemThaumiumGrafter").getConstructor(Integer.TYPE);
                thaumiumGrafter = (Item)ctor2.newInstance(grafterID);
                MinecraftForge.setToolClass((Item)thaumiumGrafter, (String)"grafter", (int)3);
                GameRegistry.registerItem((Item)thaumiumGrafter, (String)thaumiumGrafter.func_77658_a());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        moonDial = new ItemMoonDial(this.configuration.getItem("moonDial", itemIDBase++).getInt() - 256);
        nuggets = new ItemNugget(this.configuration.getItem("beeNuggets", itemIDBase++).getInt() - 256);
        magnet = new ItemMysteriousMagnet(this.configuration.getItem("magicMagnet", itemIDBase++).getInt() - 256);
        magnet.setBaseRange(this.MagnetBaseRange);
        magnet.setLevelMultiplier(this.MagnetLevelMultiplier);
        magnet.setMaximumLevel(this.MagnetMaxLevel);
        for (int level = 0; level <= 8; ++level) {
            OreDictionary.registerOre((String)("mb.magnet.level" + level), (ItemStack)new ItemStack((Item)magnet, 1, level * 2));
            OreDictionary.registerOre((String)("mb.magnet.level" + level), (ItemStack)new ItemStack((Item)magnet, 1, level * 2 + 1));
        }
        OreDictionary.registerOre((String)"beeComb", (ItemStack)new ItemStack((Item)combs, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"waxMagical", (ItemStack)wax.getStackForType(WaxType.MAGIC));
        OreDictionary.registerOre((String)"waxMagical", (ItemStack)wax.getStackForType(WaxType.AMNESIC));
        OreDictionary.registerOre((String)"nuggetIron", (ItemStack)nuggets.getStackForType(NuggetType.IRON));
        OreDictionary.registerOre((String)"nuggetCopper", (ItemStack)nuggets.getStackForType(NuggetType.COPPER));
        OreDictionary.registerOre((String)"nuggetTin", (ItemStack)nuggets.getStackForType(NuggetType.TIN));
        OreDictionary.registerOre((String)"nuggetSilver", (ItemStack)nuggets.getStackForType(NuggetType.SILVER));
        OreDictionary.registerOre((String)"nuggetLead", (ItemStack)nuggets.getStackForType(NuggetType.LEAD));
        OreDictionary.registerOre((String)"shardDiamond", (ItemStack)nuggets.getStackForType(NuggetType.DIAMOND));
        OreDictionary.registerOre((String)"shardEmerald", (ItemStack)nuggets.getStackForType(NuggetType.EMERALD));
        OreDictionary.registerOre((String)"shardApatite", (ItemStack)nuggets.getStackForType(NuggetType.APATITE));
    }

    private void doMiscConfig() {
        try {
            Field f = Class.forName("forestry.core.config.Config").getField("enableParticleFX");
            this.DrawParticleEffects = f.getBoolean(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Property p = this.configuration.get("general", "backpack.thaumaturge.additionalItems", "");
        p.comment = "Add additional items to the Thaumaturge's Backpack.\n Format is the same as Forestry's: id:meta;id;id:meta (etc)";
        this.ThaumaturgeExtraItems = p.getString();
        p = this.configuration.get("general", "backpack.forestry.addThaumcraftItems", true);
        p.comment = "Set to true if you want MagicBees to add several Thaumcraft blocks & items to Forestry backpacks.\n Set to false to disable.";
        this.AddThaumcraftItemsToBackpacks = p.getBoolean(true);
        p = this.configuration.get("general", "capsuleStackSize", 64);
        p.comment = "Allows you to edit the stack size of the capsules in MagicBees if using GregTech, \nor the reduced capsule size in Forestry & Railcraft. Default: 64";
        this.CapsuleStackSizeMax = p.getInt();
        p = this.configuration.get("general", "disableVersionNotification", false);
        p.comment = "Set to true to stop ThaumicBees from notifying you when new updates are available. (Does not supress critical updates)";
        this.DisableUpdateNotification = p.getBoolean(false);
        p = this.configuration.get("general", "areMagicPlanksFlammable", false);
        p.comment = "Set to true to allow Greatwood & Silverwood planks to burn in a fire.";
        this.AreMagicPlanksFlammable = p.getBoolean(false);
        p = this.configuration.get("general", "useImpregnatedStickInTools", false);
        p.comment = "Set to true to make Thaumium Grafter & Scoop require impregnated sticks in the recipe.";
        this.UseImpregnatedStickInTools = p.getBoolean(false);
        p = this.configuration.get("general", "moonDialShowText", false);
        p.comment = "set to true to show the current moon phase in mouse-over text.";
        this.MoonDialShowsPhaseInText = p.getBoolean(false);
        p = this.configuration.get("general", "doSpecialHiveGen", true);
        p.comment = "Set to false if you hate fun and do not want special hives generating in Magic biomes.";
        this.DoSpecialHiveGen = p.getBoolean(true);
        p = this.configuration.get("Retrogen", "doHiveRetrogen", false);
        p.comment = "Set to true to enable retroactive worldgen of Magic Bees hives.";
        this.DoHiveRetrogen = p.getBoolean(false);
        p = this.configuration.get("Retrogen", "forceHiveRegen", false);
        p.comment = "Set to true to force a regeneration of Magic Bees hives. Will set config option to false after parsed. (Implies doHiveRetrogen=true)";
        this.ForceHiveRegen = p.getBoolean(false);
        if (this.ForceHiveRegen) {
            FMLLog.info((String)"Magic Bees will aggressively regenerate hives in all chunks for this game instance. Config option set to false.", (Object[])new Object[0]);
            p.set(false);
            this.DoHiveRetrogen = true;
        } else if (this.DoHiveRetrogen) {
            FMLLog.info((String)"Magic Bees will attempt to regenerate hives in chunks that were generated before the mod was added.", (Object[])new Object[0]);
        }
        p = this.configuration.get("general", "magnetRangeBase", 3.0);
        p.comment = "Base range (in blocks) of the Mysterious Magnet";
        this.MagnetBaseRange = (float)p.getDouble(3.0);
        p = this.configuration.get("general", "magnetRangeMultiplier", 0.75);
        p.comment = "Range multiplier per level of the Mysterious Magnet. Total range = base range + level * multiplier";
        this.MagnetLevelMultiplier = (float)p.getDouble(0.75);
        p = this.configuration.get("general", "magnetMaximumLevel", 8);
        p.comment = "Maximum level of the magnets.";
        this.MagnetMaxLevel = p.getInt();
    }
}

