/*
 * Decompiled with CFR 0.152.
 */
package magicbees.bees;

import cpw.mods.fml.common.FMLLog;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeMutation;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IMutation;
import java.util.ArrayList;
import java.util.Collection;
import magicbees.bees.Allele;
import magicbees.bees.BeeManager;
import magicbees.bees.BeeSpecies;
import magicbees.main.Config;
import magicbees.main.utils.LocalizationManager;
import magicbees.main.utils.MoonPhase;
import magicbees.main.utils.compat.ArsMagicaHelper;
import magicbees.main.utils.compat.EquivalentExchangeHelper;
import magicbees.main.utils.compat.ExtraBeesHelper;
import magicbees.main.utils.compat.ForestryHelper;
import magicbees.main.utils.compat.RedstoneArsenalHelper;
import magicbees.main.utils.compat.ThaumcraftHelper;
import magicbees.main.utils.compat.ThermalExpansionHelper;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.oredict.OreDictionary;

public class BeeMutation
implements IBeeMutation {
    private IAllele parent1;
    private IAllele parent2;
    private IAllele[] mutationTemplate;
    private int baseChance;
    private boolean isSecret;
    private boolean isMoonRestricted;
    private MoonPhase moonPhaseStart;
    private MoonPhase moonPhaseEnd;
    private float moonPhaseMutationBonus;
    private boolean nodeRequired;
    private double nodeRange;
    private boolean requiresBlock;
    private int requiredBlockId;
    private int requiredBlockMeta;
    private String requiredBlockOreDictEntry;
    private String requiredBlockName;
    private BiomeDictionary.Type requiredBiomeType;

    public static void setupMutations() {
        BeeMutation mutation;
        BeeSpecies baseA;
        BeeSpecies[] magicMundane = new BeeSpecies[]{BeeSpecies.MYSTICAL, BeeSpecies.SORCEROUS, BeeSpecies.UNUSUAL, BeeSpecies.ATTUNED};
        String[] forestryMundane = new String[]{"Forest", "Meadows", "Modest", "Wintry", "Tropical", "Marshy"};
        String[] binnieMundane = new String[]{"marble", "rock", "water", "basalt"};
        for (BeeSpecies species : magicMundane) {
            for (String str : forestryMundane) {
                new BeeMutation((IAlleleBeeSpecies)species, Allele.getBaseSpecies(str), ForestryHelper.getTemplateForestryForSpecies("Common"), 15);
            }
            if (ExtraBeesHelper.isActive()) {
                for (String str : binnieMundane) {
                    FMLLog.info((String)"Registering %s", (Object[])new Object[]{str});
                    try {
                        new BeeMutation((IAlleleBeeSpecies)species, Allele.getExtraSpecies(str), ForestryHelper.getTemplateForestryForSpecies("Common"), 15);
                    }
                    catch (Exception e) {
                        FMLLog.info((String)"Unable to register! This mutation will not be available.", (Object[])new Object[0]);
                    }
                }
            }
            new BeeMutation((IAlleleBeeSpecies)species, Allele.getBaseSpecies("Common"), ForestryHelper.getTemplateForestryForSpecies("Cultivated"), 12);
            new BeeMutation((IAlleleBeeSpecies)species, Allele.getBaseSpecies("Cultivated"), BeeSpecies.ELDRITCH, 12);
        }
        new BeeMutation(Allele.getBaseSpecies("Cultivated"), (IAlleleBeeSpecies)BeeSpecies.ELDRITCH, BeeSpecies.ESOTERIC, 10);
        new BeeMutation((IAlleleBeeSpecies)BeeSpecies.ELDRITCH, (IAlleleBeeSpecies)BeeSpecies.ESOTERIC, BeeSpecies.MYSTERIOUS, 8);
        new BeeMutation((IAlleleBeeSpecies)BeeSpecies.ESOTERIC, (IAlleleBeeSpecies)BeeSpecies.MYSTERIOUS, BeeSpecies.ARCANE, 8).setMoonPhaseBonus(MoonPhase.WAXING_CRESCENT, MoonPhase.WAXING_GIBBOUS, 1.2f);
        new BeeMutation(Allele.getBaseSpecies("Cultivated"), (IAlleleBeeSpecies)BeeSpecies.ELDRITCH, BeeSpecies.CHARMED, 10);
        new BeeMutation((IAlleleBeeSpecies)BeeSpecies.ELDRITCH, (IAlleleBeeSpecies)BeeSpecies.CHARMED, BeeSpecies.ENCHANTED, 8);
        new BeeMutation((IAlleleBeeSpecies)BeeSpecies.CHARMED, (IAlleleBeeSpecies)BeeSpecies.ENCHANTED, BeeSpecies.SUPERNATURAL, 8).setMoonPhaseBonus(MoonPhase.WANING_GIBBOUS, MoonPhase.WANING_CRESCENT, 1.2f);
        new BeeMutation((IAlleleBeeSpecies)BeeSpecies.ARCANE, (IAlleleBeeSpecies)BeeSpecies.SUPERNATURAL, BeeSpecies.ETHEREAL, 7);
        new BeeMutation((IAlleleBeeSpecies)BeeSpecies.SUPERNATURAL, (IAlleleBeeSpecies)BeeSpecies.ETHEREAL, BeeSpecies.WINDY, 14).setBlockRequired(18);
        new BeeMutation((IAlleleBeeSpecies)BeeSpecies.SUPERNATURAL, (IAlleleBeeSpecies)BeeSpecies.ETHEREAL, BeeSpecies.WATERY, 14).setBlockRequired(Block.field_71943_B);
        new BeeMutation((IAlleleBeeSpecies)BeeSpecies.SUPERNATURAL, (IAlleleBeeSpecies)BeeSpecies.ETHEREAL, BeeSpecies.EARTHY, 100).setBlockRequired(Block.field_72081_al);
        new BeeMutation((IAlleleBeeSpecies)BeeSpecies.SUPERNATURAL, (IAlleleBeeSpecies)BeeSpecies.ETHEREAL, BeeSpecies.FIREY, 14).setBlockRequired(Block.field_71938_D);
        new BeeMutation((IAlleleBeeSpecies)BeeSpecies.ETHEREAL, (IAlleleBeeSpecies)BeeSpecies.ATTUNED, BeeSpecies.AWARE, 10);
        new BeeMutation((IAlleleBeeSpecies)BeeSpecies.ETHEREAL, (IAlleleBeeSpecies)BeeSpecies.AWARE, BeeSpecies.SPIRIT, 8);
        new BeeMutation((IAlleleBeeSpecies)BeeSpecies.ATTUNED, (IAlleleBeeSpecies)BeeSpecies.AWARE, BeeSpecies.SPIRIT, 8);
        new BeeMutation((IAlleleBeeSpecies)BeeSpecies.AWARE, (IAlleleBeeSpecies)BeeSpecies.SPIRIT, BeeSpecies.SOUL, 7);
        new BeeMutation(Allele.getBaseSpecies("Monastic"), (IAlleleBeeSpecies)BeeSpecies.ARCANE, BeeSpecies.PUPIL, 10);
        new BeeMutation((IAlleleBeeSpecies)BeeSpecies.ARCANE, (IAlleleBeeSpecies)BeeSpecies.PUPIL, BeeSpecies.SCHOLARLY, 8);
        new BeeMutation((IAlleleBeeSpecies)BeeSpecies.PUPIL, (IAlleleBeeSpecies)BeeSpecies.SCHOLARLY, BeeSpecies.SAVANT, 6);
        new BeeMutation(Allele.getBaseSpecies("Imperial"), (IAlleleBeeSpecies)BeeSpecies.ETHEREAL, BeeSpecies.TIMELY, 8);
        new BeeMutation(Allele.getBaseSpecies("Imperial"), (IAlleleBeeSpecies)BeeSpecies.TIMELY, BeeSpecies.LORDLY, 8);
        new BeeMutation((IAlleleBeeSpecies)BeeSpecies.TIMELY, (IAlleleBeeSpecies)BeeSpecies.LORDLY, BeeSpecies.DOCTORAL, 7);
        new BeeMutation((IAlleleBeeSpecies)BeeSpecies.INFERNAL, (IAlleleBeeSpecies)BeeSpecies.ELDRITCH, BeeSpecies.HATEFUL, 9).setBiomeRequired(BiomeDictionary.Type.NETHER);
        new BeeMutation((IAlleleBeeSpecies)BeeSpecies.INFERNAL, (IAlleleBeeSpecies)BeeSpecies.HATEFUL, BeeSpecies.SPITEFUL, 7).setBiomeRequired(BiomeDictionary.Type.NETHER);
        new BeeMutation(Allele.getBaseSpecies("Demonic"), (IAlleleBeeSpecies)BeeSpecies.SPITEFUL, BeeSpecies.WITHERING, 6).setBiomeRequired(BiomeDictionary.Type.NETHER);
        new BeeMutation(Allele.getBaseSpecies("Modest"), (IAlleleBeeSpecies)BeeSpecies.ELDRITCH, BeeSpecies.SKULKING, 12);
        new BeeMutation(Allele.getBaseSpecies("Tropical"), (IAlleleBeeSpecies)BeeSpecies.SKULKING, BeeSpecies.SPIDERY, 10);
        new BeeMutation((IAlleleBeeSpecies)BeeSpecies.SKULKING, (IAlleleBeeSpecies)BeeSpecies.ETHEREAL, BeeSpecies.GHASTLY, 9);
        new BeeMutation((IAlleleBeeSpecies)BeeSpecies.SKULKING, (IAlleleBeeSpecies)BeeSpecies.HATEFUL, BeeSpecies.SMOULDERING, 7).setBiomeRequired(BiomeDictionary.Type.NETHER);
        new BeeMutation((IAlleleBeeSpecies)BeeSpecies.ETHEREAL, (IAlleleBeeSpecies)BeeSpecies.OBLIVION, BeeSpecies.NAMELESS, 10);
        new BeeMutation((IAlleleBeeSpecies)BeeSpecies.OBLIVION, (IAlleleBeeSpecies)BeeSpecies.NAMELESS, BeeSpecies.ABANDONED, 8);
        new BeeMutation((IAlleleBeeSpecies)BeeSpecies.NAMELESS, (IAlleleBeeSpecies)BeeSpecies.ABANDONED, BeeSpecies.FORLORN, 6);
        new BeeMutation(Allele.getBaseSpecies("Imperial"), (IAlleleBeeSpecies)BeeSpecies.ABANDONED, BeeSpecies.DRACONIC, 6).setBiomeRequired(BiomeDictionary.Type.END);
        new BeeMutation((IAlleleBeeSpecies)BeeSpecies.UNUSUAL, (IAlleleBeeSpecies)BeeSpecies.ELDRITCH, BeeSpecies.MUTABLE, 12);
        new BeeMutation((IAlleleBeeSpecies)BeeSpecies.UNUSUAL, (IAlleleBeeSpecies)BeeSpecies.MUTABLE, BeeSpecies.TRANSMUTING, 9);
        new BeeMutation((IAlleleBeeSpecies)BeeSpecies.UNUSUAL, (IAlleleBeeSpecies)BeeSpecies.MUTABLE, BeeSpecies.CRUMBLING, 9);
        new BeeMutation((IAlleleBeeSpecies)BeeSpecies.MYSTICAL, (IAlleleBeeSpecies)BeeSpecies.MUTABLE, BeeSpecies.INVISIBLE, 15);
        if (BeeSpecies.COPPER.isActive()) {
            new BeeMutation(Allele.getBaseSpecies("Industrious"), Allele.getBaseSpecies("Meadows"), BeeSpecies.COPPER, 12).setBlockRequired("blockCopper");
        }
        if (BeeSpecies.TIN.isActive()) {
            new BeeMutation(Allele.getBaseSpecies("Industrious"), Allele.getBaseSpecies("Forest"), BeeSpecies.TIN, 12).setBlockRequired("blockTin");
        }
        new BeeMutation(Allele.getBaseSpecies("Common"), Allele.getBaseSpecies("Industrious"), BeeSpecies.IRON, 12).setBlockRequired(Block.field_72083_ai);
        if (BeeSpecies.LEAD.isActive()) {
            baseA = BeeSpecies.TIN.isActive() ? BeeSpecies.TIN : (BeeSpecies.COPPER.isActive() ? BeeSpecies.COPPER : BeeSpecies.IRON);
            mutation = new BeeMutation((IAlleleBeeSpecies)baseA, Allele.getBaseSpecies("Common"), BeeSpecies.LEAD, 10);
            if (OreDictionary.getOres((String)"blockLead").size() > 0) {
                mutation.setBlockRequired("blockLead");
            }
        }
        if (BeeSpecies.SILVER.isActive()) {
            mutation = new BeeMutation(Allele.getBaseSpecies("Imperial"), Allele.getBaseSpecies("Modest"), BeeSpecies.SILVER, 8);
            if (OreDictionary.getOres((String)"blockSilver").size() > 0) {
                mutation.setBlockRequired("blockSilver");
            }
        }
        baseA = BeeSpecies.EE_MINIUM.isActive() ? BeeSpecies.EE_MINIUM : Allele.getBaseSpecies("Imperial");
        BeeSpecies baseB = BeeSpecies.LEAD.isActive() ? BeeSpecies.LEAD : BeeSpecies.IRON;
        new BeeMutation((IAlleleBeeSpecies)baseA, (IAlleleBeeSpecies)baseB, BeeSpecies.GOLD, 8).setBlockRequired(Block.field_72105_ah);
        if (BeeSpecies.ALUMINUM.isActive()) {
            new BeeMutation(Allele.getBaseSpecies("Industrious"), Allele.getBaseSpecies("Cultivated"), BeeSpecies.ALUMINUM, 10).setBlockRequired("blockAluminum");
        }
        if (BeeSpecies.ARDITE.isActive()) {
            new BeeMutation(Allele.getBaseSpecies("Industrious"), (IAlleleBeeSpecies)BeeSpecies.INFERNAL, BeeSpecies.ARDITE, 9).setBlockRequired("blockArdite");
        }
        if (BeeSpecies.COBALT.isActive()) {
            new BeeMutation(Allele.getBaseSpecies("Imperial"), (IAlleleBeeSpecies)BeeSpecies.INFERNAL, BeeSpecies.COBALT, 9).setBlockRequired("blockCobalt");
        }
        if (BeeSpecies.MANYULLYN.isActive()) {
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.ARDITE, (IAlleleBeeSpecies)BeeSpecies.COBALT, BeeSpecies.MANYULLYN, 9).setBlockRequired("blockManyullyn");
        }
        new BeeMutation(Allele.getBaseSpecies("Austere"), (IAlleleBeeSpecies)BeeSpecies.GOLD, BeeSpecies.DIAMOND, 7).setBlockRequired(Block.field_72071_ax);
        baseA = BeeSpecies.SILVER.isActive() ? BeeSpecies.SILVER : Allele.getBaseSpecies("Imperial");
        new BeeMutation(Allele.getBaseSpecies("Austere"), (IAlleleBeeSpecies)baseA, BeeSpecies.EMERALD, 6).setBlockRequired(Block.field_72076_bV);
        new BeeMutation(Allele.getBaseSpecies("Rural"), (IAlleleBeeSpecies)BeeSpecies.COPPER, BeeSpecies.APATITE, 12).setBlockRequired("oreApatite");
        if (ThaumcraftHelper.isActive()) {
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.WINDY, (IAlleleBeeSpecies)BeeSpecies.WINDY, BeeSpecies.TC_AIR, 8).setBlockAndMetaRequired(Config.tcCrystal, ThaumcraftHelper.ShardType.AIR.ordinal());
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.FIREY, (IAlleleBeeSpecies)BeeSpecies.FIREY, BeeSpecies.TC_FIRE, 8).setBlockAndMetaRequired(Config.tcCrystal, ThaumcraftHelper.ShardType.FIRE.ordinal());
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.WATERY, (IAlleleBeeSpecies)BeeSpecies.WATERY, BeeSpecies.TC_WATER, 8).setBlockAndMetaRequired(Config.tcCrystal, ThaumcraftHelper.ShardType.WATER.ordinal());
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.EARTHY, (IAlleleBeeSpecies)BeeSpecies.EARTHY, BeeSpecies.TC_EARTH, 8).setBlockAndMetaRequired(Config.tcCrystal, ThaumcraftHelper.ShardType.EARTH.ordinal());
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.ETHEREAL, (IAlleleBeeSpecies)BeeSpecies.ARCANE, BeeSpecies.TC_ORDER, 8).setBlockAndMetaRequired(Config.tcCrystal, ThaumcraftHelper.ShardType.ORDER.ordinal());
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.ETHEREAL, (IAlleleBeeSpecies)BeeSpecies.SUPERNATURAL, BeeSpecies.TC_CHAOS, 8).setBlockAndMetaRequired(Config.tcCrystal, ThaumcraftHelper.ShardType.CHAOS.ordinal());
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.SKULKING, (IAlleleBeeSpecies)BeeSpecies.WINDY, BeeSpecies.TC_BATTY, 9);
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.SKULKING, (IAlleleBeeSpecies)BeeSpecies.PUPIL, BeeSpecies.TC_BRAINY, 9);
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.ETHEREAL, (IAlleleBeeSpecies)BeeSpecies.GHASTLY, BeeSpecies.TC_WISPY, 9).setMoonPhaseRestricted(MoonPhase.WANING_CRESCENT, MoonPhase.WAXING_CRESCENT);
            new BeeMutation(Allele.getBaseSpecies("Common"), (IAlleleBeeSpecies)BeeSpecies.SKULKING, BeeSpecies.TC_CHICKEN, 12).setBiomeRequired(BiomeDictionary.Type.FOREST);
            new BeeMutation(Allele.getBaseSpecies("Common"), (IAlleleBeeSpecies)BeeSpecies.SKULKING, BeeSpecies.TC_BEEF, 12).setBiomeRequired(BiomeDictionary.Type.PLAINS);
            new BeeMutation(Allele.getBaseSpecies("Common"), (IAlleleBeeSpecies)BeeSpecies.SKULKING, BeeSpecies.TC_PORK, 12).setBiomeRequired(BiomeDictionary.Type.MOUNTAIN);
        }
        if (ArsMagicaHelper.isActive()) {
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.ARCANE, (IAlleleBeeSpecies)BeeSpecies.ETHEREAL, BeeSpecies.AM_ESSENCE, 10);
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.ARCANE, (IAlleleBeeSpecies)BeeSpecies.AM_ESSENCE, BeeSpecies.AM_QUINTESSENCE, 7);
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.AM_ESSENCE, (IAlleleBeeSpecies)BeeSpecies.WINDY, BeeSpecies.AM_AIR, 10);
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.AM_ESSENCE, (IAlleleBeeSpecies)BeeSpecies.EARTHY, BeeSpecies.AM_EARTH, 10);
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.AM_ESSENCE, (IAlleleBeeSpecies)BeeSpecies.FIREY, BeeSpecies.AM_FIRE, 10);
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.AM_ESSENCE, (IAlleleBeeSpecies)BeeSpecies.WATERY, BeeSpecies.AM_WATER, 10);
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.AM_ESSENCE, (IAlleleBeeSpecies)BeeSpecies.ETHEREAL, BeeSpecies.AM_ARCANE, 10);
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.WINDY, (IAlleleBeeSpecies)BeeSpecies.AM_AIR, BeeSpecies.AM_LIGHTNING, 8);
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.EARTHY, (IAlleleBeeSpecies)BeeSpecies.AM_EARTH, BeeSpecies.AM_PLANT, 8);
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.WATERY, (IAlleleBeeSpecies)BeeSpecies.AM_WATER, BeeSpecies.AM_ICE, 8);
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.SKULKING, (IAlleleBeeSpecies)BeeSpecies.AM_ESSENCE, BeeSpecies.AM_VORTEX, 8);
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.SKULKING, (IAlleleBeeSpecies)BeeSpecies.GHASTLY, BeeSpecies.AM_WIGHT, 8);
        }
        if (EquivalentExchangeHelper.isActive()) {
            new BeeMutation(Allele.getBaseSpecies("Frugal"), (IAlleleBeeSpecies)BeeSpecies.MUTABLE, BeeSpecies.EE_MINIUM, 8);
        }
        if (RedstoneArsenalHelper.isActive()) {
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.TE_ELECTRUM, (IAlleleBeeSpecies)BeeSpecies.TE_DESTABILIZED, BeeSpecies.RSA_FLUXED, 10).setBlockRequired("blockElectrumFlux");
        }
        if (ThermalExpansionHelper.isActive()) {
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.TIN, (IAlleleBeeSpecies)BeeSpecies.COPPER, BeeSpecies.TE_BRONZE, 12).setBlockRequired("blockBronze");
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.GOLD, (IAlleleBeeSpecies)BeeSpecies.SILVER, BeeSpecies.TE_ELECTRUM, 10).setBlockRequired("blockElectrum");
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.IRON, (IAlleleBeeSpecies)BeeSpecies.ESOTERIC, BeeSpecies.TE_NICKEL, 14).setBlockRequired("blockNickel");
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.IRON, (IAlleleBeeSpecies)BeeSpecies.TE_NICKEL, BeeSpecies.TE_INVAR, 14).setBlockRequired("blockInvar");
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.TE_NICKEL, (IAlleleBeeSpecies)BeeSpecies.TE_INVAR, BeeSpecies.TE_PLATINUM, 10).setBlockRequired("blockPlatinum");
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.TIN, (IAlleleBeeSpecies)BeeSpecies.COPPER, BeeSpecies.TE_BRONZE, 12).setBlockRequired("blockBronze");
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.SPITEFUL, (IAlleleBeeSpecies)BeeSpecies.TIN, BeeSpecies.TE_COAL, 12).setBlockRequired(Block.field_71950_I);
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.SPITEFUL, Allele.getBaseSpecies("Industrious"), BeeSpecies.TE_DESTABILIZED, 12).setBlockRequired(Block.field_72047_aN);
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.SMOULDERING, (IAlleleBeeSpecies)BeeSpecies.INFERNAL, BeeSpecies.TE_LUX, 12).setBlockRequired(Block.field_72014_bd);
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.SMOULDERING, Allele.getBaseSpecies("Austere"), BeeSpecies.TE_DANTE, 12).setBiomeRequired(BiomeDictionary.Type.NETHER);
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.TE_DANTE, (IAlleleBeeSpecies)BeeSpecies.TE_COAL, BeeSpecies.TE_PYRO, 8).setBiomeRequired(BiomeDictionary.Type.NETHER);
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.SKULKING, Allele.getBaseSpecies("Wintry"), BeeSpecies.TE_BLIZZY, 12);
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.TE_BLIZZY, Allele.getBaseSpecies("Icy"), BeeSpecies.TE_GELID, 8);
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.TE_PLATINUM, (IAlleleBeeSpecies)BeeSpecies.OBLIVION, BeeSpecies.TE_WINSOME, 12);
            new BeeMutation((IAlleleBeeSpecies)BeeSpecies.TE_WINSOME, (IAlleleBeeSpecies)BeeSpecies.TE_COAL, BeeSpecies.TE_ENDEARING, 8).setBlockRequired("blockEnderium");
        }
    }

    public BeeMutation(IAlleleBeeSpecies species0, IAlleleBeeSpecies species1, BeeSpecies resultSpecies, int percentChance) {
        this(species0, species1, resultSpecies.getGenome(), percentChance);
    }

    public BeeMutation(IAlleleBeeSpecies species0, IAlleleBeeSpecies species1, IAllele[] resultSpeciesGenome, int percentChance) {
        this.parent1 = species0;
        this.parent2 = species1;
        this.mutationTemplate = resultSpeciesGenome;
        this.baseChance = percentChance;
        this.isSecret = false;
        this.isMoonRestricted = false;
        this.moonPhaseMutationBonus = -1.0f;
        this.requiresBlock = false;
        this.requiredBlockMeta = Short.MAX_VALUE;
        this.requiredBlockOreDictEntry = null;
        this.requiredBiomeType = null;
        this.requiredBlockName = null;
        BeeManager.beeRoot.registerMutation((IMutation)this);
    }

    public float getChance(IBeeHousing housing, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1) {
        float finalChance = 0.0f;
        float chance = (float)this.baseChance * 1.0f;
        if (this.arePartners(allele0, allele1)) {
            if (this.moonPhaseStart != null && this.moonPhaseEnd != null) {
                if (this.isMoonRestricted && !MoonPhase.getMoonPhase(housing.getWorld()).isBetween(this.moonPhaseStart, this.moonPhaseEnd)) {
                    chance = 0.0f;
                } else if (this.moonPhaseMutationBonus != -1.0f && MoonPhase.getMoonPhase(housing.getWorld()).isBetween(this.moonPhaseStart, this.moonPhaseEnd)) {
                    chance = (int)(chance * this.moonPhaseMutationBonus);
                }
            }
            if (this.requiresBlock) {
                int blockMeta;
                int blockId;
                Block blockBelow;
                int i = 1;
                do {
                    blockId = housing.getWorld().func_72798_a(housing.getXCoord(), housing.getYCoord() - i, housing.getZCoord());
                    blockMeta = housing.getWorld().func_72805_g(housing.getXCoord(), housing.getYCoord() - i, housing.getZCoord());
                    blockBelow = Block.field_71973_m[blockId];
                    ++i;
                } while (blockBelow != null && (blockBelow instanceof IBeeHousing || blockBelow == Config.fAlvearyBlock));
                if (this.requiredBlockOreDictEntry != null) {
                    int dicId = OreDictionary.getOreID((ItemStack)new ItemStack(blockId, 1, blockMeta));
                    if (dicId != -1) {
                        if (!OreDictionary.getOreName((int)dicId).equals(this.requiredBlockOreDictEntry)) {
                            chance = 0.0f;
                        }
                    } else {
                        chance = 0.0f;
                    }
                } else if (this.requiredBlockId != blockId || this.requiredBlockMeta != Short.MAX_VALUE && this.requiredBlockMeta != blockMeta) {
                    chance = 0.0f;
                }
            }
            if (this.requiredBiomeType != null) {
                BiomeDictionary.Type[] types = BiomeDictionary.getTypesForBiome((BiomeGenBase)housing.getWorld().func_72807_a(housing.getXCoord(), housing.getZCoord()));
                boolean found = false;
                for (int i = 0; i < types.length; ++i) {
                    if (this.requiredBiomeType != types[i]) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    chance = 0.0f;
                }
            }
            finalChance = Math.round(chance * housing.getMutationModifier((IBeeGenome)genome0, (IBeeGenome)genome1, chance) * BeeManager.beeRoot.getBeekeepingMode(housing.getWorld()).getMutationModifier((IBeeGenome)genome0, (IBeeGenome)genome1, chance));
        }
        return finalChance;
    }

    public IAllele getAllele0() {
        return this.parent1;
    }

    public IAllele getAllele1() {
        return this.parent2;
    }

    public IAllele[] getTemplate() {
        return this.mutationTemplate;
    }

    public float getBaseChance() {
        return this.baseChance;
    }

    public boolean isPartner(IAllele allele) {
        return this.parent1.getUID().equals(allele.getUID()) || this.parent2.getUID().equals(allele.getUID());
    }

    public IAllele getPartner(IAllele allele) {
        IAllele val = this.parent1;
        if (val.getUID().equals(allele.getUID())) {
            val = this.parent2;
        }
        return val;
    }

    public Collection<String> getSpecialConditions() {
        ArrayList<String> conditions = new ArrayList<String>();
        if (this.isMoonRestricted && this.moonPhaseStart != null && this.moonPhaseEnd != null) {
            if (this.moonPhaseStart != this.moonPhaseEnd) {
                conditions.add(String.format(LocalizationManager.getLocalizedString("research.requiresPhase"), this.moonPhaseStart.getLocalizedName(), this.moonPhaseEnd.getLocalizedName()));
            } else {
                conditions.add(String.format(LocalizationManager.getLocalizedString("research.requiresPhaseSingle"), this.moonPhaseStart.getLocalizedName()));
            }
        }
        if (this.requiresBlock) {
            if (this.requiredBlockName != null) {
                conditions.add(String.format(LocalizationManager.getLocalizedString("research.requiresBlock"), LocalizationManager.getLocalizedString(this.requiredBlockName)));
            } else if (this.requiredBlockOreDictEntry != null) {
                ArrayList ores = OreDictionary.getOres((String)this.requiredBlockOreDictEntry);
                if (ores.size() > 0) {
                    conditions.add(String.format(LocalizationManager.getLocalizedString("research.requiresBlock"), ((ItemStack)ores.get(0)).func_82833_r()));
                }
            } else {
                int meta = 0;
                if (this.requiredBlockMeta != Short.MAX_VALUE) {
                    meta = this.requiredBlockMeta;
                }
                conditions.add(String.format(LocalizationManager.getLocalizedString("research.requiresBlock"), new ItemStack(this.requiredBlockId, 1, this.requiredBlockMeta).func_82833_r()));
            }
        }
        if (this.requiredBiomeType != null) {
            String biomeName = this.requiredBiomeType.name().substring(0, 1) + this.requiredBiomeType.name().substring(1).toLowerCase();
            conditions.add(String.format(LocalizationManager.getLocalizedString("research.requiresBiome"), biomeName));
        }
        return conditions;
    }

    public IBeeRoot getRoot() {
        return BeeManager.beeRoot;
    }

    public boolean arePartners(IAllele alleleA, IAllele alleleB) {
        return this.parent1.getUID().equals(alleleA.getUID()) && this.parent2.getUID().equals(alleleB.getUID()) || this.parent1.getUID().equals(alleleB.getUID()) && this.parent2.getUID().equals(alleleA.getUID());
    }

    public BeeMutation setSecret() {
        this.isSecret = true;
        return this;
    }

    public boolean isSecret() {
        return this.isSecret;
    }

    public BeeMutation setBlockRequired(int blockId) {
        this.requiresBlock = true;
        this.requiredBlockId = blockId;
        return this;
    }

    public BeeMutation setBlockRequired(Block block) {
        this.requiresBlock = true;
        this.requiredBlockId = block.field_71990_ca;
        return this;
    }

    public BeeMutation setBlockAndMetaRequired(int blockId, int meta) {
        this.requiresBlock = true;
        this.requiredBlockId = blockId;
        this.requiredBlockMeta = meta;
        return this;
    }

    public BeeMutation setBlockAndMetaRequired(Block block, int meta) {
        this.requiresBlock = true;
        this.requiredBlockId = block.field_71990_ca;
        this.requiredBlockMeta = meta;
        return this;
    }

    public BeeMutation setBlockRequired(String oreDictEntry) {
        this.requiresBlock = true;
        this.requiredBlockOreDictEntry = oreDictEntry;
        return this;
    }

    public BeeMutation setBlockRequiredNameOverride(String blockName) {
        this.requiredBlockName = blockName;
        return this;
    }

    public BeeMutation setMoonPhaseRestricted(MoonPhase begin, MoonPhase end) {
        this.isMoonRestricted = true;
        this.moonPhaseStart = begin;
        this.moonPhaseEnd = end;
        return this;
    }

    public BeeMutation setMoonPhaseBonus(MoonPhase begin, MoonPhase end, float mutationBonus) {
        this.moonPhaseMutationBonus = mutationBonus;
        this.moonPhaseStart = begin;
        this.moonPhaseEnd = end;
        return this;
    }

    public BeeMutation setBiomeRequired(BiomeDictionary.Type biomeType) {
        this.requiredBiomeType = biomeType;
        return this;
    }
}

