/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.util.crafting;

import cofh.util.ItemHelper;
import cofh.util.inventory.ComparableItemStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.oredict.OreDictionary;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.item.TEItems;

public class SawmillManager {
    private static Map<ComparableItemStackSawmill, RecipeSawmill> recipeMap = new HashMap<ComparableItemStackSawmill, RecipeSawmill>();
    private static ComparableItemStackSawmill query = new ComparableItemStackSawmill(new ItemStack(Block.field_71981_t));
    private static boolean allowOverwrite = false;

    public static RecipeSawmill getRecipe(ItemStack input) {
        if (input == null) {
            return null;
        }
        return recipeMap.get((Object)query.set(input));
    }

    public static boolean recipeExists(ItemStack input) {
        return SawmillManager.getRecipe(input) != null;
    }

    public static RecipeSawmill[] getRecipeList() {
        return recipeMap.values().toArray(new RecipeSawmill[0]);
    }

    public static void addDefaultRecipes() {
        SawmillManager.addRecipe(2400, new ItemStack(Block.field_71960_R), new ItemStack(Block.field_71988_x, 8), new ItemStack(Item.field_77767_aC, 1));
        SawmillManager.addRecipe(2400, new ItemStack(Item.field_77776_ba), new ItemStack(Block.field_71988_x, 3), new ItemStack(Block.field_72101_ab, 3));
        SawmillManager.addRecipe(2400, new ItemStack(Block.field_72093_an), new ItemStack(Block.field_71988_x, 6), new ItemStack(Item.field_77760_aL, 3));
        SawmillManager.addRecipe(2400, new ItemStack((Block)Block.field_72077_au), new ItemStack(Block.field_71988_x, 8));
        SawmillManager.addRecipe(2400, new ItemStack(Block.field_72060_ay), new ItemStack(Block.field_71988_x, 4));
        SawmillManager.addRecipe(2400, new ItemStack(Item.field_77792_au), new ItemStack(Block.field_71988_x, 2));
        SawmillManager.addRecipe(2400, new ItemStack(Item.field_77790_av), new ItemStack(Block.field_71988_x, 6));
        SawmillManager.addRecipe(2400, new ItemStack(Block.field_72046_aM), new ItemStack(Block.field_71988_x, 2));
        SawmillManager.addRecipe(2400, new ItemStack(Block.field_72032_aY), new ItemStack(Block.field_71988_x, 8), new ItemStack(Item.field_77702_n, 1));
        SawmillManager.addRecipe(2400, new ItemStack(Block.field_72005_bk), new ItemStack(Block.field_71988_x, 3));
        SawmillManager.addRecipe(2400, new ItemStack(Block.field_71993_bv), new ItemStack(Block.field_71988_x, 2), TEItems.sawdust);
        SawmillManager.addRecipe(2400, new ItemStack(Item.field_77769_aE), new ItemStack(Block.field_71988_x, 5));
        SawmillManager.addRecipe(1600, new ItemStack(Item.field_77715_r), new ItemStack(Block.field_71988_x, 2), TEItems.sawdust);
        SawmillManager.addRecipe(1600, new ItemStack(Item.field_77714_s), new ItemStack(Block.field_71988_x, 1), TEItems.sawdust);
        SawmillManager.addRecipe(1600, new ItemStack(Item.field_77713_t), new ItemStack(Block.field_71988_x, 3), TEItems.sawdust);
        SawmillManager.addRecipe(1600, new ItemStack(Item.field_77712_u), new ItemStack(Block.field_71988_x, 3), TEItems.sawdust);
        SawmillManager.addRecipe(1600, new ItemStack(Item.field_77678_N), new ItemStack(Block.field_71988_x, 2), TEItems.sawdust);
    }

    public static void loadRecipes() {
        SawmillManager.addDefaultRecipes();
        SawmillManager.addAllLogs();
        if (ItemHelper.oreNameExists((String)"woodRubber")) {
            if (ItemHelper.oreNameExists((String)"itemRawRubber")) {
                SawmillManager.addRecipe(1200, (ItemStack)OreDictionary.getOres((String)"woodRubber").get(0), new ItemStack(Block.field_71988_x, 5, 3), (ItemStack)OreDictionary.getOres((String)"itemRawRubber").get(0), 50);
            } else if (ItemHelper.oreNameExists((String)"itemRubber")) {
                SawmillManager.addRecipe(1200, (ItemStack)OreDictionary.getOres((String)"woodRubber").get(0), new ItemStack(Block.field_71988_x, 5, 3), (ItemStack)OreDictionary.getOres((String)"itemRubber").get(0), 50);
            } else {
                SawmillManager.addRecipe(1200, (ItemStack)OreDictionary.getOres((String)"woodRubber").get(0), new ItemStack(Block.field_71988_x, 5, 3));
            }
        }
    }

    public static boolean addTERecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        if (input == null || primaryOutput == null || energy <= 0) {
            return false;
        }
        RecipeSawmill recipe = new RecipeSawmill(input, primaryOutput, secondaryOutput, secondaryChance, energy);
        recipeMap.put(new ComparableItemStackSawmill(input), recipe);
        return true;
    }

    public static boolean addRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance, boolean overwrite) {
        if (input == null || primaryOutput == null || energy <= 0 || !(allowOverwrite & overwrite) && SawmillManager.recipeExists(input)) {
            return false;
        }
        RecipeSawmill recipe = new RecipeSawmill(input, primaryOutput, secondaryOutput, secondaryChance, energy);
        recipeMap.put(new ComparableItemStackSawmill(input), recipe);
        return true;
    }

    public static void addAllLogs() {
        Container tempContainer = new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        };
        InventoryCrafting tempCrafting = new InventoryCrafting(tempContainer, 3, 3);
        ArrayList recipeList = (ArrayList)CraftingManager.func_77594_a().func_77592_b();
        for (int i = 1; i < 9; ++i) {
            tempCrafting.func_70299_a(i, null);
        }
        ArrayList registeredOres = OreDictionary.getOres((String)"logWood");
        for (int i = 0; i < registeredOres.size(); ++i) {
            ItemStack logEntry = (ItemStack)registeredOres.get(i);
            if (logEntry.func_77960_j() == Short.MAX_VALUE) {
                for (int j = 0; j < 16; ++j) {
                    ItemStack log = new ItemStack(logEntry.field_77993_c, 1, j);
                    tempCrafting.func_70299_a(0, log);
                    ItemStack resultEntry = ItemHelper.findMatchingRecipe((InventoryCrafting)tempCrafting, null);
                    if (resultEntry == null) continue;
                    ItemStack result = resultEntry.func_77946_l();
                    result.field_77994_a = (int)((float)result.field_77994_a * 1.5f);
                    SawmillManager.addRecipe(800, log, result, TEItems.sawdust);
                }
                continue;
            }
            ItemStack log = ItemHelper.cloneStack((ItemStack)logEntry, (int)1);
            tempCrafting.func_70299_a(0, log);
            ItemStack resultEntry = ItemHelper.findMatchingRecipe((InventoryCrafting)tempCrafting, null);
            if (resultEntry == null) continue;
            ItemStack result = resultEntry.func_77946_l();
            result.field_77994_a = (int)((float)result.field_77994_a * 1.5f);
            SawmillManager.addRecipe(800, log, result, TEItems.sawdust);
        }
    }

    public static boolean addTERecipe(int energy, ItemStack input, ItemStack primaryOutput) {
        return SawmillManager.addTERecipe(energy, input, primaryOutput, null, 0);
    }

    public static boolean addTERecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput) {
        return SawmillManager.addTERecipe(energy, input, primaryOutput, secondaryOutput, 100);
    }

    public static boolean addRecipe(int energy, ItemStack input, ItemStack primaryOutput) {
        return SawmillManager.addRecipe(energy, input, primaryOutput, false);
    }

    public static boolean addRecipe(int energy, ItemStack input, ItemStack primaryOutput, boolean overwrite) {
        return SawmillManager.addRecipe(energy, input, primaryOutput, null, 0, overwrite);
    }

    public static boolean addRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput) {
        return SawmillManager.addRecipe(energy, input, primaryOutput, secondaryOutput, false);
    }

    public static boolean addRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, boolean overwrite) {
        return SawmillManager.addRecipe(energy, input, primaryOutput, secondaryOutput, 100, overwrite);
    }

    public static boolean addRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        return SawmillManager.addRecipe(energy, input, primaryOutput, secondaryOutput, secondaryChance, false);
    }

    static {
        allowOverwrite = ThermalExpansion.config.get("tweak.crafting", "Sawmill.AllowRecipeOverwrite", false);
    }

    public static class ComparableItemStackSawmill
    extends ComparableItemStack {
        static final String BLOCK = "block";
        static final String ORE = "ore";
        static final String DUST = "dust";
        static final String INGOT = "ingot";
        static final String NUGGET = "nugget";
        static final String RUBBER = "woodRubber";

        public static boolean safeOreType(String oreName) {
            return oreName.startsWith(BLOCK) || oreName.startsWith(ORE) || oreName.startsWith(DUST) || oreName.startsWith(INGOT) || oreName.startsWith(NUGGET) || oreName.equals(RUBBER);
        }

        public static int getOreID(ItemStack stack) {
            int id = OreDictionary.getOreID((ItemStack)stack);
            if (id == -1 || !ComparableItemStackSawmill.safeOreType(OreDictionary.getOreName((int)id))) {
                return -1;
            }
            return id;
        }

        public static int getOreID(String oreName) {
            if (!ComparableItemStackSawmill.safeOreType(oreName)) {
                return -1;
            }
            return OreDictionary.getOreID((String)oreName);
        }

        public ComparableItemStackSawmill(ItemStack stack) {
            super(stack);
            this.oreID = ComparableItemStackSawmill.getOreID(stack);
        }

        public ComparableItemStackSawmill(int itemID, int damage, int stackSize) {
            super(itemID, damage, stackSize);
            this.oreID = ComparableItemStackSawmill.getOreID(this.toItemStack());
        }

        public ComparableItemStackSawmill set(ItemStack stack) {
            super.set(stack);
            this.oreID = ComparableItemStackSawmill.getOreID(stack);
            return this;
        }
    }

    public static class RecipeSawmill {
        final ItemStack input;
        final ItemStack primaryOutput;
        final ItemStack secondaryOutput;
        final int secondaryChance;
        final int energy;

        RecipeSawmill(ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance, int energy) {
            this.input = input;
            this.primaryOutput = primaryOutput;
            this.secondaryOutput = secondaryOutput;
            this.secondaryChance = secondaryChance;
            this.energy = energy;
        }

        public ItemStack getInput() {
            return this.input.func_77946_l();
        }

        public ItemStack getPrimaryOutput() {
            return this.primaryOutput.func_77946_l();
        }

        public ItemStack getSecondaryOutput() {
            if (this.secondaryOutput == null) {
                return null;
            }
            return this.secondaryOutput.func_77946_l();
        }

        public int getSecondaryOutputChance() {
            return this.secondaryChance;
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

