/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.render;

import codechicken.lib.lighting.LightModel;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.IUVTransformation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import cofh.render.IconRegistry;
import cofh.render.RenderUtils;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import thermalexpansion.block.plate.TilePlateBase;
import thermalexpansion.core.TEProps;

public class RenderPlate
implements ISimpleBlockRenderingHandler {
    public static final RenderPlate instance = new RenderPlate();
    static Icon[] texture_frame = new Icon[7];
    static Icon[] texture_fluid = new Icon[3];
    static CCModel[] side_model = new CCModel[6];

    public static void initialize() {
        RenderPlate.texture_fluid[0] = IconRegistry.getIcon((String)"FluidRedstone");
        RenderPlate.texture_fluid[1] = IconRegistry.getIcon((String)"FluidGlowstone");
        RenderPlate.texture_fluid[2] = IconRegistry.getIcon((String)"FluidEnder");
        RenderPlate.texture_frame[6] = IconRegistry.getIcon((String)"PlateBottom");
        for (int i = 0; i < 6; ++i) {
            RenderPlate.texture_frame[i] = IconRegistry.getIcon((String)"PlateTop", (int)i);
        }
    }

    private static void generateModels() {
        double d = 9.765625E-4;
        RenderPlate.side_model[0] = CCModel.quadModel((int)24).generateBlock(0, d, d, d, 1.0 - d, 0.0625 - d, 1.0 - d).computeNormals().computeLighting(LightModel.standardLightModel);
        CCModel.generateSidedModels((CCModel[])side_model, (int)0, (Vector3)Vector3.zero);
    }

    public void render(int alignment, int direction, int type, double x, double y, double z) {
        Translation trans = RenderUtils.getRenderVector((double)x, (double)y, (double)z).translation();
        side_model[alignment].render(4, 4, (Transformation)trans, (IUVTransformation)RenderUtils.getIconTransformation((Icon)texture_fluid[type]), null);
        side_model[alignment].render(4, 4, (Transformation)trans, (IUVTransformation)RenderUtils.getIconTransformation((Icon)texture_frame[direction]), null);
        side_model[alignment].render(0, 4, (Transformation)trans, (IUVTransformation)RenderUtils.getIconTransformation((Icon)texture_frame[6]), null);
        for (int i = 8; i < 24; i += 4) {
            side_model[alignment].render(i, 4, (Transformation)trans, (IUVTransformation)RenderUtils.getIconTransformation((Icon)texture_frame[6]), null);
        }
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        RenderUtils.preRender();
        CCRenderState.startDrawing((int)7);
        this.render(0, 2, metadata % 3, 0.0, 0.0, 0.0);
        CCRenderState.draw();
        CCRenderState.useNormals((boolean)false);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntity aTile = world.func_72796_p(x, y, z);
        if (!(aTile instanceof TilePlateBase)) {
            return false;
        }
        TilePlateBase theTile = (TilePlateBase)aTile;
        RenderUtils.beforeWorldRender((IBlockAccess)world, (int)x, (int)y, (int)z);
        this.render(theTile.getAlignment(), theTile.getFacing(), theTile.getType(), x, y, z);
        RenderUtils.afterWorldRender((IBlockAccess)world, (int)x, (int)y, (int)z);
        return true;
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public int getRenderId() {
        return TEProps.renderIdPlate;
    }

    static {
        TEProps.renderIdPlate = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)instance);
        RenderPlate.generateModels();
    }
}

