/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.plugins.mfr;

import cofh.util.MathHelper;
import cpw.mods.fml.common.Loader;
import powercrystals.minefactoryreloaded.api.FactoryRegistry;
import powercrystals.minefactoryreloaded.api.ILiquidDrinkHandler;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.plugins.mfr.DrinkHandlerCoal;
import thermalexpansion.plugins.mfr.DrinkHandlerCryotheum;
import thermalexpansion.plugins.mfr.DrinkHandlerEnder;
import thermalexpansion.plugins.mfr.DrinkHandlerGlowstone;
import thermalexpansion.plugins.mfr.DrinkHandlerPyrotheum;
import thermalexpansion.plugins.mfr.DrinkHandlerRedstone;

public class MFRPlugin {
    public static boolean strawRedstone = true;
    public static boolean strawGlowstone = true;
    public static boolean strawEnder = true;
    public static boolean strawPyrotheum = true;
    public static boolean strawCryotheum = true;
    public static boolean strawCoal = true;
    public static int strawEnderRange = 16384;

    public static void preInit() {
        String category = "plugins.tweak";
        strawRedstone = ThermalExpansion.config.get(category, "MFR.Redstone.Straw", true);
        strawGlowstone = ThermalExpansion.config.get(category, "MFR.Glowstone.Straw", true);
        strawEnder = ThermalExpansion.config.get(category, "MFR.Ender.Straw", true);
        strawPyrotheum = ThermalExpansion.config.get(category, "MFR.Pyrotheum.Straw", true);
        strawCryotheum = ThermalExpansion.config.get(category, "MFR.Cryotheum.Straw", true);
        strawCoal = ThermalExpansion.config.get(category, "MFR.Coal.Straw", true);
        strawEnderRange = ThermalExpansion.config.get(category, "MFR.Ender.Range", strawEnderRange, "This controls the maximum distance (in blocks) a player will teleport from drinking Ender. (Max: 65536)");
        strawEnderRange = MathHelper.clampI((int)strawEnderRange, (int)8, (int)65536);
    }

    public static void initialize() {
    }

    public static void postInit() {
        if (Loader.isModLoaded((String)"MineFactoryReloaded")) {
            if (strawRedstone) {
                FactoryRegistry.registerLiquidDrinkHandler((String)"redstone", (ILiquidDrinkHandler)DrinkHandlerRedstone.instance);
            }
            if (strawGlowstone) {
                FactoryRegistry.registerLiquidDrinkHandler((String)"glowstone", (ILiquidDrinkHandler)DrinkHandlerGlowstone.instance);
            }
            if (strawEnder) {
                FactoryRegistry.registerLiquidDrinkHandler((String)"ender", (ILiquidDrinkHandler)DrinkHandlerEnder.instance);
            }
            if (strawPyrotheum) {
                FactoryRegistry.registerLiquidDrinkHandler((String)"pyrotheum", (ILiquidDrinkHandler)DrinkHandlerPyrotheum.instance);
            }
            if (strawCryotheum) {
                FactoryRegistry.registerLiquidDrinkHandler((String)"cryotheum", (ILiquidDrinkHandler)DrinkHandlerCryotheum.instance);
            }
            if (strawCoal) {
                FactoryRegistry.registerLiquidDrinkHandler((String)"coal", (ILiquidDrinkHandler)DrinkHandlerCoal.instance);
            }
            ThermalExpansion.log.info("MineFactoryReloaded Plugin Enabled.");
        }
    }
}

