/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.gui.client;

import cofh.api.tileentity.IRedstoneControl;
import cofh.core.CoFHProps;
import cofh.gui.GuiBase;
import cofh.gui.GuiBaseAdv;
import cofh.gui.element.ElementBase;
import cofh.gui.element.ElementButton;
import cofh.gui.element.ElementEnergyStored;
import cofh.gui.element.TabBase;
import cofh.gui.element.TabInfo;
import cofh.gui.element.TabRedstone;
import cofh.gui.element.TabTutorial;
import cofh.util.StringHelper;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import thermalexpansion.block.energycell.TileEnergyCell;
import thermalexpansion.gui.container.ContainerTEBase;
import thermalexpansion.gui.element.TabConfigEnergyCell;

public class GuiEnergyCell
extends GuiBaseAdv {
    static final String TEX_PATH = "thermalexpansion:textures/gui/EnergyCell.png";
    static final ResourceLocation TEXTURE = new ResourceLocation("thermalexpansion:textures/gui/EnergyCell.png");
    static final String INFO = "Stores Redstone Flux. Hold Shift or Ctrl to fine tune energy control.\n\nWrench while sneaking to dismantle.";
    TileEnergyCell myTile;
    public ElementButton decRecv;
    public ElementButton incRecv;
    public ElementButton decSend;
    public ElementButton incSend;

    public GuiEnergyCell(InventoryPlayer inventory, TileEntity theTile) {
        super((Container)new ContainerTEBase(inventory, theTile), TEXTURE);
        this.myTile = (TileEnergyCell)theTile;
        this.name = this.myTile.getName();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.addElement((ElementBase)new ElementEnergyStored((GuiBase)this, 80, 18, this.myTile.getEnergyStorage()));
        this.addTab((TabBase)new TabRedstone((GuiBase)this, (IRedstoneControl)this.myTile));
        this.addTab(new TabConfigEnergyCell((GuiBase)this, this.myTile));
        this.addTab((TabBase)new TabInfo((GuiBase)this, INFO, 1));
        this.addTab((TabBase)new TabTutorial((GuiBase)this, CoFHProps.tutorialTabRedstone + "\n\n" + TabConfigEnergyCell.TUTORIAL_CONFIG));
        this.decRecv = new ElementButton((GuiBase)this, 28, 56, "DecRecv", 176, 0, 176, 14, 176, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.incRecv = new ElementButton((GuiBase)this, 44, 56, "IncRecv", 190, 0, 190, 14, 190, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.decSend = new ElementButton((GuiBase)this, 118, 56, "DecSend", 176, 0, 176, 14, 176, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.incSend = new ElementButton((GuiBase)this, 134, 56, "IncSend", 190, 0, 190, 14, 190, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.addElement((ElementBase)this.decRecv);
        this.addElement((ElementBase)this.incRecv);
        this.addElement((ElementBase)this.decSend);
        this.addElement((ElementBase)this.incSend);
    }

    public void handleElementButtonClick(String buttonName, int mouseButton) {
        int change = 0;
        float pitch = 1.0f;
        if (GuiScreen.func_73877_p()) {
            change = 1000;
            pitch = 0.9f;
            if (mouseButton == 1) {
                change = 100;
                pitch = 0.8f;
            }
        } else if (GuiScreen.func_73861_o()) {
            change = 5;
            pitch = 0.5f;
            if (mouseButton == 1) {
                change = 1;
                pitch = 0.4f;
            }
        } else {
            change = 50;
            pitch = 0.7f;
            if (mouseButton == 1) {
                change = 10;
                pitch = 0.6f;
            }
        }
        if (buttonName.equalsIgnoreCase("DecRecv")) {
            this.myTile.energyReceive -= change;
            pitch -= 0.1f;
        } else if (buttonName.equalsIgnoreCase("IncRecv")) {
            this.myTile.energyReceive += change;
            pitch += 0.1f;
        } else if (buttonName.equalsIgnoreCase("DecSend")) {
            this.myTile.energySend -= change;
            pitch -= 0.1f;
        } else if (buttonName.equalsIgnoreCase("IncSend")) {
            this.myTile.energySend += change;
            pitch += 0.1f;
        }
        this.field_73882_e.field_71416_A.func_77366_a("random.click", 1.0f, pitch);
        this.myTile.sendModePacket();
    }

    protected void updateElements() {
        int change = 0;
        int change2 = 0;
        if (GuiScreen.func_73877_p()) {
            change = 1000;
            change2 = 100;
        } else if (GuiScreen.func_73861_o()) {
            change = 5;
            change2 = 1;
        } else {
            change = 50;
            change2 = 10;
        }
        if (this.myTile.energyReceive > 0) {
            this.decRecv.setActive();
            this.decRecv.setToolTip(StringHelper.localize((String)"info.thermalexpansion.cell.decRecv") + " " + change + "/" + change2);
        } else {
            this.decRecv.setDisabled();
            this.decRecv.clearToolTip();
        }
        if (this.myTile.energyReceive < TileEnergyCell.MAX_RECEIVE[this.myTile.type]) {
            this.incRecv.setActive();
            this.incRecv.setToolTip(StringHelper.localize((String)"info.thermalexpansion.cell.incRecv") + " " + change + "/" + change2);
        } else {
            this.incRecv.setDisabled();
            this.incRecv.clearToolTip();
        }
        if (this.myTile.energySend > 0) {
            this.decSend.setActive();
            this.decSend.setToolTip(StringHelper.localize((String)"info.thermalexpansion.cell.decSend") + " " + change + "/" + change2);
        } else {
            this.decSend.setDisabled();
            this.decSend.clearToolTip();
        }
        if (this.myTile.energySend < TileEnergyCell.MAX_SEND[this.myTile.type]) {
            this.incSend.setActive();
            this.incSend.setToolTip(StringHelper.localize((String)"info.thermalexpansion.cell.incSend") + " " + change + "/" + change2);
        } else {
            this.incSend.setDisabled();
            this.incSend.clearToolTip();
        }
    }

    protected void func_74189_g(int x, int y) {
        this.field_73886_k.func_78276_b(StringHelper.localize((String)"info.thermalexpansion.cell.maxIn") + ":", this.getCenteredOffset(StringHelper.localize((String)"info.thermalexpansion.cell.maxIn"), this.field_74194_b / 2), 32, 0x404040);
        this.field_73886_k.func_78276_b(StringHelper.localize((String)"info.thermalexpansion.cell.maxOut") + ":", this.field_74194_b / 2 + this.getCenteredOffset(StringHelper.localize((String)"info.thermalexpansion.cell.maxOut"), this.field_74194_b / 2), 32, 0x404040);
        String recv = String.format("%-8s", "" + this.myTile.energyReceive + " RF/t");
        String send = String.format("%-8s", "" + this.myTile.energySend + " RF/t");
        int xRecv = 20;
        int xSend = 110;
        if (this.myTile.energyReceive < 10) {
            xRecv = 32;
        } else if (this.myTile.energyReceive < 100) {
            xRecv = 26;
        }
        if (this.myTile.energySend < 10) {
            xSend = 122;
        } else if (this.myTile.energySend < 100) {
            xSend = 116;
        }
        this.field_73886_k.func_78276_b(recv, xRecv, 44, 0x404040);
        this.field_73886_k.func_78276_b(send, xSend, 44, 0x404040);
        super.func_74189_g(x, y);
    }
}

