/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.machine.BlockMachine;
import thermalexpansion.block.machine.TileMachineBase;
import thermalexpansion.block.machine.TileMachineEnergized;
import thermalexpansion.util.crafting.FurnaceManager;

public class TileFurnace
extends TileMachineEnergized {
    public static final int TYPE = BlockMachine.Types.FURNACE.ordinal();
    int outputTracker;

    public static void initialize() {
        TileFurnace.sideData[TileFurnace.TYPE] = new TileMachineBase.SideConfig();
        TileFurnace.sideData[TileFurnace.TYPE].numGroup = 3;
        TileFurnace.sideData[TileFurnace.TYPE].slotGroups = new int[][]{new int[0], {0}, {1}};
        TileFurnace.sideData[TileFurnace.TYPE].allowInsertion = new boolean[]{false, true, false};
        TileFurnace.sideData[TileFurnace.TYPE].allowExtraction = new boolean[]{false, false, true};
        TileFurnace.sideData[TileFurnace.TYPE].sideTex = new int[]{0, 1, 4};
        TileFurnace.energyData[TileFurnace.TYPE] = new TileMachineEnergized.EnergyConfig();
        energyData[TYPE].setEnergyParams(20);
        TileFurnace.guiIds[TileFurnace.TYPE] = ThermalExpansion.proxy.registerGui("Furnace", "machine", true);
        GameRegistry.registerTileEntity(TileFurnace.class, (String)"cofh.thermalexpansion.Furnace");
    }

    public TileFurnace() {
        this.sideCache = new byte[]{1, 1, 2, 2, 2, 2};
        this.inventory = new ItemStack[3];
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public boolean canStart() {
        if (this.inventory[0] == null) {
            return false;
        }
        FurnaceManager.RecipeFurnace recipe = FurnaceManager.getRecipe(this.inventory[0]);
        if (recipe == null || this.energyStorage.getEnergyStored() < recipe.getEnergy()) {
            return false;
        }
        ItemStack output = recipe.getOutput();
        if (output == null) {
            return false;
        }
        if (this.inventory[1] == null) {
            return true;
        }
        if (!this.inventory[1].func_77969_a(output)) {
            return false;
        }
        return this.inventory[1].field_77994_a + output.field_77994_a <= output.func_77976_d();
    }

    @Override
    protected boolean hasValidInput() {
        FurnaceManager.RecipeFurnace recipe = FurnaceManager.getRecipe(this.inventory[0]);
        return recipe == null ? false : recipe.getInput().field_77994_a <= this.inventory[0].field_77994_a;
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = FurnaceManager.getRecipe(this.inventory[0]).getEnergy();
    }

    @Override
    protected void processFinish() {
        ItemStack output = FurnaceManager.getRecipe(this.inventory[0]).getOutput();
        if (this.inventory[1] == null) {
            this.inventory[1] = output;
        } else {
            this.inventory[1].field_77994_a += output.field_77994_a;
        }
        --this.inventory[0].field_77994_a;
        if (this.inventory[0].field_77994_a <= 0) {
            this.inventory[0] = null;
        }
    }

    @Override
    protected void transferProducts() {
        if (this.inventory[1] == null) {
            return;
        }
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (this.sideCache[side] != 2 || !this.transferItem(1, 4, side)) continue;
            this.outputTracker = side;
            break;
        }
    }

    @Override
    public int getChargeSlot() {
        return 2;
    }

    @Override
    public boolean canAcceptItem(ItemStack stack, int slot, int side) {
        return slot == 0 ? FurnaceManager.recipeExists(stack) : true;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.outputTracker = nbt.func_74762_e("Tracker");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("Tracker", this.outputTracker);
    }
}

