/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.ender;

import cofh.api.tileentity.ISecureTile;
import cofh.render.IconRegistry;
import cofh.util.ServerHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.ShapedOreRecipe;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.BlockTEBase;
import thermalexpansion.block.ender.TileTesseract;
import thermalexpansion.core.TEProps;
import thermalexpansion.fluid.TEFluids;
import thermalexpansion.item.TEItems;
import thermalexpansion.util.crafting.TransposerManager;

public class BlockTesseract
extends BlockTEBase {
    public static boolean enable;
    public static ItemStack tesseract;
    public static ItemStack tesseractFrameEmpty;
    public static ItemStack tesseractFrameFull;
    public static final int TESSERACT_FRAME_FULL_ID = 129;

    public BlockTesseract(int id) {
        super(id, Material.field_76243_f);
        this.func_71848_c(15.0f);
        this.func_71894_b(2000.0f);
        this.func_71864_b("thermalexpansion.tesseract");
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TileTesseract();
    }

    public void func_71879_a(int itemId, CreativeTabs tab, List list) {
        list.add(new ItemStack(itemId, 1, 0));
    }

    public ArrayList<ItemStack> getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        NBTTagCompound tag = null;
        if (!secureOwner.equals("[None]")) {
            tag = new NBTTagCompound();
            tag.func_74778_a("Owner", secureOwner);
            tag.func_74774_a("Access", secureAccess);
            secureOwner = "[None]";
            secureAccess = 0;
        }
        ItemStack retStack = new ItemStack(this.field_71990_ca, 1, this.func_71899_b(metadata));
        retStack.func_77982_d(tag);
        ret.add(retStack);
        return ret;
    }

    @Override
    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase living, ItemStack stack) {
        if (ServerHelper.isServerWorld((World)world) && stack.field_77990_d != null && stack.field_77990_d.func_74764_b("Owner")) {
            TileTesseract tile = (TileTesseract)world.func_72796_p(x, y, z);
            tile.removeFromRegistry();
            tile.setOwnerName(stack.field_77990_d.func_74779_i("Owner"));
            tile.setAccess(ISecureTile.AccessMode.values()[stack.field_77990_d.func_74771_c("Access")]);
            tile.modeItem = stack.field_77990_d.func_74771_c("ModeItems");
            tile.modeFluid = stack.field_77990_d.func_74771_c("ModeFluid");
            tile.modeEnergy = stack.field_77990_d.func_74771_c("ModeEnergy");
            tile.setControlDisable(stack.field_77990_d.func_74767_n("Disable"));
            tile.setControlSetting(stack.field_77990_d.func_74767_n("Setting"));
            tile.frequency = stack.field_77990_d.func_74762_e("Frequency");
            tile.isActive = tile.frequency != -1;
            tile.addToRegistry();
            tile.sendDescPacket();
        }
        super.func_71860_a(world, x, y, z, living, stack);
    }

    public int func_71856_s_() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71857_b() {
        return TEProps.renderIdTesseract;
    }

    @Override
    public Icon func_71858_a(int side, int metadata) {
        return IconRegistry.getIcon((String)"Tesseract");
    }

    public boolean canRenderInPass(int pass) {
        renderPass = pass;
        return pass < 2;
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister ir) {
        IconRegistry.addIcon((String)"Tesseract", (String)"thermalexpansion:tesseract/Tesseract", (IconRegister)ir);
        IconRegistry.addIcon((String)"TesseractInner", (String)"thermalexpansion:tesseract/Tesseract_Inner", (IconRegister)ir);
        IconRegistry.addIcon((String)"TesseractActive", (String)"thermalexpansion:tesseract/Tesseract_Active", (IconRegister)ir);
        IconRegistry.addIcon((String)"TesseractInnerActive", (String)"thermalexpansion:tesseract/Tesseract_Inner_Active", (IconRegister)ir);
        IconRegistry.addIcon((String)"SkyEnder", (String)"thermalexpansion:tesseract/Sky_Ender", (IconRegister)ir);
    }

    @Override
    public NBTTagCompound getItemStackTag(World world, int x, int y, int z) {
        TileTesseract tile = (TileTesseract)world.func_72796_p(x, y, z);
        NBTTagCompound tag = super.getItemStackTag(world, x, y, z);
        if (tile != null) {
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            tag.func_74778_a("Owner", tile.getOwnerName());
            tag.func_74768_a("Frequency", tile.frequency);
            tag.func_74774_a("ModeItems", tile.modeItem);
            tag.func_74774_a("ModeFluid", tile.modeFluid);
            tag.func_74774_a("ModeEnergy", tile.modeEnergy);
            tag.func_74774_a("Access", (byte)tile.getAccess().ordinal());
            tag.func_74757_a("Disable", tile.getControlDisable());
            tag.func_74757_a("State", tile.getControlSetting());
        }
        return tag;
    }

    public ItemStack dismantleBlock(EntityPlayer player, World world, int x, int y, int z, boolean returnBlock) {
        TileTesseract tile = (TileTesseract)world.func_72796_p(x, y, z);
        if (tile != null) {
            tile.removeFromRegistry();
            tile.inventory = new ItemStack[0];
        }
        return super.dismantleBlock(player, this.getItemStackTag(world, x, y, z), world, x, y, z, returnBlock, false);
    }

    public boolean initialize() {
        tesseractFrameEmpty = TEItems.itemComponent.addItem(128, "tesseractFrameEmpty");
        tesseractFrameFull = TEItems.itemComponent.addItem(129, "tesseractFrameFull", 1);
        TileTesseract.initialize();
        tesseract = new ItemStack((Block)this, 1, 0);
        return true;
    }

    public boolean postInit() {
        if (enable) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(tesseract, new Object[]{"BIB", "ICI", "BIB", Character.valueOf('C'), tesseractFrameFull, Character.valueOf('I'), "ingotSilver", Character.valueOf('B'), "ingotBronze"}));
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(tesseractFrameEmpty, new Object[]{"IGI", "GXG", "IGI", Character.valueOf('I'), "ingotEnderium", Character.valueOf('G'), "glassHardened", Character.valueOf('X'), Item.field_77702_n}));
        TransposerManager.addTEFillRecipe(16000, tesseractFrameEmpty, tesseractFrameFull, new FluidStack(TEFluids.fluidEnder, 1000), false);
        return true;
    }

    static {
        String category = "block.feature";
        enable = ThermalExpansion.config.get(category, "Tesseract.Enable", true);
    }
}

