/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.dynamo;

import cofh.render.IconRegistry;
import cofh.util.BlockHelper;
import cofh.util.EnergyHelper;
import cofh.util.FluidHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.ShapedOreRecipe;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.BlockTEBase;
import thermalexpansion.block.dynamo.TileDynamoBase;
import thermalexpansion.block.dynamo.TileDynamoCompression;
import thermalexpansion.block.dynamo.TileDynamoMagmatic;
import thermalexpansion.block.dynamo.TileDynamoManual;
import thermalexpansion.block.dynamo.TileDynamoReactant;
import thermalexpansion.block.dynamo.TileDynamoSteam;
import thermalexpansion.core.TEProps;
import thermalexpansion.item.TEItems;
import thermalexpansion.util.Utils;

public class BlockDynamo
extends BlockTEBase {
    public static final String[] NAMES = new String[]{"steam", "magmatic", "compression", "reactant"};
    public static boolean[] enable = new boolean[Types.values().length];
    public static ItemStack dynamoSteam;
    public static ItemStack dynamoMagmatic;
    public static ItemStack dynamoCompression;
    public static ItemStack dynamoReactant;

    public BlockDynamo(int id) {
        super(id, Material.field_76243_f);
        this.func_71848_c(15.0f);
        this.func_71894_b(25.0f);
        this.func_71864_b("thermalexpansion.dynamo");
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata >= Types.values().length) {
            return null;
        }
        switch (Types.values()[metadata]) {
            case STEAM: {
                return new TileDynamoSteam();
            }
            case MAGMATIC: {
                return new TileDynamoMagmatic();
            }
            case COMPRESSION: {
                return new TileDynamoCompression();
            }
            case REACTANT: {
                return new TileDynamoReactant();
            }
        }
        return null;
    }

    public void func_71879_a(int itemId, CreativeTabs tab, List list) {
        for (int i = 0; i < Types.values().length; ++i) {
            if (!enable[i]) continue;
            list.add(new ItemStack(itemId, 1, i));
        }
    }

    @Override
    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int hitSide, float hitX, float hitY, float hitZ) {
        Item equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        TileDynamoBase tile = (TileDynamoBase)world.func_72796_p(x, y, z);
        if (tile instanceof IFluidHandler) {
            if (FluidHelper.fillHandlerWithContainer((World)world, (IFluidHandler)((IFluidHandler)tile), (EntityPlayer)player)) {
                return true;
            }
        } else if (tile instanceof TileDynamoManual) {
            if (Utils.isHoldingNothing(player)) {
                tile.receiveEnergy(ForgeDirection.UNKNOWN, 1000, false);
                player.func_71024_bL().func_75122_a(-1, -0.2f);
            } else if (EnergyHelper.isPlayerHoldingEnergyContainerItem((EntityPlayer)player)) {
                tile.receiveEnergy(ForgeDirection.UNKNOWN, EnergyHelper.extractEnergyFromHeldContainer((EntityPlayer)player, (int)tile.receiveEnergy(ForgeDirection.UNKNOWN, 10000, true), (boolean)false), false);
            }
        }
        return super.func_71903_a(world, x, y, z, player, hitSide, hitX, hitY, hitZ);
    }

    @Override
    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase living, ItemStack stack) {
        TileDynamoBase tile = (TileDynamoBase)world.func_72796_p(x, y, z);
        if (tile != null) {
            tile.rotateBlock();
        }
        super.func_71860_a(world, x, y, z, living, stack);
    }

    public int func_71856_s_() {
        return 0;
    }

    public boolean func_96468_q_() {
        return true;
    }

    public int func_71857_b() {
        return TEProps.renderIdDynamo;
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        TileDynamoBase tile = (TileDynamoBase)world.func_72796_p(x, y, z);
        if (tile == null) {
            return false;
        }
        return tile.facing == BlockHelper.SIDE_OPPOSITE[side.ordinal()];
    }

    public void func_71862_a(World world, int x, int y, int z, Random random) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister ir) {
        IconRegistry.addIcon((String)"DynamoCoilRedstone", (String)"thermalexpansion:dynamo/Dynamo_Coil_Redstone", (IconRegister)ir);
        IconRegistry.addIcon((String)"Dynamo0", (String)"thermalexpansion:dynamo/Dynamo_Steam", (IconRegister)ir);
        IconRegistry.addIcon((String)"Dynamo1", (String)"thermalexpansion:dynamo/Dynamo_Magmatic", (IconRegister)ir);
        IconRegistry.addIcon((String)"Dynamo2", (String)"thermalexpansion:dynamo/Dynamo_Compression", (IconRegister)ir);
        IconRegistry.addIcon((String)"Dynamo3", (String)"thermalexpansion:dynamo/Dynamo_Reactant", (IconRegister)ir);
    }

    public boolean initialize() {
        TileDynamoSteam.initialize();
        TileDynamoMagmatic.initialize();
        TileDynamoCompression.initialize();
        TileDynamoReactant.initialize();
        dynamoSteam = new ItemStack((Block)this, 1, Types.STEAM.ordinal());
        dynamoMagmatic = new ItemStack((Block)this, 1, Types.MAGMATIC.ordinal());
        dynamoCompression = new ItemStack((Block)this, 1, Types.COMPRESSION.ordinal());
        dynamoReactant = new ItemStack((Block)this, 1, Types.REACTANT.ordinal());
        GameRegistry.registerCustomItemStack((String)"dynamoSteam", (ItemStack)dynamoSteam);
        GameRegistry.registerCustomItemStack((String)"dynamoMagmatic", (ItemStack)dynamoMagmatic);
        GameRegistry.registerCustomItemStack((String)"dynamoCompression", (ItemStack)dynamoCompression);
        GameRegistry.registerCustomItemStack((String)"dynamoReactant", (ItemStack)dynamoReactant);
        return true;
    }

    public boolean postInit() {
        if (enable[Types.STEAM.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(dynamoSteam, new Object[]{" C ", "GIG", "IRI", Character.valueOf('C'), TEItems.powerCoilSilver, Character.valueOf('G'), "gearCopper", Character.valueOf('I'), "ingotCopper", Character.valueOf('R'), Item.field_77767_aC}));
        }
        if (enable[Types.MAGMATIC.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(dynamoMagmatic, new Object[]{" C ", "GIG", "IRI", Character.valueOf('C'), TEItems.powerCoilSilver, Character.valueOf('G'), "gearInvar", Character.valueOf('I'), "ingotInvar", Character.valueOf('R'), Item.field_77767_aC}));
        }
        if (enable[Types.COMPRESSION.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(dynamoCompression, new Object[]{" C ", "GIG", "IRI", Character.valueOf('C'), TEItems.powerCoilSilver, Character.valueOf('G'), "gearTin", Character.valueOf('I'), "ingotTin", Character.valueOf('R'), Item.field_77767_aC}));
        }
        if (enable[Types.REACTANT.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(dynamoReactant, new Object[]{" C ", "GIG", "IRI", Character.valueOf('C'), TEItems.powerCoilSilver, Character.valueOf('G'), "gearBronze", Character.valueOf('I'), "ingotBronze", Character.valueOf('R'), Item.field_77767_aC}));
        }
        return true;
    }

    static {
        String category = "block.feature";
        BlockDynamo.enable[Types.STEAM.ordinal()] = ThermalExpansion.config.get(category, "Dynamo.Steam", true);
        BlockDynamo.enable[Types.MAGMATIC.ordinal()] = ThermalExpansion.config.get(category, "Dynamo.Magmatic", true);
        BlockDynamo.enable[Types.COMPRESSION.ordinal()] = ThermalExpansion.config.get(category, "Dynamo.Compression", true);
        BlockDynamo.enable[Types.REACTANT.ordinal()] = ThermalExpansion.config.get(category, "Dynamo.Reactant", true);
    }

    public static enum Types {
        STEAM,
        MAGMATIC,
        COMPRESSION,
        REACTANT;

    }
}

