/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.cache;

import cofh.util.CoreUtils;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.BlockTEBase;
import thermalexpansion.block.cache.TileCache;

public class BlockCache
extends BlockTEBase {
    public static final String[] NAMES = new String[]{"creative", "basic", "hardened", "reinforced", "resonant"};
    public static boolean[] enable = new boolean[Types.values().length];
    public static ItemStack cacheCreative;
    public static ItemStack cacheBasic;
    public static ItemStack cacheHardened;
    public static ItemStack cacheReinforced;
    public static ItemStack cacheResonant;

    public BlockCache(int id) {
        super(id, Material.field_76243_f);
        this.func_71848_c(15.0f);
        this.func_71894_b(25.0f);
        this.func_71864_b("thermalexpansion.cache");
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata >= Types.values().length) {
            return null;
        }
        return new TileCache(metadata);
    }

    public void func_71879_a(int itemId, CreativeTabs tab, List list) {
        for (int i = 0; i < Types.values().length; ++i) {
            if (!enable[i]) continue;
            list.add(new ItemStack(itemId, 1, i));
        }
    }

    public boolean canDismantle(EntityPlayer player, World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) == Types.CREATIVE.ordinal() && !CoreUtils.isOp((EntityPlayer)player)) {
            return false;
        }
        return super.canDismantle(player, world, x, y, z);
    }

    public boolean initialize() {
        TileCache.initialize();
        return true;
    }

    public boolean postInit() {
        if (enable[Types.BASIC.ordinal()]) {
            // empty if block
        }
        if (enable[Types.HARDENED.ordinal()]) {
            // empty if block
        }
        if (enable[Types.REINFORCED.ordinal()]) {
            // empty if block
        }
        if (enable[Types.RESONANT.ordinal()]) {
            // empty if block
        }
        return true;
    }

    static {
        String category = "block.feature";
        BlockCache.enable[Types.CREATIVE.ordinal()] = ThermalExpansion.config.get(category, "Cache.Creative", true);
        BlockCache.enable[Types.BASIC.ordinal()] = ThermalExpansion.config.get(category, "Cache.Basic", true);
        BlockCache.enable[Types.HARDENED.ordinal()] = ThermalExpansion.config.get(category, "Cache.Hardened", true);
        BlockCache.enable[Types.REINFORCED.ordinal()] = ThermalExpansion.config.get(category, "Cache.Reinforced", true);
        BlockCache.enable[Types.RESONANT.ordinal()] = ThermalExpansion.config.get(category, "Cache.Resonant", true);
    }

    public static enum Types {
        CREATIVE,
        BASIC,
        HARDENED,
        REINFORCED,
        RESONANT;

    }
}

