/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.core.gui.GuiDraw;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.DefaultOverlayRenderer;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.api.IStackPositioner;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.forge.IContainerInputHandler;
import codechicken.nei.forge.IContainerTooltipHandler;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import codechicken.nei.recipe.RecipeInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.lwjgl.opengl.GL11;

public abstract class TemplateRecipeHandler
implements ICraftingHandler,
IUsageHandler {
    public int cycleticks = Math.abs((int)System.currentTimeMillis());
    public ArrayList<CachedRecipe> arecipes = new ArrayList();
    public LinkedList<RecipeTransferRect> transferRects = new LinkedList();

    public TemplateRecipeHandler() {
        this.loadTransferRects();
        RecipeTransferRectHandler.registerRectsToGuis(this.getRecipeTransferRectGuis(), this.transferRects);
    }

    public void loadTransferRects() {
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("item")) {
            this.loadCraftingRecipes((ye)results[0]);
        }
    }

    public void loadCraftingRecipes(ye result) {
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("item")) {
            this.loadUsageRecipes((ye)ingredients[0]);
        }
    }

    public void loadUsageRecipes(ye ingredient) {
    }

    public abstract String getGuiTexture();

    public String getOverlayIdentifier() {
        return null;
    }

    public void drawExtras(int recipe) {
    }

    public void drawProgressBar(int x, int y, int tx, int ty, int w, int h, int ticks, int direction) {
        this.drawProgressBar(x, y, tx, ty, w, h, (float)(this.cycleticks % ticks) / (float)ticks, direction);
    }

    public void drawProgressBar(int x, int y, int tx, int ty, int w, int h, float completion, int direction) {
        if (direction > 3) {
            completion = 1.0f - completion;
            direction %= 4;
        }
        int var = (int)(completion * (float)(direction % 2 == 0 ? w : h));
        switch (direction) {
            case 0: {
                GuiDraw.drawTexturedModalRect((int)x, (int)y, (int)tx, (int)ty, (int)var, (int)h);
                break;
            }
            case 1: {
                GuiDraw.drawTexturedModalRect((int)x, (int)y, (int)tx, (int)ty, (int)w, (int)var);
                break;
            }
            case 2: {
                GuiDraw.drawTexturedModalRect((int)(x + w - var), (int)y, (int)(tx + w - var), (int)ty, (int)var, (int)h);
                break;
            }
            case 3: {
                GuiDraw.drawTexturedModalRect((int)x, (int)(y + h - var), (int)tx, (int)(ty + h - var), (int)w, (int)var);
            }
        }
    }

    public List<Class<? extends awy>> getRecipeTransferRectGuis() {
        Class<? extends awy> clazz = this.getGuiClass();
        if (clazz != null) {
            LinkedList<Class<? extends awy>> list = new LinkedList<Class<? extends awy>>();
            list.add(clazz);
            return list;
        }
        return null;
    }

    public Class<? extends awy> getGuiClass() {
        return null;
    }

    public TemplateRecipeHandler newInstance() {
        try {
            return (TemplateRecipeHandler)this.getClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ICraftingHandler getRecipeHandler(String outputId, Object ... results) {
        TemplateRecipeHandler handler = this.newInstance();
        handler.loadCraftingRecipes(outputId, results);
        return handler;
    }

    @Override
    public IUsageHandler getUsageHandler(String inputId, Object ... ingredients) {
        TemplateRecipeHandler handler = this.newInstance();
        handler.loadUsageRecipes(inputId, ingredients);
        return handler;
    }

    @Override
    public int numRecipes() {
        return this.arecipes.size();
    }

    @Override
    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)166, (int)65);
    }

    @Override
    public void drawForeground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        this.drawExtras(recipe);
    }

    @Override
    public List<PositionedStack> getIngredientStacks(int recipe) {
        return this.arecipes.get(recipe).getIngredients();
    }

    @Override
    public PositionedStack getResultStack(int recipe) {
        return this.arecipes.get(recipe).getResult();
    }

    @Override
    public List<PositionedStack> getOtherStacks(int recipe) {
        return this.arecipes.get(recipe).getOtherStacks();
    }

    @Override
    public void onUpdate() {
        if (!NEIClientUtils.shiftKey()) {
            ++this.cycleticks;
        }
    }

    @Override
    public boolean hasOverlay(awy gui, uy container, int recipe) {
        return RecipeInfo.hasDefaultOverlay(gui, this.getOverlayIdentifier()) || RecipeInfo.hasOverlayHandler(gui, this.getOverlayIdentifier());
    }

    @Override
    public IRecipeOverlayRenderer getOverlayRenderer(awy gui, int recipe) {
        IStackPositioner positioner = RecipeInfo.getStackPositioner(gui, this.getOverlayIdentifier());
        if (positioner == null) {
            return null;
        }
        return new DefaultOverlayRenderer(this.getIngredientStacks(recipe), positioner);
    }

    @Override
    public IOverlayHandler getOverlayHandler(awy gui, int recipe) {
        return RecipeInfo.getOverlayHandler(gui, this.getOverlayIdentifier());
    }

    @Override
    public int recipiesPerPage() {
        return 2;
    }

    @Override
    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipe) {
        if (gui.manager.shouldShowTooltip() && currenttip.size() == 0) {
            Point offset = gui.getRecipePosition(recipe);
            currenttip = TemplateRecipeHandler.transferRectTooltip(gui, this.transferRects, offset.x, offset.y, currenttip);
        }
        return currenttip;
    }

    @Override
    public List<String> handleItemTooltip(GuiRecipe gui, ye stack, List<String> currenttip, int recipe) {
        return currenttip;
    }

    @Override
    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        if (keyCode == NEIClientConfig.getKeyBinding("gui.recipe")) {
            return this.transferRect(gui, recipe, false);
        }
        if (keyCode == NEIClientConfig.getKeyBinding("gui.usage")) {
            return this.transferRect(gui, recipe, true);
        }
        return false;
    }

    @Override
    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        if (button == 0) {
            return this.transferRect(gui, recipe, false);
        }
        if (button == 1) {
            return this.transferRect(gui, recipe, true);
        }
        return false;
    }

    private boolean transferRect(GuiRecipe gui, int recipe, boolean usage) {
        Point offset = gui.getRecipePosition(recipe);
        return TemplateRecipeHandler.transferRect(gui, this.transferRects, offset.x, offset.y, usage);
    }

    private static boolean transferRect(awy gui, Collection<RecipeTransferRect> transferRects, int offsetx, int offsety, boolean usage) {
        Point pos = GuiDraw.getMousePosition();
        Point relMouse = new Point(pos.x - gui.p - offsetx, pos.y - gui.q - offsety);
        for (RecipeTransferRect rect : transferRects) {
            if (!rect.rect.contains(relMouse) || !(usage ? GuiUsageRecipe.openRecipeGui(rect.outputId, rect.results) : GuiCraftingRecipe.openRecipeGui(rect.outputId, rect.results))) continue;
            return true;
        }
        return false;
    }

    private static List<String> transferRectTooltip(awy gui, Collection<RecipeTransferRect> transferRects, int offsetx, int offsety, List<String> currenttip) {
        Point pos = GuiDraw.getMousePosition();
        Point relMouse = new Point(pos.x - gui.p - offsetx, pos.y - gui.q - offsety);
        for (RecipeTransferRect rect : transferRects) {
            if (!rect.rect.contains(relMouse)) continue;
            currenttip.add("Recipes");
            break;
        }
        return currenttip;
    }

    static {
        GuiContainerManager.addInputHandler(new RecipeTransferRectHandler());
        GuiContainerManager.addTooltipHandler(new RecipeTransferRectHandler());
    }

    public static class RecipeTransferRectHandler
    implements IContainerInputHandler,
    IContainerTooltipHandler {
        private static HashMap<Class<? extends awy>, HashSet<RecipeTransferRect>> guiMap = new HashMap();

        public static void registerRectsToGuis(List<Class<? extends awy>> classes, List<RecipeTransferRect> rects) {
            if (classes == null) {
                return;
            }
            for (Class<? extends awy> clazz : classes) {
                HashSet<RecipeTransferRect> set = guiMap.get(clazz);
                if (set == null) {
                    set = new HashSet();
                    guiMap.put(clazz, set);
                }
                set.addAll(rects);
            }
        }

        public boolean canHandle(awy gui) {
            return guiMap.containsKey(((Object)((Object)gui)).getClass());
        }

        @Override
        public boolean lastKeyTyped(awy gui, char keyChar, int keyCode) {
            if (!this.canHandle(gui)) {
                return false;
            }
            if (keyCode == NEIClientConfig.getKeyBinding("gui.recipe")) {
                return this.transferRect(gui, false);
            }
            if (keyCode == NEIClientConfig.getKeyBinding("gui.usage")) {
                return this.transferRect(gui, true);
            }
            return false;
        }

        @Override
        public boolean mouseClicked(awy gui, int mousex, int mousey, int button) {
            if (!this.canHandle(gui)) {
                return false;
            }
            if (button == 0) {
                return this.transferRect(gui, false);
            }
            if (button == 1) {
                return this.transferRect(gui, true);
            }
            return false;
        }

        private boolean transferRect(awy gui, boolean usage) {
            int[] offset = RecipeInfo.getGuiOffset(gui);
            return TemplateRecipeHandler.transferRect(gui, RecipeTransferRectHandler.guiMap.get(((Object)((Object)gui)).getClass()), offset[0], offset[1], usage);
        }

        @Override
        public void onKeyTyped(awy gui, char keyChar, int keyID) {
        }

        @Override
        public void onMouseClicked(awy gui, int mousex, int mousey, int button) {
        }

        @Override
        public void onMouseUp(awy gui, int mousex, int mousey, int button) {
        }

        @Override
        public boolean keyTyped(awy gui, char keyChar, int keyID) {
            return false;
        }

        @Override
        public boolean mouseScrolled(awy gui, int mousex, int mousey, int scrolled) {
            return false;
        }

        @Override
        public void onMouseScrolled(awy gui, int mousex, int mousey, int scrolled) {
        }

        @Override
        public List<String> handleTooltipFirst(awy gui, int mousex, int mousey, List<String> currenttip) {
            if (!this.canHandle(gui)) {
                return currenttip;
            }
            if (gui.manager.shouldShowTooltip() && currenttip.size() == 0) {
                int[] offset = RecipeInfo.getGuiOffset(gui);
                currenttip = TemplateRecipeHandler.transferRectTooltip(gui, RecipeTransferRectHandler.guiMap.get(((Object)((Object)gui)).getClass()), offset[0], offset[1], currenttip);
            }
            return currenttip;
        }

        @Override
        public List<String> handleItemTooltip(awy gui, ye itemstack, List<String> currenttip) {
            return currenttip;
        }

        @Override
        public void onMouseDragged(awy gui, int mousex, int mousey, int button, long heldTime) {
        }
    }

    public static class RecipeTransferRect {
        Rectangle rect;
        String outputId;
        Object[] results;

        public RecipeTransferRect(Rectangle rectangle, String outputId, Object ... results) {
            this.rect = rectangle;
            this.outputId = outputId;
            this.results = results;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RecipeTransferRect)) {
                return false;
            }
            return this.rect.equals(((RecipeTransferRect)obj).rect);
        }

        public int hashCode() {
            return this.rect.hashCode();
        }
    }

    public abstract class CachedRecipe {
        final long offset = System.currentTimeMillis();

        public abstract PositionedStack getResult();

        public List<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            PositionedStack stack = this.getIngredient();
            if (stack != null) {
                stacks.add(stack);
            }
            return stacks;
        }

        public PositionedStack getIngredient() {
            return null;
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            PositionedStack stack = this.getOtherStack();
            if (stack != null) {
                stacks.add(stack);
            }
            return stacks;
        }

        public PositionedStack getOtherStack() {
            return null;
        }

        public List<PositionedStack> getCycledIngredients(int cycle, List<PositionedStack> ingredients) {
            for (int itemIndex = 0; itemIndex < ingredients.size(); ++itemIndex) {
                this.randomRenderPermutation(ingredients.get(itemIndex), cycle + itemIndex);
            }
            return ingredients;
        }

        public void randomRenderPermutation(PositionedStack stack, long cycle) {
            Random rand = new Random(cycle + this.offset);
            stack.setPermutationToRender(Math.abs(rand.nextInt()) % stack.items.length);
        }

        public void setIngredientPermutation(Collection<PositionedStack> ingredients, ye ingredient) {
            block0: for (PositionedStack stack : ingredients) {
                for (int i = 0; i < stack.items.length; ++i) {
                    if (!NEIServerUtils.areStacksSameTypeCrafting(ingredient, stack.items[i])) continue;
                    stack.item = stack.items[i];
                    stack.item.b(ingredient.k());
                    stack.items = new ye[]{stack.item};
                    stack.setPermutationToRender(0);
                    continue block0;
                }
            }
        }

        public boolean contains(Collection<PositionedStack> ingredients, ye ingredient) {
            for (PositionedStack stack : ingredients) {
                if (!stack.contains(ingredient)) continue;
                return true;
            }
            return false;
        }

        public boolean contains(Collection<PositionedStack> ingredients, int ingredID) {
            for (PositionedStack stack : ingredients) {
                if (!stack.contains(ingredID)) continue;
                return true;
            }
            return false;
        }
    }
}

