/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.gui.GuiDraw;
import codechicken.lib.config.ConfigTag;
import codechicken.lib.config.ConfigTagParent;
import codechicken.lib.inventory.ItemKey;
import codechicken.nei.DropDownFile;
import codechicken.nei.DropDownWidget;
import codechicken.nei.ItemList;
import codechicken.nei.ItemRange;
import codechicken.nei.ItemVisibilityHash;
import codechicken.nei.LayoutManager;
import codechicken.nei.MultiItemRange;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.forge.GuiContainerManager;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class SubSetRangeTag
extends ConfigTag {
    public ArrayList<SubSetRangeTag> sortedtags = new ArrayList();
    public boolean saveTag = true;
    public MultiItemRange validranges;
    public byte state;
    public int slotwidth = 0;
    public boolean hasscroll;
    protected int scrollclicky = -1;
    protected float scrollpercent;
    protected int scrollmousey;
    protected float percentscrolled;
    protected int lastslotclicked = -1;
    protected long lastslotclicktime;
    int x;
    int y;
    int height;
    int width;
    int contentheight;
    public boolean expanded;
    public boolean hidden;
    private static final int slotheight = 18;

    public SubSetRangeTag(DropDownFile parent, String name) {
        super((ConfigTagParent)parent, name);
    }

    public SubSetRangeTag(SubSetRangeTag parent, String name) {
        super((ConfigTagParent)parent, name);
        this.saveTag = parent.saveTag;
    }

    public ConfigTag onLoaded() {
        this.saveTag = true;
        return this;
    }

    public SubSetRangeTag getTag(String tagname) {
        return (SubSetRangeTag)super.getTag(tagname);
    }

    public SubSetRangeTag getTag(String tagname, boolean createnew) {
        return (SubSetRangeTag)super.getTag(tagname, createnew);
    }

    public SubSetRangeTag getNewTag(String name) {
        return new SubSetRangeTag(this, name);
    }

    public void setDefaultValue(MultiItemRange range) {
        if (this.value == null) {
            this.setRange(range);
        }
    }

    public void setValue(String value) {
        this.value = value;
        if (this.saveTag) {
            this.saveConfig();
        }
        if (this.validranges == null) {
            this.validranges = new MultiItemRange(value);
        }
    }

    public void setRange(MultiItemRange range) {
        this.validranges = range;
        this.setValue(this.validranges.toString());
    }

    public MultiItemRange getRange() {
        return this.validranges;
    }

    public boolean thisContains(int mousex, int mousey) {
        return mousex >= this.x && mousex < this.x + this.width && mousey >= this.y && mousey < this.y + this.height;
    }

    public boolean contains(int mousex, int mousey) {
        if (!this.expanded) {
            return false;
        }
        if (this.thisContains(mousex, mousey)) {
            return true;
        }
        for (SubSetRangeTag tag : this.sortedtags) {
            if (!tag.contains(mousex, mousey)) continue;
            return true;
        }
        return false;
    }

    public int getNumSlots() {
        return this.childTagMap().size() + (this.validranges == null ? 0 : this.validranges.getNumSlots());
    }

    public int getScrollBarWidth() {
        return 5;
    }

    public int getScrollBarHeight() {
        int sbarh = (int)((float)this.height / (float)this.contentheight * (float)this.height);
        if (sbarh > this.height) {
            return this.height;
        }
        if (sbarh < this.height / 15) {
            return this.height / 15;
        }
        return sbarh;
    }

    public int getScrolledSlots() {
        int slots = this.getNumSlots();
        int shownslots = this.height / 18;
        return (int)(this.percentscrolled * (float)(slots - shownslots) + 0.5f);
    }

    private int getClickedSlot(int mousey) {
        return (mousey - this.y) / 18 + this.getScrolledSlots();
    }

    public void calculatePercentScrolled() {
        int barempty = this.height - this.getScrollBarHeight();
        if (this.scrollclicky >= 0) {
            int scrolldiff = this.scrollmousey - this.scrollclicky;
            this.percentscrolled = (float)scrolldiff / (float)barempty + this.scrollpercent;
        }
        if (this.percentscrolled < 0.0f) {
            this.percentscrolled = 0.0f;
        }
        if (this.percentscrolled > 1.0f) {
            this.percentscrolled = 1.0f;
        }
        int sbary = this.y + (int)((double)((float)barempty * this.percentscrolled) + 0.5);
        this.percentscrolled = (float)(sbary - this.y) / (float)barempty;
    }

    public void processScrollMouse(int mousex, int mousey) {
        if (this.scrollclicky >= 0) {
            int scrolldiff = mousey - this.scrollclicky;
            int barupallowed = (int)((double)((float)(this.height - this.getScrollBarHeight()) * this.scrollpercent) + 0.5);
            int bardownallowed = this.height - this.getScrollBarHeight() - barupallowed;
            this.scrollmousey = -scrolldiff > barupallowed ? this.scrollclicky - barupallowed : (scrolldiff > bardownallowed ? this.scrollclicky + bardownallowed : mousey);
            this.calculatePercentScrolled();
        }
    }

    public String updateMouseOver(int mousex, int mousey, String mouseovername) {
        boolean bl = this.expanded = mouseovername.equals(this.qualifiedname) || mouseovername.length() > this.qualifiedname.length() && mouseovername.startsWith(this.qualifiedname) && mouseovername.charAt(this.qualifiedname.length()) == '.';
        if (!this.expanded) {
            this.scrollclicky = -1;
            return "";
        }
        this.processScrollMouse(mousex, mousey);
        String currentmouseover = "";
        if (this.contains(mousex, mousey)) {
            currentmouseover = this.qualifiedname + "." + "-";
        }
        int sloty = this.y;
        int slotx = this.x + (this.hasscroll ? this.getScrollBarWidth() : 0);
        int slot = 0;
        for (SubSetRangeTag tag : this.sortedtags) {
            String s;
            if (++slot <= this.getScrolledSlots()) continue;
            if (slotx <= mousex && this.x + this.width > mousex && sloty <= mousey && sloty + 18 > mousey) {
                currentmouseover = tag.qualifiedname;
            }
            if (!(s = tag.updateMouseOver(mousex, mousey, mouseovername)).equals("")) {
                currentmouseover = s;
            }
            sloty += 18;
        }
        int tagslots = slot;
        if (this.validranges != null) {
            for (ItemRange range : this.validranges.ranges) {
                if (slot + range.encompasseditems.size() <= this.getScrolledSlots()) {
                    slot += range.encompasseditems.size();
                    continue;
                }
                for (int item = 0; item < range.encompasseditems.size(); ++item) {
                    if (++slot <= this.getScrolledSlots()) continue;
                    if (slotx <= mousex && this.x + this.width > mousex && sloty <= mousey && sloty + 18 > mousey) {
                        currentmouseover = this.qualifiedname + "." + (slot - tagslots);
                        break;
                    }
                    if ((sloty += 18) >= this.y + this.height) break;
                }
                if (sloty < this.y + this.height) continue;
                break;
            }
        }
        return currentmouseover;
    }

    public boolean click(int mousex, int mousey, int button) {
        if (!this.expanded) {
            return false;
        }
        boolean inbounds = this.thisContains(mousex, mousey);
        if (!inbounds) {
            for (SubSetRangeTag tag : this.sortedtags) {
                tag.click(mousex, mousey, button);
            }
        }
        int barempty = this.height - this.getScrollBarHeight();
        int sbary = this.y + (int)((double)((float)barempty * this.percentscrolled) + 0.5);
        int contentx = this.x + this.getScrollBarWidth();
        if (this.hasscroll && button == 0 && this.getScrollBarHeight() < this.height && mousex >= this.x && mousex < this.x + this.getScrollBarWidth() && mousey >= this.y && mousey < this.y + this.height) {
            if (mousey < sbary) {
                this.percentscrolled = (float)(mousey - this.y) / (float)barempty;
                this.calculatePercentScrolled();
            } else if (mousey > sbary + this.getScrollBarHeight()) {
                this.percentscrolled = (float)(mousey - this.y - this.getScrollBarHeight() + 1) / (float)barempty;
                this.calculatePercentScrolled();
            } else {
                this.scrollclicky = mousey;
                this.scrollpercent = this.percentscrolled;
                this.scrollmousey = mousey;
                LayoutManager.dropDown.canChangeMouseOver = false;
            }
        } else if (mousex >= contentx && mousex < this.x + this.width && mousey >= this.y && mousey <= this.y + this.height) {
            int slot = this.getClickedSlot(mousey);
            if (slot == this.lastslotclicked && System.currentTimeMillis() - this.lastslotclicktime < 500L && button == 0) {
                this.slotClicked(slot, button, true);
            } else {
                this.slotClicked(slot, button, false);
            }
            if (button == 0) {
                this.lastslotclicked = slot;
                this.lastslotclicktime = System.currentTimeMillis();
            }
        }
        return true;
    }

    public void onMouseWheel(int i) {
        if (this.scrollclicky != -1) {
            return;
        }
        for (SubSetRangeTag tag : this.sortedtags) {
            if (!tag.expanded) continue;
            tag.onMouseWheel(i);
            return;
        }
        this.percentscrolled += (float)i / (float)this.contentheight * 100.0f;
        if (this.percentscrolled > 1.0f) {
            this.percentscrolled = 1.0f;
        } else if (this.percentscrolled < 0.0f) {
            this.percentscrolled = 0.0f;
        }
    }

    private void slotClicked(int slot, int button, boolean doubleclick) {
        int i = 0;
        for (SubSetRangeTag tag : this.sortedtags) {
            if (slot == i) {
                tag.onClick(button, doubleclick);
                return;
            }
            ++i;
        }
        if (this.validranges != null) {
            this.validranges.slotClicked(slot - i, button, doubleclick);
        }
    }

    public void onClick(int button, boolean doubleclick) {
        if (button == 0 && !doubleclick) {
            if (NEIClientUtils.shiftKey()) {
                LayoutManager.searchField.setText("@" + this.qualifiedname);
                return;
            }
            this.showAllItems();
        } else if (button == 0 && doubleclick) {
            DropDownFile.dropDownInstance.hideAllItems();
            this.showAllItems();
        } else if (button == 1) {
            this.hideAllItems();
        }
        DropDownFile.dropDownInstance.updateState();
        ItemList.updateSearch();
        NEIClientConfig.vishash.save();
    }

    public void hideAllItems() {
        if (this.validranges != null) {
            this.validranges.hideAllItems();
        }
        for (SubSetRangeTag tag : this.sortedtags) {
            tag.hideAllItems();
        }
    }

    public void showAllItems() {
        if (this.validranges != null) {
            this.validranges.showAllItems();
        }
        for (SubSetRangeTag tag : this.sortedtags) {
            tag.showAllItems();
        }
    }

    public void mouseUp(int mousex, int mousey, int button) {
        if (this.scrollclicky >= 0 && button == 0) {
            this.scrollclicky = -1;
            LayoutManager.dropDown.canChangeMouseOver = true;
        }
        for (SubSetRangeTag tag : this.sortedtags) {
            tag.mouseUp(mousex, mousey, button);
        }
    }

    public void draw(int mousex, int mousey) {
        if (!this.expanded) {
            return;
        }
        this.drawScrollBar();
        int drawy = this.y;
        int drawx = this.x + (this.hasscroll ? this.getScrollBarWidth() : 0);
        int slot = 0;
        for (SubSetRangeTag tag : this.sortedtags) {
            if (++slot <= this.getScrolledSlots()) continue;
            if (!this.hidden) {
                if (!DropDownWidget.texturedButtons) {
                    boolean contains = mousex >= drawx && mousex < drawx + this.slotwidth && mousey >= drawy && mousey < drawy + 18;
                    GuiDraw.drawRect((int)drawx, (int)drawy, (int)this.slotwidth, (int)18, (int)(contains ? -12578808 : -16777216));
                    GuiDraw.drawStringC((String)tag.name, (int)drawx, (int)drawy, (int)this.slotwidth, (int)18, (int)tag.getColourFromState(), (tag.state == 0 ? 1 : 0) != 0);
                } else {
                    GuiDraw.changeTexture((String)"textures/gui/widgets.png");
                    if (tag.state == 1) {
                        GL11.glColor4f((float)0.65f, (float)0.65f, (float)0.65f, (float)1.0f);
                    } else {
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    }
                    int tex = tag.state == 0 ? 0 : 1;
                    LayoutManager.drawButtonBackground(drawx, drawy, this.slotwidth, 18, false, tex);
                    int textcolour = tag.state == 2 ? -2039584 : -6250336;
                    GuiDraw.drawStringC((String)tag.name, (int)drawx, (int)drawy, (int)this.slotwidth, (int)18, (int)textcolour);
                }
            }
            tag.draw(mousex, mousey);
            if ((drawy += 18) < this.y + this.height) continue;
            break;
        }
        if (this.validranges != null && drawy < this.y + this.height) {
            for (ItemRange range : this.validranges.ranges) {
                if (slot + range.encompasseditems.size() <= this.getScrolledSlots()) {
                    slot += range.encompasseditems.size();
                    continue;
                }
                for (int item = 0; item < range.encompasseditems.size(); ++item) {
                    boolean itemvisible;
                    if (++slot <= this.getScrolledSlots()) continue;
                    ItemKey itemh = range.encompasseditems.get(item);
                    int itemx = drawx + this.slotwidth / 2 - 8;
                    int itemy = drawy + 1;
                    boolean bl = itemvisible = !NEIClientConfig.vishash.isItemHidden(itemh);
                    if (!DropDownWidget.texturedButtons) {
                        GuiDraw.drawRect((int)drawx, (int)drawy, (int)this.slotwidth, (int)18, (int)(itemvisible ? -16764928 : -13631488));
                    } else {
                        int tex = itemvisible ? 1 : 0;
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        LayoutManager.drawButtonBackground(drawx, drawy, this.slotwidth, 18, false, tex);
                    }
                    ye stack = itemh.item;
                    GuiContainerManager.drawItem(itemx, itemy, stack);
                    if (itemx <= mousex && itemx + 16 > mousex && itemy + 1 <= mousey && itemy + 16 > mousey) {
                        LayoutManager.dropDown.setHoverItem(itemh.item);
                    }
                    if ((drawy += 18) >= this.y + this.height) break;
                }
                if (drawy < this.y + this.height) continue;
                break;
            }
        }
    }

    private void drawScrollBar() {
        if (this.hasscroll && !this.hidden) {
            int sbary = this.y + (int)((double)((float)(this.height - this.getScrollBarHeight()) * this.percentscrolled) + 0.5);
            GuiDraw.drawRect((int)this.x, (int)this.y, (int)5, (int)this.height, (int)-14671840);
            if (DropDownWidget.texturedButtons) {
                GuiDraw.drawRect((int)this.x, (int)sbary, (int)5, (int)this.getScrollBarHeight(), (int)-7631989);
                GuiDraw.drawRect((int)this.x, (int)sbary, (int)4, (int)(this.getScrollBarHeight() - 1), (int)-986896);
                GuiDraw.drawRect((int)(this.x + 1), (int)(sbary + 1), (int)4, (int)(this.getScrollBarHeight() - 1), (int)-11184811);
                GuiDraw.drawRect((int)(this.x + 1), (int)(sbary + 1), (int)3, (int)(this.getScrollBarHeight() - 2), (int)-3750202);
            } else {
                GuiDraw.drawRect((int)this.x, (int)sbary, (int)5, (int)this.getScrollBarHeight(), (int)-2039584);
            }
        }
    }

    public void position(int px, int py) {
        this.x = px;
        this.y = py;
        this.recalcSize();
        if (!this.expanded) {
            return;
        }
        int suby = this.y;
        int subx = this.x + this.width;
        int slot = 0;
        for (SubSetRangeTag tag : this.sortedtags) {
            if (++slot <= this.getScrolledSlots()) continue;
            tag.position(subx, suby);
            if ((suby += 18) < this.y + this.height) continue;
            break;
        }
    }

    public void recalcSize() {
        int rangewidth;
        int maxheight = LayoutManager.dropDown.y + LayoutManager.dropDown.maxheight + LayoutManager.dropDown.height - this.y;
        int extraheight = this.y - LayoutManager.dropDown.height;
        this.contentheight = this.getNumSlots() * 18;
        if (this.contentheight > maxheight) {
            if (this.contentheight <= maxheight + extraheight) {
                this.y -= this.contentheight - maxheight;
                maxheight = this.contentheight;
            } else {
                this.y -= extraheight;
                maxheight += extraheight;
            }
        }
        if (this.contentheight > maxheight) {
            this.height = maxheight / 18 * 18;
            this.hasscroll = true;
        } else {
            this.hasscroll = false;
            this.height = this.contentheight;
        }
        this.slotwidth = 0;
        avi fontRenderer = NEIClientUtils.mc().l;
        for (SubSetRangeTag tag : this.sortedtags) {
            int tagwidth = fontRenderer.a(tag.name);
            if (tagwidth <= this.slotwidth) continue;
            this.slotwidth = tagwidth;
        }
        if (this.validranges != null && (rangewidth = this.validranges.getWidth()) > this.slotwidth) {
            this.slotwidth = rangewidth;
        }
        this.slotwidth += 2;
        this.width = this.slotwidth;
        if (this.hasscroll) {
            this.width += this.getScrollBarWidth();
        }
        int totalwidth = this.x + this.width - LayoutManager.dropDown.x;
        if (this.expanded && totalwidth > LayoutManager.dropDown.droppedwidth) {
            LayoutManager.dropDown.droppedwidth = totalwidth;
        }
        this.hidden = totalwidth <= 0;
    }

    public int getWidthAtLevel(int hiddenlevel) {
        if (!this.expanded) {
            return 0;
        }
        if (hiddenlevel == 0) {
            return this.width;
        }
        for (SubSetRangeTag tag : this.sortedtags) {
            int subwidth = tag.getWidthAtLevel(hiddenlevel - 1);
            if (subwidth == 0) continue;
            return subwidth;
        }
        return 0;
    }

    public void resetHashes() {
        if (this.validranges != null) {
            this.validranges.resetHashes();
        }
        this.sortedtags = this.getSortedTagList();
        for (SubSetRangeTag tag : this.sortedtags) {
            tag.resetHashes();
        }
    }

    public void updateState(ItemVisibilityHash vis) {
        boolean allshown = false;
        boolean allhidden = false;
        for (SubSetRangeTag tag : this.sortedtags) {
            tag.updateState(vis);
        }
        for (SubSetRangeTag tag : this.sortedtags) {
            if (tag.state == 1) {
                this.state = 1;
                return;
            }
            if (tag.state == 0) {
                if (allshown) {
                    this.state = 1;
                    return;
                }
                allhidden = true;
                continue;
            }
            if (allhidden) {
                this.state = 1;
                return;
            }
            allshown = true;
        }
        if (this.validranges != null) {
            this.validranges.updateState(vis);
            byte rstate = this.validranges.state;
            if (rstate == 1) {
                this.state = 1;
                return;
            }
            if (rstate == 0) {
                if (allshown) {
                    this.state = 1;
                    return;
                }
                allhidden = true;
            } else {
                if (allhidden) {
                    this.state = 1;
                    return;
                }
                allshown = true;
            }
        }
        this.state = allshown ? (byte)2 : (byte)0;
    }

    public void addItemIfInRange(int item, int damage, by compound) {
        if (this.validranges != null) {
            this.validranges.addItemIfInRange(item, damage, compound);
        }
        for (SubSetRangeTag tag : this.sortedtags) {
            tag.addItemIfInRange(item, damage, compound);
        }
    }

    public boolean isItemInRange(int item, int damage) {
        if (this.validranges != null && this.validranges.isItemInRange(item, damage)) {
            return true;
        }
        for (SubSetRangeTag tag : this.sortedtags) {
            if (!tag.isItemInRange(item, damage)) continue;
            return true;
        }
        return false;
    }

    public int getColourFromState() {
        if (this.state == 0) {
            return -10481648;
        }
        if (this.state == 1) {
            return -8359824;
        }
        return -1;
    }

    public void setSave(boolean save) {
        this.saveTag = save;
        this.saveConfig();
    }

    public void save(PrintWriter writer, int tabs, String bracequalifier, boolean first) {
        if (this.saveTag) {
            super.save(writer, tabs, bracequalifier, first);
        } else {
            this.saveTagTree(writer, tabs, bracequalifier);
        }
    }

    public SubSetRangeTag useBraces() {
        return (SubSetRangeTag)super.useBraces();
    }

    public SubSetRangeTag setComment(String string) {
        return (SubSetRangeTag)super.setComment(string);
    }

    public SubSetRangeTag setPosition(int pos) {
        this.position = pos;
        if (this.saveTag) {
            this.saveConfig();
        }
        return this;
    }

    public String toString() {
        return this.qualifiedname;
    }

    public void addChildTags(List<SubSetRangeTag> tags) {
        tags.add(this);
        for (SubSetRangeTag tag : this.sortedtags) {
            tag.addChildTags(tags);
        }
    }
}

