/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CommonUtils;
import codechicken.core.ServerUtils;
import codechicken.lib.config.ConfigFile;
import codechicken.lib.config.ConfigTag;
import codechicken.lib.inventory.ItemKey;
import codechicken.lib.packet.PacketCustom;
import codechicken.nei.NEIActions;
import codechicken.nei.NEISPH;
import codechicken.nei.PlayerSave;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.DimensionManager;

public class NEIServerConfig {
    private static MinecraftServer server;
    public static ConfigFile serverConfig;
    public static File worldSaveFile;
    public static File worldSaveDir;
    public static by worldCompound;
    public static HashMap<String, PlayerSave> playerSaves;
    public static HashMap<ItemKey, HashSet<String>> bannedblocks;

    public static void load(abw world) {
        if (MinecraftServer.F() == server) {
            return;
        }
        System.out.println("Loading NEI");
        server = MinecraftServer.F();
        NEIServerConfig.initDefaults();
        NEIServerConfig.loadBannedBlocks();
        NEIServerConfig.loadSavedConfig(world);
    }

    private static void loadSavedConfig(abw world) {
        try {
            worldSaveDir = DimensionManager.getCurrentSaveRootDirectory();
            worldSaveFile = new File(worldSaveDir, "NEI.dat");
            if (!worldSaveFile.getParentFile().exists()) {
                worldSaveFile.getParentFile().mkdirs();
            }
            if (!worldSaveFile.exists()) {
                worldSaveFile.createNewFile();
            }
            if (worldSaveFile.length() == 0L) {
                worldCompound = new by();
            } else {
                DataInputStream din = new DataInputStream(new FileInputStream(worldSaveFile));
                worldCompound = (by)cl.a((DataInput)din);
                din.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void initDefaults() {
        serverConfig.setNewLineMode(1);
        serverConfig.getTag("permissions").useBraces();
        serverConfig.getTag("permissions").setComment("List of players who can use these features. :Eg. time=CodeChicken, Friend1");
        serverConfig.getTag("BannedBlocks").useBraces();
        serverConfig.getTag("BannedBlocks").setComment("List of players who can use these blocks. :Anyone not listed here will not have these blocks appear in their item panel.:format is {itemID}::{itemDamage}:Eg. 12::5=CodeChicken, Friend1");
        NEIServerConfig.setDefaultFeature("time", new String[0]);
        NEIServerConfig.setDefaultFeature("rain", new String[0]);
        NEIServerConfig.setDefaultFeature("heal", new String[0]);
        NEIServerConfig.setDefaultFeature("magnet", new String[0]);
        NEIServerConfig.setDefaultFeature("creative", new String[0]);
        NEIServerConfig.setDefaultFeature("creative+", new String[0]);
        NEIServerConfig.setDefaultFeature("adventure", new String[0]);
        NEIServerConfig.setDefaultFeature("enchant", new String[0]);
        NEIServerConfig.setDefaultFeature("potion", new String[0]);
        NEIServerConfig.setDefaultFeature("save-state", new String[0]);
        NEIServerConfig.setDefaultFeature("item", new String[0]);
        NEIServerConfig.setDefaultFeature("delete", new String[0]);
        NEIServerConfig.setDefaultFeature("notify-item", "CONSOLE, OP");
        serverConfig.getTag("BannedBlocks." + aqz.E.cF + ":0").setDefaultValue("NONE");
    }

    private static void setDefaultFeature(String featurename, String ... names) {
        if (names.length == 0) {
            names = new String[]{"OP"};
        }
        String list = "";
        for (int i = 0; i < names.length; ++i) {
            if (i >= 1) {
                list = list + ", ";
            }
            list = list + names[i];
        }
        serverConfig.getTag("permissions." + featurename).setDefaultValue(list);
    }

    private static void saveWorldCompound() {
        try {
            DataOutputStream dout = new DataOutputStream(new FileOutputStream(worldSaveFile));
            cl.a((cl)worldCompound, (DataOutput)dout);
            dout.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static by getDimCompound(int dim) {
        if (!worldCompound.b("dim" + dim)) {
            worldCompound.a("dim" + dim, new by());
        }
        return worldCompound.l("dim" + dim);
    }

    public static boolean canPlayerPerformAction(String playername, String name) {
        return NEIServerConfig.isPlayerInList(playername, NEIServerConfig.getPlayerList("permissions." + NEIActions.base(name)), true);
    }

    public static boolean isPlayerInList(String playername, HashSet<String> list, boolean allowCards) {
        if (playername.equals("CONSOLE")) {
            return list.contains(playername);
        }
        playername = playername.toLowerCase();
        if (allowCards) {
            if (list.contains("ALL")) {
                return true;
            }
            if ((ServerUtils.isPlayerOP((String)playername) || ServerUtils.isPlayerOwner((String)playername)) && list.contains("OP")) {
                return true;
            }
        }
        return list.contains(playername);
    }

    public static boolean isActionDisabled(int dim, String name) {
        return NEIServerConfig.getDimCompound(dim).n("disabled" + name);
    }

    public static void disableAction(int dim, String name, boolean disable) {
        NEIServerConfig.getDimCompound(dim).a("disabled" + name, disable);
        NEISPH.sendActionDisabled(dim, name, disable);
        NEIServerConfig.saveWorldCompound();
    }

    public static HashSet<String> getPlayerList(String tag) {
        String[] list = serverConfig.getTag(tag).getValue("").replace(" ", "").split(",");
        return new HashSet<String>(Arrays.asList(list));
    }

    public static void addPlayerToList(String playername, String tag) {
        HashSet<String> list = NEIServerConfig.getPlayerList(tag);
        if (!(playername.equals("CONSOLE") || playername.equals("ALL") || playername.equals("OP"))) {
            playername = playername.toLowerCase();
        }
        list.add(playername);
        NEIServerConfig.savePlayerList(tag, list);
    }

    public static void remPlayerFromList(String playername, String tag) {
        HashSet<String> list = NEIServerConfig.getPlayerList(tag);
        if (!(playername.equals("CONSOLE") || playername.equals("ALL") || playername.equals("OP"))) {
            playername = playername.toLowerCase();
        }
        list.remove(playername);
        NEIServerConfig.savePlayerList(tag, list);
    }

    private static void savePlayerList(String tag, Collection<String> list) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(iterator.next());
            ++i;
        }
        serverConfig.getTag(tag).setValue(sb.toString());
    }

    private static void loadBannedBlocks() {
        ConfigTag banTag = serverConfig.getTag("BannedBlocks");
        for (Map.Entry entry : banTag.childTagMap().entrySet()) {
            String ident = (String)entry.getKey();
            String[] num = ident.split(":");
            ItemKey hash = num.length == 1 ? new ItemKey(Integer.parseInt(num[0]), -1) : new ItemKey(Integer.parseInt(num[0]), Integer.parseInt(num[1]));
            bannedblocks.put(hash, NEIServerConfig.getPlayerList(((ConfigTag)entry.getValue()).qualifiedname));
        }
    }

    public static PlayerSave forPlayer(String username) {
        return playerSaves.get(username);
    }

    public static void loadPlayer(uf player) {
        System.out.println("Loading Player: " + player.bu);
        playerSaves.put(player.bu, new PlayerSave(player.bu, new File(worldSaveDir, "NEI/players")));
    }

    public static void unloadPlayer(uf player) {
        System.out.println("Unloading Player: " + player.bu);
        PlayerSave playerSave = playerSaves.remove(player.bu);
        if (playerSave != null) {
            playerSave.save();
        }
    }

    public static boolean authenticatePacket(jv sender, PacketCustom packet) {
        switch (packet.getType()) {
            case 1: {
                return NEIServerConfig.canPlayerPerformAction(sender.bu, "item");
            }
            case 4: {
                return NEIServerConfig.canPlayerPerformAction(sender.bu, "delete");
            }
            case 6: {
                return NEIServerConfig.canPlayerPerformAction(sender.bu, "magnet");
            }
            case 7: {
                return NEIServerConfig.canPlayerPerformAction(sender.bu, "time");
            }
            case 8: {
                return NEIServerConfig.canPlayerPerformAction(sender.bu, "heal");
            }
            case 9: {
                return NEIServerConfig.canPlayerPerformAction(sender.bu, "rain");
            }
            case 14: 
            case 23: {
                return NEIServerConfig.canPlayerPerformAction(sender.bu, "creative+");
            }
            case 21: 
            case 22: {
                return NEIServerConfig.canPlayerPerformAction(sender.bu, "enchant");
            }
            case 24: {
                return NEIServerConfig.canPlayerPerformAction(sender.bu, "potion");
            }
        }
        return true;
    }

    static {
        serverConfig = new ConfigFile(new File(CommonUtils.getMinecraftDir(), "config/NEIServer.cfg")).setComment("NEI Server Permissions \n Names are Comma (,) separated \n ALL, OP and NONE are special names");
        playerSaves = new HashMap();
        bannedblocks = new HashMap();
    }
}

