/*
 * Decompiled with CFR 0.152.
 */
package myrathi.infinibows;

import cpw.mods.fml.common.CertificateHelper;
import cpw.mods.fml.common.MetadataCollection;
import cpw.mods.fml.relauncher.IFMLCallHook;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.io.File;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import myrathi.infinibows.InfiniBowsModContainer;
import myrathi.infinibows.asm.BowTransformer;
import myrathi.infinibows.util.IBLog;
import myrathi.infinibows.util.Version;

@IFMLLoadingPlugin.MCVersion(value="1.6.4")
@IFMLLoadingPlugin.TransformerExclusions(value={"myrathi.infinibows", "myrathi.infinibows.asm"})
public class LoadingPlugin
implements IFMLLoadingPlugin,
IFMLCallHook {
    private static final String _certificateFingerprint = "b9:a3:64:d6:01:f6:d6:a4:c4:22:09:78:0c:a2:ed:c8:85:ce:72:17".replace(":", "");
    private static Certificate _certificate = null;
    private static boolean _certSearched = false;
    private static MetadataCollection _metadataCollection = null;
    private static String _version = null;
    public static boolean _runtimeDeobfuscationEnabled;

    @Deprecated
    public String[] getLibraryRequestClass() {
        return null;
    }

    public String[] getASMTransformerClass() {
        return new String[]{BowTransformer.class.getName()};
    }

    public String getModContainerClass() {
        return InfiniBowsModContainer.class.getName();
    }

    public String getSetupClass() {
        return this.getClass().getName();
    }

    public void injectData(Map<String, Object> data) {
        if (data.containsKey("runtimeDeobfuscationEnabled")) {
            _runtimeDeobfuscationEnabled = (Boolean)data.get("runtimeDeobfuscationEnabled");
            this.readModInfo(data.get("coremodLocation").toString());
        }
    }

    public Void call() throws Exception {
        if (!_runtimeDeobfuscationEnabled) {
            IBLog.info("Skipping signing certificate validation.", new Object[0]);
            return null;
        }
        if (!this.validSignature()) {
            IBLog.severe("Signing certificate not found! Please ensure you have an original and unmodified version of this JAR!", new Object[0]);
        }
        return null;
    }

    protected static Certificate getSigningCertificate() {
        if (_certSearched) {
            return _certificate;
        }
        _certSearched = true;
        Certificate[] certs = LoadingPlugin.class.getProtectionDomain().getCodeSource().getCertificates();
        if (certs != null && certs.length > 0) {
            for (int i = 0; i < certs.length; ++i) {
                if (!CertificateHelper.getFingerprint((Certificate)certs[i]).equals(_certificateFingerprint)) continue;
                return certs[0];
            }
        }
        IBLog.severe("Cannot find signing certificate information for IBModContainer!", new Object[0]);
        return null;
    }

    private boolean validSignature() {
        return _certificateFingerprint.isEmpty() ? true : LoadingPlugin.getSigningCertificate() != null;
    }

    protected static MetadataCollection getMetadataCollection() {
        return _metadataCollection;
    }

    protected static String getVersionOverride() {
        return _version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readModInfo(String jarfile) {
        ZipFile jar = null;
        try {
            jar = new ZipFile(new File(jarfile));
            ZipEntry modInfo = jar.getEntry("mcmod.info");
            if (modInfo != null) {
                IBLog.fine("Located mcmod.info file", new Object[0]);
                _metadataCollection = MetadataCollection.from((InputStream)jar.getInputStream(modInfo), (String)jar.getName());
            } else {
                IBLog.fine("Container %s appears to be missing an mcmod.info file", jar.getName());
                _metadataCollection = MetadataCollection.from(null, (String)"");
            }
            Properties ver = null;
            ZipEntry versionFile = jar.getEntry("version.properties");
            if (versionFile != null) {
                ver = new Properties();
                ver.load(jar.getInputStream(versionFile));
                Version.init(ver);
                _version = Version.version();
            }
        }
        catch (Exception e) {
            IBLog.log(Level.WARNING, e, "Zip file %s failed to read properly, it will be ignored", jar.getName());
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

