/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.utils.Utils;
import forestry.core.utils.Vect;
import forestry.farming.logic.CropBlock;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class FarmableGenericSapling
implements IFarmable {
    final int saplingId;
    final int saplingMeta;
    ItemStack[] windfall;

    public FarmableGenericSapling(int saplingId, int saplingMeta) {
        this(saplingId, saplingMeta, new ItemStack[0]);
    }

    public FarmableGenericSapling(int saplingId, int saplingMeta, ItemStack[] windfall) {
        this.saplingId = saplingId;
        this.saplingMeta = saplingMeta;
        this.windfall = windfall;
    }

    @Override
    public boolean isSaplingAt(World world, int x, int y, int z) {
        if (world.func_72799_c(x, y, z)) {
            return false;
        }
        if (world.func_72798_a(x, y, z) == this.saplingId) {
            return true;
        }
        if (this.saplingMeta >= 0) {
            return world.func_72805_g(x, y, z) == this.saplingMeta;
        }
        return true;
    }

    @Override
    public ICrop getCropAt(World world, int x, int y, int z) {
        int blockid = world.func_72798_a(x, y, z);
        if (Block.field_71973_m[blockid] == null) {
            return null;
        }
        if (!Block.field_71973_m[blockid].isWood(world, x, y, z)) {
            return null;
        }
        return new CropBlock(world, blockid, world.func_72805_g(x, y, z), new Vect(x, y, z));
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        if (itemstack.field_77993_c != this.saplingId) {
            return false;
        }
        if (this.saplingMeta >= 0) {
            return itemstack.func_77960_j() == this.saplingMeta;
        }
        return true;
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        for (ItemStack drop : this.windfall) {
            if (!drop.func_77969_a(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean plantSaplingAt(ItemStack germling, World world, int x, int y, int z) {
        return germling.func_77946_l().func_77943_a(Utils.getForestryPlayer(world, x, y, z), world, x, y - 1, z, 1, 0.0f, 0.0f, 0.0f);
    }
}

