/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.farming.Farmables;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.utils.Utils;
import forestry.core.utils.Vect;
import forestry.farming.logic.FarmLogicHomogenous;
import java.util.Collection;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class FarmLogicInfernal
extends FarmLogicHomogenous {
    public FarmLogicInfernal(IFarmHousing housing) {
        super(housing, new ItemStack[]{new ItemStack(Block.field_72013_bc)}, new ItemStack[]{new ItemStack(Block.field_72013_bc)}, new ItemStack[0], ((Collection)Farmables.farmables.get("farmInfernal")).toArray(new IFarmable[0]));
    }

    @Override
    public String getName() {
        return "Managed Infernal Farm";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIcon() {
        return Item.field_77727_br.func_77617_a(0);
    }

    @Override
    public int getFertilizerConsumption() {
        return 20;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return 0;
    }

    @Override
    public Collection collect() {
        return null;
    }

    @Override
    public Collection harvest(int x, int y, int z, ForgeDirection direction, int extent) {
        this.world = this.housing.getWorld();
        Stack<ICrop> crops = new Stack<ICrop>();
        for (int i = 0; i < extent; ++i) {
            Vect position = this.translateWithOffset(x, y + 1, z, direction, i);
            for (IFarmable farmable : this.germlings) {
                ICrop crop = farmable.getCropAt(this.world, position.x, position.y, position.z);
                if (crop == null) continue;
                crops.push(crop);
            }
        }
        return crops;
    }

    @Override
    protected boolean maintainGermlings(int x, int y, int z, ForgeDirection direction, int extent) {
        for (int i = 0; i < extent; ++i) {
            Vect position = this.translateWithOffset(x, y, z, direction, i);
            if (!this.isAirBlock(position) && !Utils.isReplaceableBlock(this.world, position.x, position.y, position.z)) continue;
            ItemStack below = this.getAsItemStack(position.add(new Vect(0, -1, 0)));
            if (this.ground[0].field_77993_c != below.field_77993_c) continue;
            return this.trySetCrop(position);
        }
        return false;
    }

    private boolean trySetCrop(Vect position) {
        for (IFarmable candidate : this.germlings) {
            if (!this.housing.plantGermling(candidate, this.world, position.x, position.y, position.z)) continue;
            return true;
        }
        return false;
    }
}

