/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.proxy;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import forestry.core.config.Config;
import forestry.core.gadgets.MachineDefinition;
import forestry.core.interfaces.IBlockRenderer;
import forestry.core.proxy.Proxies;
import forestry.core.proxy.ProxyRender;
import forestry.core.render.BlockRenderingHandler;
import forestry.core.render.EntitySnowFX;
import forestry.core.render.RenderEscritoire;
import forestry.core.render.RenderMachine;
import forestry.core.render.RenderMill;
import forestry.core.render.TextureManager;
import forestry.core.render.TileRendererIndex;
import forestry.core.utils.ForestryResource;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ClientProxyRender
extends ProxyRender {
    @Override
    public int getNextAvailableRenderId() {
        return RenderingRegistry.getNextAvailableRenderId();
    }

    @Override
    public boolean fancyGraphicsEnabled() {
        return Proxies.common.getClientInstance().field_71474_y.field_74347_j;
    }

    @Override
    public boolean hasRendering() {
        return true;
    }

    @Override
    public void registerTESR(MachineDefinition definition) {
        BlockRenderingHandler.byBlockRenderer.put(new TileRendererIndex(Block.field_71973_m[definition.blockID], definition.meta), definition.renderer);
        ClientRegistry.bindTileEntitySpecialRenderer((Class)definition.teClass, (TileEntitySpecialRenderer)((TileEntitySpecialRenderer)definition.renderer));
    }

    @Override
    public IBlockRenderer getRenderDefaultMachine(String gfxBase) {
        return new RenderMachine(gfxBase);
    }

    @Override
    public IBlockRenderer getRenderMill(String gfxBase) {
        return new RenderMill(gfxBase);
    }

    @Override
    public IBlockRenderer getRenderMill(String gfxBase, byte charges) {
        return new RenderMill(gfxBase, charges);
    }

    @Override
    public IBlockRenderer getRenderEscritoire() {
        return new RenderEscritoire();
    }

    private boolean shouldSpawnParticle(World world, boolean canDisable) {
        if (canDisable && !Config.enableParticleFX) {
            return false;
        }
        Minecraft mc = FMLClientHandler.instance().getClient();
        int particleSetting = mc.field_71474_y.field_74362_aa;
        if (!canDisable && particleSetting > 1) {
            particleSetting = 1;
        }
        if (particleSetting == 1 && world.field_73012_v.nextInt(3) == 0) {
            particleSetting = 2;
        }
        return particleSetting <= 1;
    }

    @Override
    public void addSnowFX(World world, double xCoord, double yCoord, double zCoord, int color, int areaX, int areaY, int areaZ) {
        if (!this.shouldSpawnParticle(world, true)) {
            return;
        }
        double spawnX = xCoord + (double)world.field_73012_v.nextInt(areaX * 2) - (double)areaX;
        double spawnY = yCoord + (double)world.field_73012_v.nextInt(areaY);
        double spawnZ = zCoord + (double)world.field_73012_v.nextInt(areaZ * 2) - (double)areaZ;
        Proxies.common.getClientInstance().field_71452_i.func_78873_a((EntityFX)new EntitySnowFX(world, spawnX, spawnY, spawnZ, 0.0f, 0.0f, 0.0f));
    }

    @Override
    public short registerItemTexUID(IconRegister register, short uid, String ident) {
        TextureManager.getInstance().registerTexUID(register, uid, ident);
        return uid;
    }

    @Override
    public short registerTerrainTexUID(IconRegister register, short uid, String ident) {
        TextureManager.getInstance().registerTexUID(register, uid, ident);
        return uid;
    }

    @Override
    public void registerVillagerSkin(int villagerId, String texturePath) {
        VillagerRegistry.instance().registerVillagerSkin(villagerId, (ResourceLocation)new ForestryResource(texturePath));
    }
}

