/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import forestry.core.network.EntityNetData;
import forestry.core.network.IndexInPayload;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedList;

public class ClassMap {
    public static HashMap classMappers = new HashMap();
    private LinkedList intMember = new LinkedList();
    private LinkedList floatMember = new LinkedList();
    private LinkedList booleanMember = new LinkedList();
    private LinkedList stringMember = new LinkedList();
    private LinkedList enumMember = new LinkedList();
    private LinkedList objectMember = new LinkedList();
    public int intSize;
    public int floatSize;
    public int stringSize;
    private Field field;

    public void setData(Object obj, int[] intPayload, float[] floatPayload, String[] stringPayload, IndexInPayload index) throws IllegalAccessException {
        for (Field member : this.intMember) {
            intPayload[index.intIndex] = member.getInt(obj);
            ++index.intIndex;
        }
        for (Field member : this.floatMember) {
            floatPayload[index.floatIndex] = member.getFloat(obj);
            ++index.floatIndex;
        }
        for (Field member : this.booleanMember) {
            floatPayload[index.intIndex] = member.getBoolean(obj) ? 1.0f : 0.0f;
            ++index.intIndex;
        }
        for (Field member : this.stringMember) {
            stringPayload[index.stringIndex] = (String)member.get(obj);
            ++index.stringIndex;
        }
        for (Field member : this.enumMember) {
            intPayload[index.intIndex] = ((Enum)member.get(obj)).ordinal();
            ++index.intIndex;
        }
        for (ClassMap submap : this.objectMember) {
            Object source = submap.field.get(obj);
            if (source == null) {
                intPayload[index.intIndex] = 0;
                ++index.intIndex;
                index.intIndex += submap.intSize;
                index.floatIndex += submap.floatSize;
                index.stringIndex += submap.stringSize;
                continue;
            }
            intPayload[index.intIndex] = 1;
            ++index.intIndex;
            submap.setData(source, intPayload, floatPayload, stringPayload, index);
        }
    }

    public void fromData(Object obj, int[] intPayload, float[] floatPayload, String[] stringPayload, IndexInPayload index) throws IllegalAccessException {
        for (Field member : this.intMember) {
            member.setInt(obj, intPayload[index.intIndex]);
            ++index.intIndex;
        }
        for (Field member : this.booleanMember) {
            member.setBoolean(obj, intPayload[index.intIndex] == 1);
            ++index.intIndex;
        }
        for (Field member : this.enumMember) {
            member.set(obj, ((Class)member.getGenericType()).getEnumConstants()[intPayload[index.intIndex]]);
            ++index.intIndex;
        }
        for (Field member : this.floatMember) {
            member.setFloat(obj, floatPayload[index.floatIndex]);
            ++index.floatIndex;
        }
        for (Field member : this.stringMember) {
            member.set(obj, stringPayload[index.stringIndex]);
            ++index.stringIndex;
        }
        for (ClassMap map : this.objectMember) {
            boolean isNull = intPayload[index.intIndex] == 0;
            ++index.intIndex;
            if (isNull) {
                index.intIndex += map.intSize;
                index.floatIndex += map.floatSize;
                index.stringIndex += map.stringSize;
                continue;
            }
            map.field.get(obj);
            map.fromData(map.field.get(obj), intPayload, floatPayload, stringPayload, index);
        }
    }

    public ClassMap(Class targetClass) {
        Field[] fields = targetClass.getFields();
        try {
            for (Field field : fields) {
                if (!this.isNetworkedMember(field)) continue;
                Type type = field.getGenericType();
                if (type instanceof Class && !((Class)type).isArray()) {
                    Class memberClass = (Class)type;
                    if (memberClass.equals(Integer.TYPE)) {
                        ++this.intSize;
                        this.intMember.add(field);
                        continue;
                    }
                    if (memberClass.equals(Float.TYPE)) {
                        ++this.floatSize;
                        this.floatMember.add(field);
                        continue;
                    }
                    if (memberClass.equals(Boolean.TYPE)) {
                        ++this.intSize;
                        this.booleanMember.add(field);
                        continue;
                    }
                    if (memberClass.equals(String.class)) {
                        ++this.stringSize;
                        this.stringMember.add(field);
                        continue;
                    }
                    if (Enum.class.isAssignableFrom(memberClass)) {
                        ++this.intSize;
                        this.enumMember.add(field);
                        continue;
                    }
                    ClassMap mapper = new ClassMap(memberClass);
                    mapper.field = field;
                    this.objectMember.add(mapper);
                    ++this.intSize;
                    this.intSize += mapper.intSize;
                    this.floatSize += mapper.floatSize;
                    this.stringSize += mapper.stringSize;
                    continue;
                }
                if (!(type instanceof Class) || !((Class)type).isArray()) continue;
                throw new RuntimeException("Tried to map class " + targetClass.toString() + " but it requested mapping of an array. Not handled!");
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    private boolean isNetworkedMember(Field member) {
        return member.getAnnotation(EntityNetData.class) != null;
    }
}

