/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.slots;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.config.ForestryItem;
import forestry.core.gui.slots.SlotForestry;
import forestry.core.interfaces.ICrafter;
import forestry.core.render.TextureManager;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;

public class SlotCustom
extends SlotForestry {
    protected Object[] items;
    private boolean exclusion;
    private ICrafter crafter;
    private String blockedTexture = "slots/blocked";

    public SlotCustom(IInventory iinventory, int i, int j, int k, boolean exclusion) {
        super(iinventory, i, j, k);
        this.items = new Object[0];
        this.exclusion = exclusion;
    }

    public SlotCustom(IInventory iinventory, ArrayList items, int i, int j, int k) {
        this(iinventory, i, j, k, items.toArray());
    }

    public SlotCustom(IInventory iinventory, Collection items, int i, int j, int k) {
        this(iinventory, i, j, k, items.toArray());
    }

    public SlotCustom(IInventory iinventory, int i, int j, int k, boolean exclusion, Object ... items) {
        this(iinventory, i, j, k, items);
        this.exclusion = exclusion;
    }

    public SlotCustom(IInventory iinventory, int i, int j, int k, Object ... items) {
        super(iinventory, i, j, k);
        this.items = items;
    }

    public SlotCustom setCrafter(ICrafter crafter) {
        this.crafter = crafter;
        return this;
    }

    public boolean func_75214_a(ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        if (!this.field_75224_c.func_94041_b(this.getSlotIndex(), itemstack)) {
            return false;
        }
        if (this.exclusion) {
            return !this.determineValidity(itemstack);
        }
        return this.determineValidity(itemstack);
    }

    public boolean func_75216_d() {
        if (this.crafter != null && !this.crafter.canTakeStack(this.getSlotIndex())) {
            return false;
        }
        return super.func_75216_d();
    }

    @Override
    public ItemStack func_75209_a(int i) {
        if (this.crafter != null && !this.crafter.canTakeStack(this.getSlotIndex())) {
            return null;
        }
        return super.func_75209_a(i);
    }

    public void func_82870_a(EntityPlayer player, ItemStack itemStack) {
        if (this.crafter != null) {
            this.crafter.takenFromSlot(this.getSlotIndex(), true, player);
        }
    }

    private boolean determineValidity(ItemStack itemstack) {
        for (Object filter : this.items) {
            if (filter == null) continue;
            if (filter instanceof Class) {
                if (itemstack.field_77993_c < Block.field_71973_m.length && Block.field_71973_m[itemstack.field_77993_c] != null && ((Class)filter).isAssignableFrom(Block.field_71973_m[itemstack.field_77993_c].getClass())) {
                    return true;
                }
                if (itemstack.field_77993_c < Block.field_71973_m.length && Block.field_71973_m[itemstack.field_77993_c] != null || Item.field_77698_e[itemstack.field_77993_c] == null || !((Class)filter).isAssignableFrom(Item.field_77698_e[itemstack.field_77993_c].getClass())) continue;
                return true;
            }
            if (filter instanceof ItemStack) {
                if (((ItemStack)filter).func_77960_j() == Short.MAX_VALUE && itemstack.field_77993_c == ((ItemStack)filter).field_77993_c) {
                    return true;
                }
                if (!itemstack.func_77969_a((ItemStack)filter)) continue;
                return true;
            }
            if (filter instanceof Block && itemstack.field_77993_c == ((Block)filter).field_71990_ca) {
                return true;
            }
            if (filter instanceof Item && itemstack.field_77993_c == ((Item)filter).field_77779_bT) {
                return true;
            }
            if (filter instanceof ForestryItem && ((ForestryItem)((Object)filter)).isItemEqual(itemstack)) {
                return true;
            }
            if (!(filter instanceof ISpeciesRoot ? ((ISpeciesRoot)filter).isMember(itemstack) : filter instanceof Integer && itemstack.field_77993_c == (Integer)filter)) continue;
            return true;
        }
        return false;
    }

    public SlotCustom setBlockedTexture(String ident) {
        this.blockedTexture = ident;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_75212_b() {
        if (!this.field_75224_c.func_94041_b(this.getSlotIndex(), null)) {
            return TextureManager.getInstance().getDefault(this.blockedTexture);
        }
        return null;
    }
}

