/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.api.apiculture.IApiaristTracker;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.genetics.EnumMutateChance;
import forestry.core.gui.ContainerForestry;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.IPagedInventory;
import forestry.core.gui.buttons.GuiBetterButton;
import forestry.core.gui.buttons.StandardButtonTextureSets;
import forestry.core.network.PacketPayload;
import forestry.core.network.PacketUpdate;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;
import java.util.HashMap;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class GuiNaturalistInventory
extends GuiForestry {
    private final EntityPlayer player;
    private IPagedInventory inventory;
    private ISpeciesRoot speciesRoot;
    private IBreedingTracker breedingTracker;
    private HashMap iconStacks = new HashMap();
    private final int pageCurrent;
    private final int pageMax;

    public GuiNaturalistInventory(ISpeciesRoot speciesRoot, EntityPlayer player, ContainerForestry container, IPagedInventory inventory, int page, int maxPages) {
        super("textures/gui/apiaristinventory.png", container, (Object)inventory);
        this.player = player;
        this.inventory = inventory;
        this.speciesRoot = speciesRoot;
        this.pageCurrent = page;
        this.pageMax = maxPages;
        this.field_74194_b = 196;
        this.field_74195_c = 202;
        for (IIndividual individual : speciesRoot.getIndividualTemplates()) {
            this.iconStacks.put(individual.getIdent(), speciesRoot.getMemberStack(individual, 0));
        }
        this.breedingTracker = speciesRoot.getBreedingTracker(player.field_70170_p, player.field_71092_bJ);
    }

    @Override
    protected void func_74185_a(float f, int i, int j) {
        super.func_74185_a(f, i, j);
        String header = StringUtil.localize("gui.page") + " " + (this.pageCurrent + 1) + "/" + this.pageMax;
        this.field_73886_k.func_78276_b(header, this.field_74198_m + 95 + this.getCenteredOffset(header, 98), this.field_74197_n + 10, this.fontColor.get("gui.title"));
        IIndividual individual = this.getIndividualAtPosition(i, j);
        if (individual == null) {
            this.displayBreedingStatistics(10);
        }
        if (individual != null) {
            RenderHelper.func_74520_c();
            this.startPage();
            this.displaySpeciesInformation(true, individual.getGenome().getPrimary(), (ItemStack)this.iconStacks.get(individual.getIdent()), 10);
            if (!individual.isPureBred(0)) {
                this.displaySpeciesInformation(individual.isAnalyzed(), individual.getGenome().getSecondary(), (ItemStack)this.iconStacks.get(individual.getGenome().getSecondary().getUID()), 10);
            }
            this.endPage();
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_73887_h.add(new GuiBetterButton(1, this.field_74198_m + 99, this.field_74197_n + 7, StandardButtonTextureSets.LEFT_BUTTON_SMALL));
        this.field_73887_h.add(new GuiBetterButton(2, this.field_74198_m + 180, this.field_74197_n + 7, StandardButtonTextureSets.RIGHT_BUTTON_SMALL));
    }

    private void flipPage(int page) {
        PacketPayload payload = new PacketPayload(1, 0, 0);
        payload.intPayload[0] = page;
        PacketUpdate packet = new PacketUpdate(30, payload);
        Proxies.net.sendToServer(packet);
    }

    protected void func_73875_a(GuiButton guibutton) {
        super.func_73875_a(guibutton);
        if (guibutton.field_73741_f == 1 && this.pageCurrent > 0) {
            this.flipPage(this.pageCurrent - 1);
        } else if (guibutton.field_73741_f == 2 && this.pageCurrent < this.pageMax - 1) {
            this.flipPage(this.pageCurrent + 1);
        }
    }

    private IIndividual getIndividualAtPosition(int x, int y) {
        Slot slot = this.getSlotAtPosition(x, y);
        if (slot == null) {
            return null;
        }
        if (!slot.func_75216_d()) {
            return null;
        }
        if (!slot.func_75211_c().func_77942_o()) {
            return null;
        }
        if (!this.speciesRoot.isMember(slot.func_75211_c())) {
            return null;
        }
        return this.speciesRoot.getMember(slot.func_75211_c());
    }

    private void displayBreedingStatistics(int x) {
        this.startPage();
        this.drawLine(StringUtil.localize("gui.speciescount") + ": " + this.breedingTracker.getSpeciesBred() + "/" + this.speciesRoot.getSpeciesCount(), x);
        this.newLine();
        this.newLine();
        if (this.breedingTracker instanceof IApiaristTracker) {
            IApiaristTracker tracker = (IApiaristTracker)this.breedingTracker;
            this.drawLine(StringUtil.localize("gui.queens") + ": " + tracker.getQueenCount(), x);
            this.newLine();
            this.drawLine(StringUtil.localize("gui.princesses") + ": " + tracker.getPrincessCount(), x);
            this.newLine();
            this.drawLine(StringUtil.localize("gui.drones") + ": " + tracker.getDroneCount(), x);
            this.newLine();
        }
        this.endPage();
    }

    private void displaySpeciesInformation(boolean analyzed, IAlleleSpecies species, ItemStack iconStack, int x) {
        if (!analyzed) {
            this.drawLine(StringUtil.localize("gui.unknown"), x);
            return;
        }
        this.drawLine(species.getName(), x);
        RenderHelper.func_74520_c();
        this.drawItemStack(iconStack, this.adjustToFactor(this.field_74198_m + x + 69), this.adjustToFactor(this.field_74197_n + this.getLineY() - 2));
        RenderHelper.func_74518_a();
        this.newLine();
        int columnWidth = 16;
        int column = 10;
        for (IMutation combination : this.speciesRoot.getCombinations(species)) {
            if (combination.isSecret()) continue;
            if (this.breedingTracker.isDiscovered(combination)) {
                this.drawMutationIcon(combination, species, column);
            } else {
                this.drawUnknownIcon(combination, column);
            }
            if ((column += columnWidth) <= 75) continue;
            column = 10;
            this.newLine(18);
        }
        this.newLine();
        this.newLine();
    }

    private void drawMutationIcon(IMutation combination, IAlleleSpecies species, int x) {
        RenderHelper.func_74520_c();
        this.drawItemStack((ItemStack)this.iconStacks.get(combination.getPartner(species).getUID()), this.adjustToFactor(this.field_74198_m + x), this.adjustToFactor(this.field_74197_n + this.getLineY()));
        RenderHelper.func_74518_a();
        int line = 48;
        int column = 0;
        EnumMutateChance chance = EnumMutateChance.rateChance(combination.getBaseChance());
        if (chance == EnumMutateChance.HIGHEST) {
            line += 16;
            column = 228;
        } else if (chance == EnumMutateChance.HIGHER) {
            line += 16;
            column = 212;
        } else if (chance == EnumMutateChance.HIGH) {
            line += 16;
            column = 196;
        } else if (chance == EnumMutateChance.NORMAL) {
            line += 0;
            column = 228;
        } else if (chance == EnumMutateChance.LOW) {
            line += 0;
            column = 212;
        } else {
            line += 0;
            column = 196;
        }
        Proxies.common.bindTexture(this.textureFile);
        this.func_73729_b(this.adjustToFactor(this.field_74198_m + x), this.adjustToFactor(this.field_74197_n + this.getLineY()), column, line, 16, 16);
    }

    private void drawUnknownIcon(IMutation mutation, int x) {
        float chance = mutation.getBaseChance();
        int line = 0;
        int column = 0;
        if (chance >= 20.0f) {
            line = 16;
            column = 228;
        } else if (chance >= 15.0f) {
            line = 16;
            column = 212;
        } else if (chance >= 12.0f) {
            line = 16;
            column = 196;
        } else if (chance >= 10.0f) {
            line = 0;
            column = 228;
        } else if (chance >= 5.0f) {
            line = 0;
            column = 212;
        } else {
            line = 0;
            column = 196;
        }
        Proxies.common.bindTexture(this.textureFile);
        this.func_73729_b(this.adjustToFactor(this.field_74198_m + x), this.adjustToFactor(this.field_74197_n + this.getLineY()), column, line, 16, 16);
    }

    protected boolean func_82319_a(int key) {
        return false;
    }
}

