/*
 * Decompiled with CFR 0.152.
 */
package openblocks.enchantments;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import openblocks.Config;
import openblocks.OpenBlocks;
import openmods.OpenMods;

public class ExplosiveEnchantmentsHandler {
    public static final int ARMOR_HELMET = 3;
    public static final int ARMOR_CHESTPIECE = 2;
    public static final int ARMOR_PANTS = 1;
    public static final int ARMOR_BOOTS = 0;
    private final List<Integer> protectionParts = Lists.newArrayList((Object[])new Integer[]{2, 3, 1});
    private static final double VERTICAL_FACTOR = 5.0;
    private static final Set<String> ALLOWED_DAMAGE_SOURCE = ImmutableSet.of((Object)"arrow", (Object)"player", (Object)"mob");
    private static final EnchantmentLevel[] LEVELS = new EnchantmentLevel[]{null, new EnchantmentLevel(0.1, 5.0, 5.0f, 1.0f, false, 1), new EnchantmentLevel(0.75, 7.5, 10.0f, 2.0f, false, 2), new EnchantmentLevel(1.0, 10.0, 5.0f, 4.0f, Config.explosiveEnchantGrief, 4)};
    private Map<Entity, JumpInfo> jumpBoosts = new MapMaker().weakKeys().makeMap();
    private static final ItemStack gunpowder = new ItemStack(Item.field_77677_M);

    public static void createExplosionForEntity(Entity entity, float power, boolean isDestructive) {
        if (!entity.field_70170_p.field_72995_K) {
            entity.field_70170_p.func_72876_a(entity, entity.field_70165_t, entity.field_70121_D.field_72338_b, entity.field_70161_v, power, isDestructive);
        }
    }

    private static void useItems(EntityPlayer player, int gunpowderSlot, int armorSlot, int gunpowderAmout) {
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        InventoryPlayer inventory = player.field_71071_by;
        ItemStack armor = inventory.func_70440_f(armorSlot);
        armor.func_77972_a(1, (EntityLivingBase)player);
        if (armor.field_77994_a <= 0) {
            inventory.field_70460_b[armorSlot] = null;
        }
        ItemStack resource = inventory.field_70462_a[gunpowderSlot];
        resource.field_77994_a -= gunpowderAmout;
        if (resource.field_77994_a <= 0) {
            inventory.field_70462_a[gunpowderSlot] = null;
        }
    }

    private static EnchantmentLevel tryUseEnchantment(EntityPlayer player, int armorSlot) {
        InventoryPlayer inventory = player.field_71071_by;
        ItemStack armor = inventory.field_70460_b[armorSlot];
        if (armor == null || !(armor.func_77973_b() instanceof ItemArmor)) {
            return null;
        }
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)armor);
        Integer ench = (Integer)enchantments.get(OpenBlocks.Enchantments.explosive.field_77352_x);
        if (ench == null || ench > LEVELS.length) {
            return null;
        }
        EnchantmentLevel level = LEVELS[ench];
        if (level == null) {
            return null;
        }
        for (int i = 0; i < inventory.field_70462_a.length; ++i) {
            ItemStack stack = inventory.field_70462_a[i];
            if (stack == null || !gunpowder.func_77969_a(stack) || stack.field_77994_a < level.gunpowderNeeded) continue;
            ExplosiveEnchantmentsHandler.useItems(player, i, armorSlot, level.gunpowderNeeded);
            return level;
        }
        return null;
    }

    private EnchantmentLevel tryUseUpperArmor(EntityPlayer player) {
        Collections.shuffle(this.protectionParts);
        for (int armorPart : this.protectionParts) {
            EnchantmentLevel result = ExplosiveEnchantmentsHandler.tryUseEnchantment(player, armorPart);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @ForgeSubscribe
    public void onFall(LivingFallEvent evt) {
        EntityLivingBase e = evt.entityLiving;
        if (evt.distance > 4.0f && !e.func_70093_af() && e instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e;
            EnchantmentLevel level = ExplosiveEnchantmentsHandler.tryUseEnchantment(player, 0);
            if (level == null) {
                return;
            }
            JumpInfo boost = new JumpInfo(level, evt.distance);
            level.createJumpExplosion((Entity)player);
            if (OpenMods.proxy.isClientPlayer((Entity)player)) {
                Minecraft.func_71410_x().field_71474_y.field_74314_A.field_74513_e = true;
                this.jumpBoosts.put((Entity)player, boost);
            } else if (e instanceof EntityPlayerMP) {
                EntityPlayerMP serverPlayer = (EntityPlayerMP)player;
                serverPlayer.field_71135_a.field_72572_g = 0;
            } else {
                return;
            }
            evt.setCanceled(true);
        }
    }

    @ForgeSubscribe
    public void onJump(LivingEvent.LivingJumpEvent e) {
        Entity entity = e.entity;
        JumpInfo boost = this.jumpBoosts.remove(entity);
        if (boost != null) {
            boost.modifyVelocity(entity);
            if (OpenMods.proxy.isClientPlayer(entity)) {
                Minecraft.func_71410_x().field_71474_y.field_74314_A.field_74513_e = false;
            }
        }
    }

    private static boolean checkSource(DamageSource source) {
        return source instanceof EntityDamageSource && ALLOWED_DAMAGE_SOURCE.contains(source.field_76373_n);
    }

    @ForgeSubscribe
    public void onDamage(LivingAttackEvent e) {
        EnchantmentLevel level;
        Entity victim = e.entity;
        if (victim instanceof EntityPlayerMP && ExplosiveEnchantmentsHandler.checkSource(e.source) && (level = this.tryUseUpperArmor((EntityPlayer)victim)) != null) {
            level.createArmorExplosion(victim);
        }
    }

    private static class JumpInfo {
        public final EnchantmentLevel level;
        public final float height;

        private JumpInfo(EnchantmentLevel level, float height) {
            this.level = level;
            this.height = height;
        }

        public void modifyVelocity(Entity entity) {
            double multiplier = this.level.calculateMultipler(this.height);
            entity.field_70159_w *= multiplier * 5.0;
            entity.field_70179_y *= multiplier * 5.0;
            entity.field_70181_x *= multiplier;
        }
    }

    private static class EnchantmentLevel {
        public final double multiplier;
        public final double maxHeightBonus;
        public final float jumpExplosionPower;
        public final float armorExplosionPower;
        public final boolean isDestructive;
        public final int gunpowderNeeded;

        private EnchantmentLevel(double multiplier, double maxHeightBonus, float jumpExplosionPower, float armorExplosionPower, boolean isDestructive, int gunpowderNeeded) {
            this.multiplier = multiplier;
            this.maxHeightBonus = maxHeightBonus;
            this.jumpExplosionPower = jumpExplosionPower;
            this.armorExplosionPower = armorExplosionPower;
            this.isDestructive = isDestructive;
            this.gunpowderNeeded = gunpowderNeeded;
        }

        protected double calculateHeightBonus(float height) {
            return Math.min(Math.sqrt(height), this.maxHeightBonus);
        }

        public double calculateMultipler(float height) {
            return this.multiplier + this.calculateHeightBonus(height);
        }

        public void createJumpExplosion(Entity entity) {
            ExplosiveEnchantmentsHandler.createExplosionForEntity(entity, this.jumpExplosionPower, this.isDestructive);
        }

        public void createArmorExplosion(Entity entity) {
            ExplosiveEnchantmentsHandler.createExplosionForEntity(entity, this.armorExplosionPower, this.isDestructive);
        }
    }
}

