/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.Iterator;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import openblocks.Config;
import openblocks.client.gui.GuiDigitalFuse;
import openblocks.common.container.ContainerDigitalFuse;
import openmods.OpenMods;
import openmods.api.IHasGui;
import openmods.api.INeighbourAwareTile;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableFlags;
import openmods.sync.SyncableInt;
import openmods.tileentity.SyncedTileEntity;

public class TileEntityDigitalFuse
extends SyncedTileEntity
implements INeighbourAwareTile,
IHasGui {
    private static byte STATE_RESET = 1;
    private static byte STATE_POWERED = (byte)2;
    private static byte STATE_OUTPUT = (byte)4;
    private SyncableInt timeLeft;
    private SyncableInt resetTime;
    private SyncableFlags stateFlags;
    private long lastTime = System.currentTimeMillis();

    protected void createSyncedFields() {
        this.timeLeft = new SyncableInt(500);
        this.resetTime = new SyncableInt(500);
        this.stateFlags = new SyncableFlags();
    }

    protected void initialize() {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        this.onNeighbourChanged(0);
    }

    public void func_70316_g() {
        super.func_70316_g();
        long currentTime = System.currentTimeMillis();
        if (this.stateFlags.get((int)STATE_POWERED)) {
            long timeDifference = currentTime - this.lastTime;
            if (timeDifference > 1000L) {
                timeDifference -= 1000L;
                if (this.timeLeft.getValue() > 0) {
                    this.timeLeft.modify(-1);
                    if (this.timeLeft.getValue() != 0 && this.shouldSync()) {
                        this.sync();
                    }
                }
                this.lastTime = currentTime + timeDifference;
            }
            if (this.field_70331_k.field_72995_K) {
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
        } else {
            this.lastTime = System.currentTimeMillis();
        }
        this.stateFlags.set((int)STATE_OUTPUT, this.timeLeft.getValue() == 0);
        if (!this.field_70331_k.field_72995_K) {
            this.sync();
        }
        if (this.stateFlags.ticksSinceSet(OpenMods.proxy, this.field_70331_k, (int)STATE_OUTPUT) == 0 || this.stateFlags.ticksSinceUnset(OpenMods.proxy, this.field_70331_k, (int)STATE_OUTPUT) == 0) {
            this.updateOutputBlock();
        }
    }

    private void updateOutputBlock() {
        ForgeDirection rotate = this.getRotation();
        this.field_70331_k.func_72821_m(this.field_70329_l + rotate.offsetX, this.field_70330_m + rotate.offsetY, this.field_70327_n + rotate.offsetZ, Config.blockDigitalFuseId);
    }

    public SyncableInt getTimeLeft() {
        return this.timeLeft;
    }

    public SyncableInt getResetTime() {
        return this.resetTime;
    }

    public boolean isOutputtingPower() {
        return this.stateFlags.get((int)STATE_OUTPUT);
    }

    private boolean shouldSync() {
        long ticks = OpenMods.proxy.getTicks(this.field_70331_k);
        int left = this.timeLeft.getValue();
        int interval = left > 0 && left < 10 ? 2 : 10;
        return !this.field_70331_k.field_72995_K && ticks % (long)interval == 0L;
    }

    public void onSynced(Set<ISyncableObject> changes) {
    }

    public void onNeighbourChanged(int blockId) {
        if (!this.field_70331_k.field_72995_K) {
            ForgeDirection rotation = this.getRotation();
            this.stateFlags.set((int)STATE_POWERED, this.isPoweredOnSide(rotation.getRotation(ForgeDirection.UP)));
            this.stateFlags.set((int)STATE_RESET, this.isPoweredOnSide(rotation.getRotation(ForgeDirection.DOWN)));
            if (this.stateFlags.get((int)STATE_RESET)) {
                this.timeLeft.setValue(this.resetTime.getValue());
            }
            this.sync();
        }
    }

    private boolean isPoweredOnSide(ForgeDirection side) {
        int pX = this.field_70329_l + side.offsetX;
        int pY = this.field_70330_m + side.offsetY;
        int pZ = this.field_70327_n + side.offsetZ;
        if (this.field_70331_k.func_72799_c(pX, pY, pZ)) {
            return false;
        }
        int blockId = this.field_70331_k.func_72798_a(pX, pY, pZ);
        Block block = Block.field_71973_m[blockId];
        if (block == Block.field_72075_av) {
            return this.field_70331_k.func_72805_g(pX, pY, pZ) > 0;
        }
        if (block.func_96468_q_()) {
            return block.func_94328_b_(this.field_70331_k, pX, pY, pZ, side.getOpposite().ordinal()) > 0;
        }
        if (block.func_71853_i()) {
            return Math.max(block.func_71855_c((IBlockAccess)this.field_70331_k, pX, pY, pZ, side.getOpposite().ordinal()), block.func_71865_a((IBlockAccess)this.field_70331_k, pX, pY, pZ, side.getOpposite().ordinal())) > 0;
        }
        return false;
    }

    public Object getServerGui(EntityPlayer player) {
        return new ContainerDigitalFuse((IInventory)player.field_71071_by, this);
    }

    public Object getClientGui(EntityPlayer player) {
        return new GuiDigitalFuse((ContainerDigitalFuse)((Object)this.getServerGui(player)));
    }

    public boolean canOpenGui(EntityPlayer player) {
        return true;
    }

    public int getSignalFlags() {
        int flags = 0;
        Iterator i$ = this.stateFlags.getActiveSlots().iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            flags |= i;
        }
        return flags;
    }
}

