/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.Random;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import openblocks.OpenBlocks;
import openblocks.client.gui.GuiAutoEnchantmentTable;
import openblocks.common.container.ContainerAutoEnchantmentTable;
import openmods.GenericInventory;
import openmods.IInventoryProvider;
import openmods.api.IHasGui;
import openmods.include.IExtendable;
import openmods.include.IncludeInterface;
import openmods.include.IncludeOverride;
import openmods.liquids.SidedFluidHandler;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableFlags;
import openmods.sync.SyncableInt;
import openmods.sync.SyncableTank;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.EnchantmentUtils;
import openmods.utils.InventoryUtils;
import openmods.utils.SidedInventoryAdapter;

public class TileEntityAutoEnchantmentTable
extends SyncedTileEntity
implements IInventoryProvider,
IHasGui,
IExtendable {
    protected static final int TANK_CAPACITY = EnchantmentUtils.getLiquidForLevel((int)30);
    private SyncableTank tank;
    private SyncableFlags inputSides;
    private SyncableFlags outputSides;
    private SyncableFlags xpSides;
    private SyncableInt targetLevel;
    private SyncableFlags automaticSlots;
    private final GenericInventory inventory = new GenericInventory("autoenchant", true, 2){

        public boolean func_94041_b(int i, ItemStack itemstack) {
            if (i == Slots.input.ordinal()) {
                return !itemstack.func_77948_v();
            }
            return i == Slots.input.ordinal();
        }
    };
    @IncludeInterface(value=ISidedInventory.class)
    private final SidedInventoryAdapter slotSides = new SidedInventoryAdapter((IInventory)this.inventory);
    @IncludeInterface
    private final IFluidHandler tankWrapper = new SidedFluidHandler.Drain(this.xpSides, (IFluidTank)this.tank);
    public int tickCount;
    public float pageFlip;
    public float pageFlipPrev;
    public float field_70373_d;
    public float field_70374_e;
    public float bookSpread;
    public float bookSpreadPrev;
    public float bookRotation2;
    public float bookRotationPrev;
    public float bookRotation;
    private static Random rand = new Random();

    public TileEntityAutoEnchantmentTable() {
        this.slotSides.registerSlot((Enum)Slots.input, this.inputSides, true, false);
        this.slotSides.registerSlot((Enum)Slots.output, this.outputSides, false, true);
    }

    protected void createSyncedFields() {
        this.tank = new SyncableTank(TANK_CAPACITY, new FluidStack[]{OpenBlocks.XP_FLUID});
        this.inputSides = new SyncableFlags();
        this.outputSides = new SyncableFlags();
        this.xpSides = new SyncableFlags();
        this.targetLevel = new SyncableInt(1);
        this.automaticSlots = new SyncableFlags();
    }

    public void func_70316_g() {
        super.func_70316_g();
        this.handleBookRotation();
        if (!this.field_70331_k.field_72995_K) {
            int xpRequired;
            if (this.automaticSlots.get((Enum)AutoSlots.xp)) {
                this.tank.fillFromSides(80, this.field_70331_k, this.getPosition(), this.xpSides);
            }
            if (this.shouldAutoOutput() && this.hasStack(Slots.output)) {
                InventoryUtils.moveItemsToOneOfSides((TileEntity)this, (Enum)Slots.output, (int)1, (SyncableFlags)this.outputSides);
            }
            if (this.shouldAutoInput() && !this.hasStack(Slots.input)) {
                InventoryUtils.moveItemsFromOneOfSides((TileEntity)this, null, (int)1, (Enum)Slots.input, (SyncableFlags)this.inputSides);
            }
            if (this.hasStack(Slots.input) && this.inventory.func_94041_b(Slots.input.ordinal(), this.getStack(Slots.input)) && !this.hasStack(Slots.output) && (xpRequired = EnchantmentUtils.getLiquidForLevel((int)this.targetLevel.getValue())) > 0 && this.tank.getFluidAmount() >= xpRequired) {
                double power = EnchantmentUtils.getPower((World)this.field_70331_k, (int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n);
                int enchantability = EnchantmentUtils.calcEnchantability((ItemStack)this.getStack(Slots.input), (int)((int)power), (boolean)true);
                if (enchantability >= this.targetLevel.getValue()) {
                    ItemStack inputStack = this.getStack(Slots.input);
                    if (inputStack == null) {
                        return;
                    }
                    ItemStack resultingStack = inputStack.func_77946_l();
                    resultingStack.field_77994_a = 1;
                    if (EnchantmentUtils.enchantItem((ItemStack)resultingStack, (int)this.targetLevel.getValue(), (Random)this.field_70331_k.field_73012_v)) {
                        this.tank.drain(xpRequired, true);
                        --inputStack.field_77994_a;
                        if (inputStack.field_77994_a < 1) {
                            this.setStack(Slots.input, null);
                        }
                        this.setStack(Slots.output, resultingStack);
                    }
                }
            }
        }
    }

    private void handleBookRotation() {
        float f1;
        this.bookSpreadPrev = this.bookSpread;
        this.bookRotationPrev = this.bookRotation2;
        EntityPlayer entityplayer = this.field_70331_k.func_72977_a((double)((float)this.field_70329_l + 0.5f), (double)((float)this.field_70330_m + 0.5f), (double)((float)this.field_70327_n + 0.5f), 3.0);
        if (entityplayer != null) {
            double d0 = entityplayer.field_70165_t - (double)((float)this.field_70329_l + 0.5f);
            double d1 = entityplayer.field_70161_v - (double)((float)this.field_70327_n + 0.5f);
            this.bookRotation = (float)Math.atan2(d1, d0);
            this.bookSpread += 0.1f;
            if (this.bookSpread < 0.5f || rand.nextInt(40) == 0) {
                float f = this.field_70373_d;
                do {
                    this.field_70373_d += (float)(rand.nextInt(4) - rand.nextInt(4));
                } while (f == this.field_70373_d);
            }
        } else {
            this.bookRotation += 0.02f;
            this.bookSpread -= 0.1f;
        }
        while (this.bookRotation2 >= (float)Math.PI) {
            this.bookRotation2 -= (float)Math.PI * 2;
        }
        while (this.bookRotation2 < (float)(-Math.PI)) {
            this.bookRotation2 += (float)Math.PI * 2;
        }
        while (this.bookRotation >= (float)Math.PI) {
            this.bookRotation -= (float)Math.PI * 2;
        }
        while (this.bookRotation < (float)(-Math.PI)) {
            this.bookRotation += (float)Math.PI * 2;
        }
        for (f1 = this.bookRotation - this.bookRotation2; f1 >= (float)Math.PI; f1 -= (float)Math.PI * 2) {
        }
        while (f1 < (float)(-Math.PI)) {
            f1 += (float)Math.PI * 2;
        }
        this.bookRotation2 += f1 * 0.4f;
        if (this.bookSpread < 0.0f) {
            this.bookSpread = 0.0f;
        }
        if (this.bookSpread > 1.0f) {
            this.bookSpread = 1.0f;
        }
        ++this.tickCount;
        this.pageFlipPrev = this.pageFlip;
        float f2 = (this.field_70373_d - this.pageFlip) * 0.4f;
        float f3 = 0.2f;
        if (f2 < -f3) {
            f2 = -f3;
        }
        if (f2 > f3) {
            f2 = f3;
        }
        this.field_70374_e += (f2 - this.field_70374_e) * 0.9f;
        this.pageFlip += this.field_70374_e;
    }

    private boolean shouldAutoInput() {
        return this.automaticSlots.get((Enum)AutoSlots.input);
    }

    private boolean shouldAutoOutput() {
        return this.automaticSlots.get((Enum)AutoSlots.output);
    }

    public boolean hasStack(Enum<?> slot) {
        return this.getStack(slot) != null;
    }

    public SyncableInt getTargetLevel() {
        return this.targetLevel;
    }

    public void setStack(Enum<?> slot, ItemStack stack) {
        this.inventory.func_70299_a(slot.ordinal(), stack);
    }

    public ItemStack getStack(Enum<?> slot) {
        return this.inventory.getStackInSlot(slot);
    }

    public Object getServerGui(EntityPlayer player) {
        return new ContainerAutoEnchantmentTable((IInventory)player.field_71071_by, this);
    }

    public Object getClientGui(EntityPlayer player) {
        return new GuiAutoEnchantmentTable(new ContainerAutoEnchantmentTable((IInventory)player.field_71071_by, this));
    }

    public boolean canOpenGui(EntityPlayer player) {
        return true;
    }

    public void onSynced(Set<ISyncableObject> changes) {
    }

    @IncludeOverride
    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public IFluidTank getTank() {
        return this.tank;
    }

    public SyncableFlags getInputSides() {
        return this.inputSides;
    }

    public SyncableFlags getOutputSides() {
        return this.outputSides;
    }

    public SyncableFlags getXPSides() {
        return this.xpSides;
    }

    public SyncableFlags getAutomaticSlots() {
        return this.automaticSlots;
    }

    public IInventory getInventory() {
        return this.slotSides;
    }

    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        this.inventory.writeToNBT(tag);
    }

    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.inventory.readFromNBT(tag);
    }

    public static enum AutoSlots {
        input,
        output,
        xp;

    }

    public static enum Slots {
        input,
        output;

    }
}

