/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openblocks.Config;
import openblocks.common.block.OpenBlock;
import openblocks.common.item.ItemPaintCan;
import openblocks.common.tileentity.TileEntityPaintCan;
import openmods.block.OpenBlock;

public class BlockPaintCan
extends OpenBlock {
    public int renderPass = 0;

    public BlockPaintCan() {
        super(Config.blockPaintCanId, Material.field_76246_e);
        this.func_71848_c(0.0f);
        this.setRotationMode(OpenBlock.BlockRotationMode.FOUR_DIRECTIONS);
        this.setPlacementMode(OpenBlock.BlockPlacementMode.ENTITY_ANGLE);
        this.func_71905_a(0.25f, 0.0f, 0.25f, 0.7f, 0.6875f, 0.75f);
    }

    protected void getCustomTileEntityDrops(TileEntity te, List<ItemStack> result) {
        if (te instanceof TileEntityPaintCan) {
            TileEntityPaintCan can = (TileEntityPaintCan)te;
            result.add(ItemPaintCan.createStack(can.getColor(), can.getAmount()));
        }
    }

    protected boolean hasNormalDrops() {
        return false;
    }

    private static ItemStack createStackForBlock(World world, int x, int y, int z) {
        TileEntityPaintCan tile = (TileEntityPaintCan)((Object)BlockPaintCan.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityPaintCan.class));
        if (tile == null) {
            return null;
        }
        return ItemPaintCan.createStack(tile.getColor(), tile.getAmount());
    }

    public void func_94332_a(IconRegister register) {
        Icons.back = register.func_94245_a("openblocks:paintcan_side");
        Icons.front = register.func_94245_a("openblocks:paintcan_front");
        Icons.left = register.func_94245_a("openblocks:paintcan_left");
        Icons.right = register.func_94245_a("openblocks:paintcan_right");
        Icons.top = register.func_94245_a("openblocks:paintcan_top");
        Icons.bottom = register.func_94245_a("openblocks:paintcan_bottom");
        this.setTexture(ForgeDirection.EAST, Icons.right);
        this.setTexture(ForgeDirection.WEST, Icons.left);
        this.setTexture(ForgeDirection.NORTH, Icons.back);
        this.setTexture(ForgeDirection.SOUTH, Icons.front);
        this.setTexture(ForgeDirection.UP, Icons.top);
        this.setTexture(ForgeDirection.DOWN, Icons.bottom);
        this.setDefaultTexture(Icons.back);
    }

    public boolean shouldRenderBlock() {
        return true;
    }

    public boolean func_71877_c(IBlockAccess world, int x, int y, int z, int side) {
        if (this.renderPass == 0 && side == 1) {
            return false;
        }
        if (this.renderPass == 1 && side != 1) {
            return false;
        }
        return super.func_71877_c(world, x, y, z, side);
    }

    public boolean func_71926_d() {
        return false;
    }

    public int func_71920_b(IBlockAccess world, int x, int y, int z) {
        if (this.renderPass == 0) {
            return 0xFFFFFF;
        }
        TileEntityPaintCan tile = (TileEntityPaintCan)((Object)BlockPaintCan.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityPaintCan.class));
        if (tile != null) {
            return tile.getColor();
        }
        return 0xFFFFFF;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return BlockPaintCan.createStackForBlock(world, x, y, z);
    }

    public static class Icons {
        public static Icon top;
        public static Icon back;
        public static Icon left;
        public static Icon right;
        public static Icon front;
        public static Icon bottom;
    }
}

