/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.FakePlayer;
import net.minecraftforge.event.ASMEventHandler;
import net.minecraftforge.event.EventPriority;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.IEventListener;
import net.minecraftforge.event.ListenerList;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import openblocks.Config;
import openblocks.common.tileentity.TileEntityGrave;
import openmods.GenericInventory;
import openmods.Log;
import openmods.utils.InventoryUtils;

public class PlayerDeathHandler {
    @ForgeSubscribe(priority=EventPriority.LOW)
    public void onPlayerDrops(PlayerDropsEvent event) {
        if (Config.blockGraveId == 0) {
            return;
        }
        ArrayList drops = event.drops;
        if (drops.isEmpty()) {
            return;
        }
        EntityLivingBase entity = event.entityLiving;
        if (!(entity instanceof EntityPlayer) || entity instanceof FakePlayer) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        World world = player.field_70170_p;
        if (world.field_72995_K || world.func_82736_K().func_82766_b("keepInventory")) {
            return;
        }
        int x = MathHelper.func_76128_c((double)player.field_70165_t);
        int y = MathHelper.func_76128_c((double)player.field_70163_u);
        int z = MathHelper.func_76128_c((double)player.field_70161_v);
        for (int distance = 0; distance < 5; ++distance) {
            for (int checkX = x - distance; checkX <= x + distance; ++checkX) {
                for (int checkY = y - distance; checkY <= y + distance; ++checkY) {
                    for (int checkZ = z - distance; checkZ <= z + distance; ++checkZ) {
                        if (!PlayerDeathHandler.tryPlaceGrave(world, checkX, checkY, checkZ, player, drops)) continue;
                        Log.fine((String)"Placing grave for player '%s' @ (%d,%d,%d) with %d items", (Object[])new Object[]{player.field_71092_bJ, checkX, checkY, checkZ, drops.size()});
                        if (Config.debugGraves) {
                            PlayerDeathHandler.dumpDebugInfo(event);
                        }
                        drops.clear();
                        event.setCanceled(true);
                        return;
                    }
                }
            }
        }
    }

    private static void dumpDebugInfo(PlayerDropsEvent event) {
        int i = 0;
        for (EntityItem e : event.drops) {
            Log.fine((String)"\tGrave drop %d: %s -> %s", (Object[])new Object[]{i++, e.getClass(), e.func_92059_d()});
        }
        ListenerList listeners = event.getListenerList();
        try {
            int busId = 0;
            while (true) {
                Log.fine((String)"Dumping event %s listeners on bus %d", (Object[])new Object[]{event.getClass(), busId});
                for (IEventListener listener : listeners.getListeners(busId)) {
                    if (listener instanceof ASMEventHandler) {
                        try {
                            Object o = ReflectionHelper.getPrivateValue(ASMEventHandler.class, (Object)((ASMEventHandler)listener), (String[])new String[]{"handler"});
                            Log.fine((String)"\t%s", (Object[])new Object[]{o.getClass()});
                            continue;
                        }
                        catch (Throwable e) {
                            Log.log((Level)Level.FINE, (Throwable)e, (String)"Exception while getting field", (Object[])new Object[0]);
                        }
                    }
                    Log.fine((String)"\t%s", (Object[])new Object[]{listener.getClass()});
                }
                ++busId;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    private static boolean tryPlaceGrave(World world, int x, int y, int z, EntityPlayer stiff, List<EntityItem> drops) {
        if (!PlayerDeathHandler.canPlaceGrave(world, x, y, z)) {
            return false;
        }
        world.func_72832_d(x, y, z, Config.blockGraveId, 0, 2);
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile == null || !(tile instanceof TileEntityGrave)) {
            return false;
        }
        TileEntityGrave grave = (TileEntityGrave)tile;
        GenericInventory invent = new GenericInventory("tmpplayer", false, drops.size());
        for (EntityItem entityItem : drops) {
            ItemStack stack = entityItem.func_92059_d();
            if (stack == null) continue;
            InventoryUtils.insertItemIntoInventory((IInventory)invent, (ItemStack)stack.func_77946_l());
        }
        grave.setUsername(stiff.field_71092_bJ);
        grave.setLoot((IInventory)invent);
        return true;
    }

    private static boolean canPlaceGrave(World world, int x, int y, int z) {
        if (!world.func_72899_e(x, y, z)) {
            return false;
        }
        int blockId = world.func_72798_a(x, y, z);
        Block block = Block.field_71973_m[blockId];
        if (block == null) {
            return true;
        }
        return block.isAirBlock(world, x, y, z) || block.isBlockReplaceable(world, x, y, z);
    }
}

