/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import openblocks.Config;
import openblocks.OpenBlocks;
import openblocks.common.tileentity.TileEntityImaginary;
import org.lwjgl.opengl.GL11;

public class TileEntityImaginaryRenderer
extends TileEntitySpecialRenderer {
    private static final ElementDisplay blockDisplay = new ElementDisplay(){

        @Override
        public void addQuads(Tessellator tes, Icon icon) {
            double delta0 = 0.001;
            double delta1 = 0.999;
            tes.func_78374_a(0.0, 0.0, 0.001, (double)icon.func_94209_e(), (double)icon.func_94206_g());
            tes.func_78374_a(0.0, 1.0, 0.001, (double)icon.func_94209_e(), (double)icon.func_94210_h());
            tes.func_78374_a(1.0, 1.0, 0.001, (double)icon.func_94212_f(), (double)icon.func_94210_h());
            tes.func_78374_a(1.0, 0.0, 0.001, (double)icon.func_94212_f(), (double)icon.func_94206_g());
            tes.func_78374_a(0.0, 0.0, 0.999, (double)icon.func_94209_e(), (double)icon.func_94206_g());
            tes.func_78374_a(1.0, 0.0, 0.999, (double)icon.func_94209_e(), (double)icon.func_94210_h());
            tes.func_78374_a(1.0, 1.0, 0.999, (double)icon.func_94212_f(), (double)icon.func_94210_h());
            tes.func_78374_a(0.0, 1.0, 0.999, (double)icon.func_94212_f(), (double)icon.func_94206_g());
            tes.func_78374_a(0.999, 0.0, 0.0, (double)icon.func_94209_e(), (double)icon.func_94206_g());
            tes.func_78374_a(0.999, 1.0, 0.0, (double)icon.func_94209_e(), (double)icon.func_94210_h());
            tes.func_78374_a(0.999, 1.0, 1.0, (double)icon.func_94212_f(), (double)icon.func_94210_h());
            tes.func_78374_a(0.999, 0.0, 1.0, (double)icon.func_94212_f(), (double)icon.func_94206_g());
            tes.func_78374_a(0.001, 0.0, 0.0, (double)icon.func_94209_e(), (double)icon.func_94206_g());
            tes.func_78374_a(0.001, 0.0, 1.0, (double)icon.func_94209_e(), (double)icon.func_94210_h());
            tes.func_78374_a(0.001, 1.0, 1.0, (double)icon.func_94212_f(), (double)icon.func_94210_h());
            tes.func_78374_a(0.001, 1.0, 0.0, (double)icon.func_94212_f(), (double)icon.func_94206_g());
            tes.func_78374_a(0.0, 0.999, 0.0, (double)icon.func_94209_e(), (double)icon.func_94206_g());
            tes.func_78374_a(0.0, 0.999, 1.0, (double)icon.func_94209_e(), (double)icon.func_94210_h());
            tes.func_78374_a(1.0, 0.999, 1.0, (double)icon.func_94212_f(), (double)icon.func_94210_h());
            tes.func_78374_a(1.0, 0.999, 0.0, (double)icon.func_94212_f(), (double)icon.func_94206_g());
            tes.func_78374_a(0.0, 0.001, 0.0, (double)icon.func_94209_e(), (double)icon.func_94206_g());
            tes.func_78374_a(1.0, 0.001, 0.0, (double)icon.func_94209_e(), (double)icon.func_94210_h());
            tes.func_78374_a(1.0, 0.001, 1.0, (double)icon.func_94212_f(), (double)icon.func_94210_h());
            tes.func_78374_a(0.0, 0.001, 1.0, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        }

        @Override
        protected Icon getPencilTexture() {
            return OpenBlocks.Blocks.imaginary.texturePencilBlock;
        }

        @Override
        protected Icon getCrayonTexture() {
            return OpenBlocks.Blocks.imaginary.textureCrayonBlock;
        }
    };
    private static final ElementDisplay panelDisplay = new ElementDisplay(){

        @Override
        public void addQuads(Tessellator tes, Icon icon) {
            tes.func_78374_a(0.0, 0.0, 0.0, (double)icon.func_94209_e(), (double)icon.func_94206_g());
            tes.func_78374_a(0.0, 0.0, 1.0, (double)icon.func_94209_e(), (double)icon.func_94210_h());
            tes.func_78374_a(1.0, 0.0, 1.0, (double)icon.func_94212_f(), (double)icon.func_94210_h());
            tes.func_78374_a(1.0, 0.0, 0.0, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        }

        @Override
        protected Icon getPencilTexture() {
            return OpenBlocks.Blocks.imaginary.texturePencilPanel;
        }

        @Override
        protected Icon getCrayonTexture() {
            return OpenBlocks.Blocks.imaginary.textureCrayonPanel;
        }
    };
    private static final ElementDisplay halfPanelDisplay = new ElementDisplay(){

        @Override
        public void addQuads(Tessellator tes, Icon icon) {
            tes.func_78374_a(-0.5, 0.0, -0.5, (double)icon.func_94209_e(), (double)icon.func_94210_h());
            tes.func_78374_a(-0.5, 0.0, 0.5, (double)icon.func_94209_e(), (double)icon.func_94206_g());
            tes.func_78374_a(0.5, 0.0, 0.5, (double)icon.func_94212_f(), (double)icon.func_94206_g());
            tes.func_78374_a(0.5, 0.0, -0.5, (double)icon.func_94212_f(), (double)icon.func_94210_h());
        }

        @Override
        protected Icon getPencilTexture() {
            return OpenBlocks.Blocks.imaginary.texturePencilHalfPanel;
        }

        @Override
        protected Icon getCrayonTexture() {
            return OpenBlocks.Blocks.imaginary.textureCrayonHalfPanel;
        }
    };

    public TileEntityImaginaryRenderer() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void func_76894_a(TileEntity tileentity, double x, double y, double z, float partialTicks) {
        int displayList;
        TileEntityImaginary te = (TileEntityImaginary)tileentity;
        boolean isVisible = te.is(TileEntityImaginary.Property.VISIBLE);
        if (isVisible && te.visibility < 1.0f) {
            te.visibility = Math.min(te.visibility + Config.imaginaryFadingSpeed, 1.0f);
        } else if (!isVisible && te.visibility > 0.0f) {
            te.visibility = Math.max(te.visibility - Config.imaginaryFadingSpeed, 0.0f);
        }
        if (te.visibility <= 0.0f) {
            return;
        }
        this.func_110628_a(TextureMap.field_110575_b);
        if (!te.isPencil()) {
            byte red = (byte)(te.color >> 16);
            byte green = (byte)(te.color >> 8);
            byte blue = (byte)(te.color >> 0);
            GL11.glColor4ub((byte)red, (byte)green, (byte)blue, (byte)((byte)(255.0f * te.visibility)));
        } else {
            GL11.glColor4ub((byte)-1, (byte)-1, (byte)-1, (byte)((byte)(255.0f * te.visibility)));
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        TileEntityImaginary.ICollisionData data = te.collisionData;
        if (data instanceof TileEntityImaginary.PanelData) {
            TileEntityImaginary.PanelData pd = (TileEntityImaginary.PanelData)data;
            GL11.glTranslated((double)0.0, (double)pd.height, (double)0.0);
            displayList = panelDisplay.getDisplayList(te.isPencil());
            GL11.glCallList((int)displayList);
        } else if (data instanceof TileEntityImaginary.StairsData) {
            TileEntityImaginary.StairsData sd = (TileEntityImaginary.StairsData)data;
            GL11.glTranslated((double)0.5, (double)0.0, (double)0.5);
            switch (sd.orientation) {
                case NORTH: {
                    break;
                }
                case EAST: {
                    GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case SOUTH: {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case WEST: {
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
            }
            displayList = halfPanelDisplay.getDisplayList(te.isPencil());
            GL11.glTranslated((double)0.0, (double)sd.lowerPanelHeight, (double)0.0);
            GL11.glCallList((int)displayList);
            GL11.glTranslated((double)0.0, (double)(sd.upperPanelHeight - sd.lowerPanelHeight), (double)-0.5);
            GL11.glCallList((int)displayList);
        } else {
            int displayList2 = blockDisplay.getDisplayList(te.isPencil());
            GL11.glCallList((int)displayList2);
        }
        GL11.glPopMatrix();
    }

    @ForgeSubscribe
    public void onTextureReload(TextureStitchEvent.Pre evt) {
        TileEntityImaginaryRenderer.blockDisplay.clear();
        TileEntityImaginaryRenderer.panelDisplay.clear();
        TileEntityImaginaryRenderer.halfPanelDisplay.clear();
    }

    private static abstract class ElementDisplay {
        public Integer pencilDisplayList;
        public Integer crayonDisplayList;

        private ElementDisplay() {
        }

        public void finalize() {
            this.clear();
        }

        private void clear() {
            if (this.crayonDisplayList != null) {
                GL11.glDeleteLists((int)this.crayonDisplayList, (int)1);
                this.crayonDisplayList = null;
            }
            if (this.pencilDisplayList != null) {
                GL11.glDeleteLists((int)this.pencilDisplayList, (int)1);
                this.pencilDisplayList = null;
            }
        }

        public Integer getDisplayList(boolean isPencil) {
            return isPencil ? this.getPencilDisplayList() : this.getCrayonDisplayList();
        }

        private Integer getCrayonDisplayList() {
            if (this.crayonDisplayList == null) {
                this.crayonDisplayList = this.compileList(this.getCrayonTexture());
            }
            return this.crayonDisplayList;
        }

        private Integer getPencilDisplayList() {
            if (this.pencilDisplayList == null) {
                this.pencilDisplayList = this.compileList(this.getPencilTexture());
            }
            return this.pencilDisplayList;
        }

        private int compileList(Icon icon) {
            int displayList = GL11.glGenLists((int)1);
            GL11.glNewList((int)displayList, (int)4864);
            GL11.glAlphaFunc((int)516, (float)0.0f);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2884);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            Tessellator tes = new Tessellator();
            tes.func_78382_b();
            this.addQuads(tes, icon);
            tes.func_78381_a();
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2884);
            GL11.glDisable((int)3042);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glEndList();
            return displayList;
        }

        protected abstract void addQuads(Tessellator var1, Icon var2);

        protected abstract Icon getPencilTexture();

        protected abstract Icon getCrayonTexture();
    }
}

