/*
 * Decompiled with CFR 0.152.
 */
package myrathi.flatsigns.event;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import myrathi.flatsigns.FlatSigns;
import myrathi.flatsigns.item.ItemSpongeWipe;
import myrathi.flatsigns.tileentity.TileEntityFlatSign;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet15Place;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class EventHandlers {
    public static ArrayList<Integer> _sponges = null;
    private static ItemStack yellowWool = new ItemStack(Block.field_72101_ab, 1, 4);

    @ForgeSubscribe
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        ItemStack item = event.entityPlayer.func_70694_bm();
        if (item == null) {
            return;
        }
        if (_sponges == null) {
            _sponges = new ArrayList<Integer>(Arrays.asList(Block.field_71945_L.field_71990_ca, FlatSigns.itemSpongeWipe.field_77779_bT));
        }
        if (item.func_77973_b().field_77779_bT == Item.field_77792_au.field_77779_bT) {
            this.onPlayerInteract_Sign(event);
        } else if (_sponges.contains(item.func_77973_b().field_77779_bT) && !event.entityPlayer.func_70093_af()) {
            this.onPlayerInteract_Sponge(event);
        }
    }

    private void onPlayerInteract_Sign(PlayerInteractEvent event) {
        if (event.face != ForgeDirection.UP.ordinal() && event.face != ForgeDirection.DOWN.ordinal()) {
            return;
        }
        if (event.face == ForgeDirection.UP.ordinal() && !event.entityPlayer.func_70093_af()) {
            return;
        }
        World world = event.entityPlayer.field_70170_p;
        ForgeDirection dir = ForgeDirection.getOrientation((int)event.face);
        int x = event.x;
        int y = event.y;
        int z = event.z;
        ItemStack item = event.entityPlayer.func_70694_bm();
        if (!event.entityPlayer.func_82247_a(x, y, z, event.face, item)) {
            event.setCanceled(true);
            return;
        }
        if (world.func_72798_a(x, y, z) == 0 || !world.func_72803_f(x, y, z).func_76220_a()) {
            event.setCanceled(true);
            return;
        }
        if (!FlatSigns.blockFlatSign.func_71930_b(world, x += dir.offsetX, y += dir.offsetY, z += dir.offsetZ)) {
            event.setCanceled(true);
            return;
        }
        int meta = MathHelper.func_76128_c((double)((event.entityPlayer.field_70177_z + 360.0f + 45.0f) / 90.0f)) % 4;
        world.func_72832_d(x, y, z, FlatSigns.blockFlatSign.field_71990_ca, dir.getOpposite().ordinal() + (meta << 1), 2);
        if (!event.entityPlayer.field_71075_bZ.field_75098_d) {
            --item.field_77994_a;
        }
        TileEntityFlatSign tefs = (TileEntityFlatSign)world.func_72796_p(x, y, z);
        tefs.func_142010_a(event.entityPlayer);
        if (tefs != null && world.field_72995_K) {
            FlatSigns._proxy.displayGuiScreen(tefs);
        }
        event.entityPlayer.func_71064_a(StatList.field_75929_E[item.field_77993_c], 1);
        event.setCanceled(!world.field_72995_K);
    }

    private void onPlayerInteract_Sponge(PlayerInteractEvent event) {
        World world = event.entityPlayer.field_70170_p;
        int x = event.x;
        int y = event.y;
        int z = event.z;
        ForgeDirection dir = ForgeDirection.getOrientation((int)event.face);
        ItemStack item = event.entityPlayer.func_70694_bm();
        if (!event.entityPlayer.func_82247_a(x, y, z, event.face, item)) {
            event.setCanceled(true);
            return;
        }
        TileEntity te = world.func_72796_p(x, y, z);
        if (te == null || !(te instanceof TileEntityFlatSign) && !(te instanceof TileEntitySign)) {
            return;
        }
        if (!event.entityPlayer.field_71075_bZ.field_75098_d) {
            if (item.field_77993_c == Block.field_71945_L.field_71990_ca) {
                --item.field_77994_a;
            } else {
                ItemSpongeWipe.damageItem(item, (EntityLivingBase)event.entityPlayer);
            }
        }
        ReflectionHelper.setPrivateValue(TileEntitySign.class, (Object)((TileEntitySign)te), (Object)event.entityPlayer, (String[])new String[]{"field_142011_d", "field_142011_d", "d"});
        ReflectionHelper.setPrivateValue(TileEntitySign.class, (Object)((TileEntitySign)te), (Object)true, (String[])new String[]{"isEditable", "field_70411_c", "c"});
        event.setCanceled(true);
        if (world.field_72995_K) {
            event.entityPlayer.func_71038_i();
            PacketDispatcher.sendPacketToServer((Packet)new Packet15Place(x, y, z, event.face, item, 0.5f, 0.5f, 0.5f));
            if (te instanceof TileEntityFlatSign) {
                FlatSigns._proxy.displayGuiScreen((TileEntityFlatSign)te);
            } else if (te instanceof TileEntitySign) {
                event.entityPlayer.func_71014_a((TileEntity)((TileEntitySign)te));
            }
            return;
        }
    }

    @ForgeSubscribe
    public void onItemTossed(ItemTossEvent event) {
        if (event.entityItem.func_92059_d().func_77969_a(yellowWool)) {
            ItemTossHandler.trackEntityItem(event.entityItem);
        }
    }

    public static class ItemTossHandler
    implements IScheduledTickHandler {
        private static List<EntityItem> _entityItems = Lists.newArrayList();

        public static void trackEntityItem(EntityItem entityItem) {
            if (_entityItems.contains(entityItem)) {
                return;
            }
            _entityItems.add(entityItem);
        }

        public String getLabel() {
            return "FlatSigns:ItemTossHandler";
        }

        public void tickStart(EnumSet<TickType> type, Object ... tickData) {
            if (!type.contains(TickType.SERVER) || tickData.length != 0 || _entityItems.isEmpty()) {
                return;
            }
            Iterator<EntityItem> iter = _entityItems.iterator();
            while (iter.hasNext()) {
                EntityItem entity = iter.next();
                if (!entity.field_70175_ag) {
                    iter.remove();
                    continue;
                }
                if (entity.field_70128_L) {
                    iter.remove();
                    continue;
                }
                if (!entity.func_70026_G() && !entity.func_70055_a(Material.field_76244_g)) continue;
                iter.remove();
                int stackSize = entity.func_92059_d().field_77994_a;
                entity.func_92058_a(new ItemStack(Block.field_71945_L, stackSize));
            }
        }

        public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
        }

        public int nextTickSpacing() {
            return 20;
        }

        public EnumSet<TickType> ticks() {
            return EnumSet.of(TickType.SERVER);
        }
    }
}

