/*
 * Decompiled with CFR 0.152.
 */
package myrathi.flatsigns;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.util.logging.Level;
import myrathi.flatsigns.block.BlockFlatSign;
import myrathi.flatsigns.event.EventHandlers;
import myrathi.flatsigns.item.ItemSpongeWipe;
import myrathi.flatsigns.proxy.CommonProxy;
import myrathi.flatsigns.tileentity.TileEntityFlatSign;
import myrathi.flatsigns.util.Log;
import myrathi.flatsigns.util.Version;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Property;

@Mod(modid="flatsigns", name="Flat Signs", useMetadata=true, version="1.4.0", certificateFingerprint="65033d4207afbf3673ff5e1933990f1bd02807ae", dependencies="required-after:Forge@[9.10.0.790,);required-after:FML@[6.2.7,)")
@NetworkMod(clientSideRequired=true, serverSideRequired=true, versionBounds="[1.4,)")
public class FlatSigns {
    @Mod.Instance(value="flatsigns")
    private static FlatSigns _instance;
    @SidedProxy(clientSide="myrathi.flatsigns.proxy.ClientProxy", serverSide="myrathi.flatsigns.proxy.CommonProxy")
    public static CommonProxy _proxy;
    public static final Log log;
    public static BlockFlatSign blockFlatSign;
    public static ItemSpongeWipe itemSpongeWipe;

    public static FlatSigns instance() {
        return _instance;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        Version.init(evt.getVersionProperties());
        evt.getModMetadata().version = Version.version();
        this.readConfigurationFile(evt.getSuggestedConfigurationFile());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlers());
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent evt) {
        GameRegistry.registerTileEntity(TileEntityFlatSign.class, (String)"Sign.Flat");
        _proxy.registerRenderInformation();
        _proxy.registerTickHandler();
        itemSpongeWipe.registerRecipes();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readConfigurationFile(File fileSuggested) {
        String cfgPath;
        Configuration cfg = new Configuration(fileSuggested);
        try {
            cfg.load();
            Property prop = cfg.getBlock("flatSignID", 3391, "Block ID for flat signs");
            blockFlatSign = new BlockFlatSign(prop.getInt(3391));
            prop = cfg.getItem("spongeWipe", 14391, "Item ID for sponge wipes");
            itemSpongeWipe = new ItemSpongeWipe(prop.getInt(14391));
        }
        catch (Exception e) {
            try {
                log.log(Level.SEVERE, e, "Unable to load configuration file!", new Object[0]);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                String cfgPath2;
                try {
                    cfgPath2 = fileSuggested.getCanonicalPath();
                }
                catch (Exception e2) {
                    cfgPath2 = fileSuggested.getAbsolutePath();
                }
                log.info("Config loaded from: %s", cfgPath2);
                if (!cfg.hasChanged()) throw throwable;
                cfg.save();
                throw throwable;
            }
        }
        try {
            cfgPath = fileSuggested.getCanonicalPath();
        }
        catch (Exception e) {
            cfgPath = fileSuggested.getAbsolutePath();
        }
        log.info("Config loaded from: %s", cfgPath);
        if (!cfg.hasChanged()) return;
        cfg.save();
    }

    static {
        log = new Log("Flat Signs");
    }
}

