/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.modifiers;

import iguanaman.iguanatweakstconstruct.IguanaConfig;
import iguanaman.iguanatweakstconstruct.IguanaLevelingLogic;
import iguanaman.iguanatweakstconstruct.IguanaTweaksTConstruct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.common.BowRecipe;
import tconstruct.common.TContent;
import tconstruct.items.tools.Hammer;
import tconstruct.items.tools.Pickaxe;
import tconstruct.items.tools.Shortbow;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.crafting.ToolRecipe;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.tools.ToolMaterial;
import tconstruct.library.tools.ToolMod;

public class IguanaModUpgrade
extends ToolMod {
    public IguanaModUpgrade() {
        super(new ItemStack[0], 0, "");
    }

    public boolean matches(ItemStack[] input, ItemStack tool) {
        return this.canModify(tool, input);
    }

    protected ToolRecipe GetRecipe(ToolCore tool) {
        if (tool instanceof Shortbow) {
            return new BowRecipe(TContent.toolRod, TContent.bowstring, TContent.toolRod, TContent.shortbow);
        }
        return (ToolRecipe)ToolBuilder.instance.recipeList.get(tool.getToolName());
    }

    protected boolean canModify(ItemStack tool, ItemStack[] input) {
        String extraAbility;
        String accessoryAbility;
        if (tool == null || tool.func_77973_b() == null || !(tool.func_77973_b() instanceof ToolCore)) {
            return false;
        }
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        if (tags.func_74762_e("Damage") > 0) {
            return false;
        }
        ToolCore toolItem = (ToolCore)tool.func_77973_b();
        ToolRecipe toolRecipe = this.GetRecipe(toolItem);
        if (toolRecipe == null) {
            return false;
        }
        int oldHead = tags.func_74762_e("Head");
        int oldHandle = tags.func_74762_e("Handle");
        int oldAccessory = tags.func_74762_e("Accessory");
        int oldExtra = tags.func_74762_e("Extra");
        String headAbility = TConstructRegistry.getMaterial((int)tags.func_74762_e((String)"Head")).ability;
        boolean headWritable = headAbility.equals("Writable") || headAbility.equals("Thaumic");
        String handleAbility = TConstructRegistry.getMaterial((int)tags.func_74762_e((String)"Handle")).ability;
        boolean handleWritable = handleAbility.equals("Writable") || headAbility.equals("Thaumic");
        boolean accessoryWritable = false;
        if (tags.func_74764_b("Accessory") && ((accessoryAbility = TConstructRegistry.getMaterial((int)tags.func_74762_e((String)"Accessory")).ability).equals("Writable") || accessoryAbility.equals("Thaumic"))) {
            accessoryWritable = true;
        }
        boolean extraWritable = false;
        if (tags.func_74764_b("Extra") && ((extraAbility = TConstructRegistry.getMaterial((int)tags.func_74762_e((String)"Extra")).ability).equals("Writable") || extraAbility.equals("Thaumic"))) {
            extraWritable = true;
        }
        int modifiersNeeded = 0;
        ArrayList<String> replacing = new ArrayList<String>();
        for (ItemStack inputStack : input) {
            String ability;
            if (inputStack == null) continue;
            int partIndex = -1;
            if (!(toolRecipe.validHead(inputStack.func_77973_b()) || toolRecipe.validHandle(inputStack.func_77973_b()) || toolRecipe.validAccessory(inputStack.func_77973_b()) || toolRecipe.validExtra(inputStack.func_77973_b()))) {
                return false;
            }
            if (toolRecipe.validHead(inputStack.func_77973_b())) {
                boolean newHeadWritable;
                if (replacing.contains("Head") || inputStack.func_77960_j() == oldHead) {
                    return false;
                }
                ability = TConstructRegistry.getMaterial((int)inputStack.func_77960_j()).ability;
                boolean bl = newHeadWritable = ability.equals("Writable") || ability.equals("Thaumic");
                if (headWritable && !newHeadWritable) {
                    ++modifiersNeeded;
                }
                partIndex = IguanaTweaksTConstruct.toolParts.indexOf(toolItem.getHeadItem());
                replacing.add("Head");
            } else if (toolRecipe.validHandle(inputStack.func_77973_b())) {
                boolean newHandleWritable;
                if (replacing.contains("Handle") || inputStack.func_77960_j() == oldHandle) {
                    return false;
                }
                ability = TConstructRegistry.getMaterial((int)inputStack.func_77960_j()).ability;
                boolean bl = newHandleWritable = ability.equals("Writable") || ability.equals("Thaumic");
                if (handleWritable && !newHandleWritable) {
                    ++modifiersNeeded;
                }
                partIndex = IguanaTweaksTConstruct.toolParts.indexOf(toolItem.getHandleItem());
                replacing.add("Handle");
            } else if (toolRecipe.validAccessory(inputStack.func_77973_b())) {
                boolean newAccessoryWritable;
                if (replacing.contains("Accessory") || inputStack.func_77960_j() == oldAccessory) {
                    return false;
                }
                ability = TConstructRegistry.getMaterial((int)inputStack.func_77960_j()).ability;
                boolean bl = newAccessoryWritable = ability.equals("Writable") || ability.equals("Thaumic");
                if (accessoryWritable && !newAccessoryWritable) {
                    ++modifiersNeeded;
                }
                partIndex = IguanaTweaksTConstruct.toolParts.indexOf(toolItem.getAccessoryItem());
                replacing.add("Accessory");
            } else if (toolRecipe.validExtra(inputStack.func_77973_b())) {
                boolean newExtraWritable;
                if (replacing.contains("Extra") || inputStack.func_77960_j() == oldExtra) {
                    return false;
                }
                ability = TConstructRegistry.getMaterial((int)inputStack.func_77960_j()).ability;
                boolean bl = newExtraWritable = ability.equals("Writable") || ability.equals("Thaumic");
                if (extraWritable && !newExtraWritable) {
                    ++modifiersNeeded;
                }
                partIndex = IguanaTweaksTConstruct.toolParts.indexOf(toolItem.getExtraItem());
                replacing.add("Extra");
            }
            if (inputStack.func_77960_j() != 1 || IguanaConfig.allowStoneTools && !IguanaConfig.restrictedFlintParts.contains(partIndex + 1)) continue;
            return false;
        }
        return tags.func_74762_e("Modifiers") >= modifiersNeeded;
    }

    public void modify(ItemStack[] input, ItemStack tool) {
        String tip;
        int hLevel;
        long newXp;
        int newRequiredXp;
        float xpPercentage;
        long currentXp;
        int requiredXp;
        String extraAbility;
        String accessoryAbility;
        String headAbility;
        ToolCore toolClass = (ToolCore)tool.func_77973_b();
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        int oldHead = tags.func_74762_e("Head");
        int oldHandle = tags.func_74762_e("Handle");
        int oldAccessory = tags.func_74762_e("Accessory");
        int oldExtra = tags.func_74762_e("Extra");
        ItemStack headStack = new ItemStack(toolClass.getHeadItem(), 1, oldHead);
        ItemStack handleStack = new ItemStack(toolClass.getHandleItem(), 1, oldHandle);
        ItemStack accessoryStack = null;
        if (toolClass.getAccessoryItem() != null) {
            accessoryStack = new ItemStack(toolClass.getAccessoryItem(), 1, oldAccessory);
        }
        ItemStack extraStack = null;
        if (toolClass.getExtraItem() != null) {
            extraStack = new ItemStack(toolClass.getExtraItem(), 1, oldExtra);
        }
        boolean headWritable = (headAbility = TConstructRegistry.getMaterial((int)tags.func_74762_e((String)"Head")).ability).equals("Writable") || headAbility.equals("Thaumic");
        String handleAbility = TConstructRegistry.getMaterial((int)tags.func_74762_e((String)"Handle")).ability;
        boolean handleWritable = handleAbility.equals("Writable") || headAbility.equals("Thaumic");
        boolean accessoryWritable = false;
        if (tags.func_74764_b("Accessory") && ((accessoryAbility = TConstructRegistry.getMaterial((int)tags.func_74762_e((String)"Accessory")).ability).equals("Writable") || accessoryAbility.equals("Thaumic"))) {
            accessoryWritable = true;
        }
        boolean extraWritable = false;
        if (tags.func_74764_b("Extra") && ((extraAbility = TConstructRegistry.getMaterial((int)tags.func_74762_e((String)"Extra")).ability).equals("Writable") || extraAbility.equals("Thaumic"))) {
            extraWritable = true;
        }
        int modifiersDifference = 0;
        ToolRecipe toolRecipe = this.GetRecipe((ToolCore)tool.func_77973_b());
        ArrayList<String> replacing = new ArrayList<String>();
        for (ItemStack inputStack : input) {
            boolean newExtraWritable;
            String ability;
            if (inputStack == null) continue;
            if (toolRecipe.validHead(inputStack.func_77973_b()) && !replacing.contains("Head")) {
                boolean newHeadWritable;
                ability = TConstructRegistry.getMaterial((int)inputStack.func_77960_j()).ability;
                boolean bl = newHeadWritable = ability.equals("Writable") || ability.equals("Thaumic");
                if (headWritable && !newHeadWritable) {
                    --modifiersDifference;
                } else if (!headWritable && newHeadWritable) {
                    ++modifiersDifference;
                }
                headStack = inputStack;
                replacing.add("Head");
                continue;
            }
            if (toolRecipe.validHandle(inputStack.func_77973_b()) && !replacing.contains("Handle")) {
                boolean newHandleWritable;
                ability = TConstructRegistry.getMaterial((int)inputStack.func_77960_j()).ability;
                boolean bl = newHandleWritable = ability.equals("Writable") || ability.equals("Thaumic");
                if (handleWritable && !newHandleWritable) {
                    --modifiersDifference;
                } else if (!handleWritable && newHandleWritable) {
                    ++modifiersDifference;
                }
                handleStack = inputStack;
                replacing.add("Handle");
                continue;
            }
            if (toolRecipe.validAccessory(inputStack.func_77973_b()) && !replacing.contains("Accessory")) {
                boolean newAccessoryWritable;
                ability = TConstructRegistry.getMaterial((int)inputStack.func_77960_j()).ability;
                boolean bl = newAccessoryWritable = ability.equals("Writable") || ability.equals("Thaumic");
                if (accessoryWritable && !newAccessoryWritable) {
                    --modifiersDifference;
                } else if (!accessoryWritable && newAccessoryWritable) {
                    ++modifiersDifference;
                }
                accessoryStack = inputStack;
                replacing.add("Accessory");
                continue;
            }
            if (!toolRecipe.validExtra(inputStack.func_77973_b()) || replacing.contains("Extra")) continue;
            ability = TConstructRegistry.getMaterial((int)inputStack.func_77960_j()).ability;
            boolean bl = newExtraWritable = ability.equals("Writable") || ability.equals("Thaumic");
            if (extraWritable && !newExtraWritable) {
                --modifiersDifference;
            } else if (!extraWritable && newExtraWritable) {
                ++modifiersDifference;
            }
            extraStack = inputStack;
            replacing.add("Extra");
        }
        ItemStack newTool = ToolBuilder.instance.buildTool(headStack, handleStack, accessoryStack, extraStack, "");
        NBTTagCompound newTags = newTool.func_77978_p().func_74775_l("InfiTool");
        int base = newTags.func_74762_e("BaseDurability");
        int bonus = tags.func_74762_e("BonusDurability");
        float modDur = tags.func_74760_g("ModDurability");
        int total = Math.max((int)((float)(base + bonus) * (modDur + 1.0f)), 1);
        tags.func_74768_a("BaseDurability", base);
        tags.func_74768_a("TotalDurability", total);
        if (tags.func_74764_b("ToolEXP")) {
            requiredXp = IguanaLevelingLogic.getRequiredXp(tool, tags);
            currentXp = tags.func_74763_f("ToolEXP");
            xpPercentage = (float)currentXp / (float)requiredXp;
            newRequiredXp = IguanaLevelingLogic.getRequiredXp(newTool, newTags);
            newXp = Math.round((float)newRequiredXp * xpPercentage);
            tags.func_74772_a("ToolEXP", newXp);
        }
        if (tags.func_74764_b("HeadEXP")) {
            requiredXp = IguanaLevelingLogic.getRequiredXp(tool, tags, true);
            currentXp = tags.func_74763_f("HeadEXP");
            xpPercentage = (float)currentXp / (float)requiredXp;
            newRequiredXp = IguanaLevelingLogic.getRequiredXp(newTool, newTags, true);
            newXp = Math.round((float)newRequiredXp * xpPercentage);
            tags.func_74772_a("HeadEXP", newXp);
        }
        boolean requiresBoost = false;
        if (tags.func_74764_b("HarvestLevelModified")) {
            requiresBoost = true;
            tags.func_82580_o("HarvestLevelModified");
            if (tags.func_74764_b("MobHead")) {
                int i;
                tags.func_82580_o("MobHead");
                List<Integer> badEffects = Arrays.asList(0, 20, 21, 22, 23, 24, 25);
                ArrayList<Integer> effects = new ArrayList<Integer>();
                for (i = 1; i <= 6; ++i) {
                    if (!tags.func_74764_b("Effect" + i)) continue;
                    int effectInt = tags.func_74762_e("Effect" + i);
                    if (!badEffects.contains(effectInt)) {
                        effects.add(effectInt);
                    }
                    tags.func_82580_o("Effect" + i);
                }
                for (i = 0; i < effects.size(); ++i) {
                    tags.func_74768_a("Effect" + Integer.toString(i + 1), ((Integer)effects.get(i)).intValue());
                }
            }
        }
        if (newTags.func_74764_b("Shoddy")) {
            tags.func_74776_a("Shoddy", newTags.func_74760_g("Shoddy"));
        }
        int reinforced = tags.func_74762_e("Unbreaking");
        int reinforcedNew = newTags.func_74762_e("Unbreaking");
        ToolMaterial oldHeadMat = TConstructRegistry.getMaterial((int)oldHead);
        ToolMaterial oldHandleMat = TConstructRegistry.getMaterial((int)oldHandle);
        ToolMaterial oldAccessoryMat = TConstructRegistry.getMaterial((int)oldAccessory);
        ToolMaterial oldExtraMat = TConstructRegistry.getMaterial((int)oldExtra);
        int reinforcedDifference = reinforcedNew - this.buildReinforced(oldHeadMat, oldHandleMat, oldAccessoryMat, oldExtraMat);
        tags.func_74768_a("Unbreaking", reinforced + reinforcedDifference);
        if (newTags.func_74764_b("FlightSpeed")) {
            tags.func_74776_a("FlightSpeed", newTags.func_74760_g("FlightSpeed"));
        }
        ArrayList<String> replaceTags = new ArrayList<String>(Arrays.asList("HarvestLevel", "HarvestLevel2", "HarvestLevelHandle", "HarvestLevelExtra", "MiningSpeed", "MiningSpeed2", "MiningSpeedHandle", "MiningSpeedExtra", "DrawSpeed", "BaseDrawSpeed"));
        for (String replaced : replacing) {
            replaceTags.add(replaced);
            replaceTags.add("Render" + replaced);
        }
        for (String replaceTag : replaceTags) {
            if (!newTags.func_74764_b(replaceTag)) continue;
            tags.func_74768_a(replaceTag, newTags.func_74762_e(replaceTag));
        }
        if (tags.func_74764_b("ModAttack")) {
            int attackAmount = tags.func_74759_k("ModAttack")[0];
            int attackBonus = (int)((float)attackAmount / 30.0f);
            tags.func_74768_a("Attack", newTags.func_74762_e("Attack") + attackBonus);
        }
        if (tags.func_74764_b("Redstone")) {
            int speedAmount = tags.func_74759_k("Redstone")[0];
            int speedBoost = speedAmount * 8;
            tags.func_74768_a("MiningSpeed", newTags.func_74762_e("MiningSpeed") + speedBoost);
            if (tags.func_74764_b("MiningSpeed2")) {
                tags.func_74768_a("MiningSpeed2", newTags.func_74762_e("MiningSpeed2") + speedBoost);
            }
            if (tags.func_74764_b("DrawSpeed")) {
                int baseDrawSpeed = newTags.func_74762_e("BaseDrawSpeed");
                int drawSpeed = (int)((float)baseDrawSpeed - 0.1f * (float)baseDrawSpeed * ((float)speedAmount / 50.0f));
                tags.func_74768_a("DrawSpeed", drawSpeed);
            }
        }
        tags.func_74768_a("Modifiers", tags.func_74762_e("Modifiers") + modifiersDifference);
        List<String> unwantedModifiers = Arrays.asList("Skeleton Skull", "Zombie Head", "Creeper Head", "Enderman Head", "Wither Skeleton Skull", "Nether Star");
        for (String unwanted : unwantedModifiers) {
            if (!tags.func_74764_b(unwanted)) continue;
            tags.func_82580_o(unwanted);
        }
        ArrayList<String> tips = new ArrayList<String>();
        ArrayList<String> modifierTips = new ArrayList<String>();
        if (tool.func_77973_b() instanceof Pickaxe || tool.func_77973_b() instanceof Hammer) {
            String mLevel = IguanaTweaksTConstruct.getHarvestLevelName(tags.func_74762_e("HarvestLevel"));
            tips.add("Mining Level: " + mLevel);
            modifierTips.add("");
        }
        int level = tags.func_74762_e("ToolLevel");
        hLevel = tags.func_74764_b("HarvestLevel") ? (hLevel = tags.func_74762_e("HarvestLevel")) : -1;
        tips.add(IguanaLevelingLogic.getLevelTooltip(level));
        modifierTips.add("");
        if (IguanaConfig.showTooltipXP) {
            if (level <= 5) {
                tips.add(IguanaLevelingLogic.getXpString(tool, false, false));
                modifierTips.add("");
            }
            if (IguanaConfig.levelingPickaxeBoost) {
                if (hLevel >= TConstructRegistry.getMaterial((String)"Copper").harvestLevel() && hLevel < TConstructRegistry.getMaterial((String)"Manyullyn").harvestLevel() && !tags.func_74764_b("HarvestLevelModified") && (tool.func_77973_b() instanceof Pickaxe || tool.func_77973_b() instanceof Hammer)) {
                    tips.add(IguanaLevelingLogic.getXpString(tool, false, true));
                    modifierTips.add("");
                }
                if (requiresBoost) {
                    tips.add("\u00a76Requires boost");
                    modifierTips.add("");
                }
            }
        }
        int tipNum = 0;
        while (tags.func_74764_b(tip = "Tooltip" + ++tipNum)) {
            String tipString = tags.func_74779_i(tip);
            if (!(tipString.contains("Mining Level Boost") || tipString.contains("Boosted") || tipString.startsWith("Mining Level:") || tipString.startsWith("Skill Level:") || tipString.startsWith("XP:") || tipString.startsWith("Head XP:") || tipString.startsWith("Boost XP:") || tipString.contains("Requires boost"))) {
                tips.add(tipString);
                modifierTips.add(tags.func_74779_i("ModifierTip" + tipNum));
            }
            tags.func_82580_o(tip);
            tags.func_82580_o("ModifierTip" + tipNum);
        }
        for (int i = 1; i <= tips.size(); ++i) {
            if (tips.get(i - 1) == null) continue;
            tags.func_74778_a("Tooltip" + i, (String)tips.get(i - 1));
            if (modifierTips.get(i - 1) != null) {
                tags.func_74778_a("ModifierTip" + i, (String)modifierTips.get(i - 1));
                continue;
            }
            tags.func_74778_a("ModifierTip" + i, "");
        }
        String materialName = TConstructRegistry.getMaterial((int)oldHead).displayName;
        String toolName = ((ToolCore)tool.func_77973_b()).getToolName();
        if (tool.func_82833_r().endsWith(materialName + toolName)) {
            materialName = TConstructRegistry.getMaterial((int)tags.func_74762_e((String)"Head")).displayName;
            tool.func_82834_c("\u00a7r" + materialName + toolName);
        }
    }

    public void addMatchingEffect(ItemStack tool) {
    }

    int buildReinforced(ToolMaterial headMat, ToolMaterial handleMat, ToolMaterial accessoryMat, ToolMaterial extraMat) {
        int reinforced = 0;
        int dHead = headMat.reinforced();
        int dHandle = handleMat.reinforced();
        int dAccessory = 0;
        if (accessoryMat != null) {
            dAccessory = accessoryMat.reinforced();
        }
        int dExtra = 0;
        if (extraMat != null) {
            dExtra = extraMat.reinforced();
        }
        if (dHead > reinforced) {
            reinforced = dHead;
        }
        if (dHandle > reinforced) {
            reinforced = dHandle;
        }
        if (dAccessory > reinforced) {
            reinforced = dAccessory;
        }
        if (dExtra > reinforced) {
            reinforced = dExtra;
        }
        return reinforced;
    }
}

