/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import iguanaman.iguanatweakstconstruct.CommonProxy;
import iguanaman.iguanatweakstconstruct.HarvestLevelTweaks;
import iguanaman.iguanatweakstconstruct.IguanaBlocks;
import iguanaman.iguanatweakstconstruct.IguanaConfig;
import iguanaman.iguanatweakstconstruct.IguanaItems;
import iguanaman.iguanatweakstconstruct.IguanaLog;
import iguanaman.iguanatweakstconstruct.MaterialTweaks;
import iguanaman.iguanatweakstconstruct.ModifierTweaks;
import iguanaman.iguanatweakstconstruct.RemoveVanillaTools;
import iguanaman.iguanatweakstconstruct.VariousTweaks;
import iguanaman.iguanatweakstconstruct.commands.IguanaCommandLevelUpTool;
import iguanaman.iguanatweakstconstruct.commands.IguanaCommandToolXP;
import iguanaman.iguanatweakstconstruct.util.IguanaEventHandler;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import tconstruct.common.TContent;

@Mod(modid="IguanaTweaksTConstruct", name="Iguana Tweaks for Tinker's Construct", version="1.6.X-1p", dependencies="required-after:TConstruct;after:*")
@NetworkMod(clientSideRequired=true, serverSideRequired=true)
public class IguanaTweaksTConstruct {
    @Mod.Instance(value="IguanaTweaksTConstruct")
    public static IguanaTweaksTConstruct instance;
    @SidedProxy(clientSide="iguanaman.iguanatweakstconstruct.ClientProxy", serverSide="iguanaman.iguanatweakstconstruct.CommonProxy")
    public static CommonProxy proxy;
    public static Logger ITconTweaksLog;
    public static List<Item> toolParts;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.registerSounds();
        NetworkRegistry.instance().registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        IguanaConfig.init(event.getSuggestedConfigurationFile());
        toolParts = Arrays.asList(TContent.toolRod, TContent.pickaxeHead, TContent.shovelHead, TContent.hatchetHead, TContent.binding, TContent.toughBinding, TContent.toughRod, TContent.largePlate, TContent.swordBlade, TContent.wideGuard, TContent.handGuard, TContent.crossbar, TContent.knifeBlade, TContent.fullGuard, TContent.frypanHead, TContent.signHead, TContent.chiselHead, TContent.scytheBlade, TContent.broadAxeHead, TContent.excavatorHead, TContent.largeSwordBlade, TContent.hammerHead, TContent.bowstring, TContent.fletching, TContent.arrowhead);
        IguanaBlocks.init();
        IguanaItems.init();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.registerRenderers();
        MaterialTweaks.init();
        ModifierTweaks.init();
        VariousTweaks.init();
        RemoveVanillaTools.init();
        HarvestLevelTweaks.init();
        IguanaLog.log("Starting event handler");
        MinecraftForge.EVENT_BUS.register((Object)new IguanaEventHandler());
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        if (IguanaConfig.toolLeveling) {
            ICommandManager commandManager = FMLCommonHandler.instance().getMinecraftServerInstance().func_71187_D();
            ServerCommandManager serverCommandManager = (ServerCommandManager)commandManager;
            serverCommandManager.func_71560_a((ICommand)new IguanaCommandLevelUpTool());
            serverCommandManager.func_71560_a((ICommand)new IguanaCommandToolXP());
        }
    }

    public static String getHarvestLevelName(int num) {
        if (IguanaConfig.pickaxeBoostRequired && num > 1) {
            --num;
        }
        switch (num) {
            case 0: {
                return "\u00a77Stone";
            }
            case 1: {
                return "\u00a76Copper";
            }
            case 2: {
                return "\u00a74Iron";
            }
            case 3: {
                return "\u00a7fTin";
            }
            case 4: {
                return "\u00a7bDiamond";
            }
            case 5: {
                return "\u00a7cArdite";
            }
            case 6: {
                return "\u00a79Cobalt";
            }
            case 7: {
                return "\u00a75Manyullyn";
            }
        }
        return "\u00a7k\u00a7k\u00a7k\u00a7k\u00a7k\u00a7k";
    }

    static {
        ITconTweaksLog = Logger.getLogger("IguanaTweaksTConstruct");
        toolParts = null;
    }
}

