/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct;

import iguanaman.iguanatweakstconstruct.IguanaConfig;
import iguanaman.iguanatweakstconstruct.IguanaTweaksTConstruct;
import iguanaman.iguanatweakstconstruct.modifiers.IguanaModAttack;
import iguanaman.iguanatweakstconstruct.modifiers.IguanaModBlaze;
import iguanaman.iguanatweakstconstruct.modifiers.IguanaModLapis;
import iguanaman.iguanatweakstconstruct.modifiers.IguanaModPiston;
import iguanaman.iguanatweakstconstruct.modifiers.IguanaModRedstone;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import tconstruct.items.tools.Excavator;
import tconstruct.items.tools.Hammer;
import tconstruct.items.tools.Hatchet;
import tconstruct.items.tools.LumberAxe;
import tconstruct.items.tools.Mattock;
import tconstruct.items.tools.Pickaxe;
import tconstruct.items.tools.Scythe;
import tconstruct.items.tools.Shortbow;
import tconstruct.items.tools.Shovel;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.HarvestTool;
import tconstruct.library.tools.Weapon;
import tconstruct.modifiers.tools.ModAntiSpider;
import tconstruct.modifiers.tools.ModInteger;
import tconstruct.modifiers.tools.ModReinforced;
import tconstruct.modifiers.tools.ModSmite;

public class IguanaLevelingLogic {
    public static String getXpString(ItemStack tool, boolean debug) {
        return IguanaLevelingLogic.getXpString(tool, debug, null);
    }

    public static String getXpString(ItemStack tool, boolean debug, boolean pick) {
        return IguanaLevelingLogic.getXpString(tool, debug, null, pick);
    }

    public static String getXpString(ItemStack tool, boolean debug, NBTTagCompound tags) {
        return IguanaLevelingLogic.getXpString(tool, debug, tags, false);
    }

    public static String getXpString(ItemStack tool, boolean debug, NBTTagCompound tags, boolean pick) {
        String prefix;
        if (tags == null) {
            tags = tool.func_77978_p().func_74775_l("InfiTool");
        }
        int requiredXp = IguanaLevelingLogic.getRequiredXp(tool, tags, pick);
        long currentXp = pick ? tags.func_74763_f("HeadEXP") : tags.func_74763_f("ToolEXP");
        float xpPercentage = (float)currentXp / (float)requiredXp * 100.0f;
        String xpPercentageString = String.format("%.2f", Float.valueOf(xpPercentage)) + "%";
        String string = prefix = pick ? "Boost XP: " : "XP: ";
        if (IguanaConfig.detailedXpTooltip) {
            return prefix + Long.toString(currentXp) + " / " + Integer.toString(requiredXp) + " (" + xpPercentageString + ")";
        }
        return prefix + xpPercentageString;
    }

    public static String getLevelTooltip(int level) {
        switch (level) {
            case 1: {
                return "Skill Level: \u00a74Clumsy";
            }
            case 2: {
                return "Skill Level: \u00a76Comfortable";
            }
            case 3: {
                return "Skill Level: \u00a7eAccustomed";
            }
            case 4: {
                return "Skill Level: \u00a72Adept";
            }
            case 5: {
                return "Skill Level: \u00a73Expert";
            }
            case 6: {
                return "Skill Level: \u00a7dMaster";
            }
        }
        return null;
    }

    public static void updateXP(ItemStack tool, EntityPlayer player, long toolXP, long headXP) {
        String tip;
        int hLevel;
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        if (!tags.func_74764_b("ToolLevel")) {
            return;
        }
        int level = tags.func_74762_e("ToolLevel");
        hLevel = tags.func_74764_b("HarvestLevel") ? (hLevel = tags.func_74762_e("HarvestLevel")) : -1;
        boolean leveled = false;
        boolean pickLeveled = false;
        if (tags.func_74764_b("ToolEXP") && level >= 1 && level <= 5 && toolXP >= 0L) {
            tags.func_74772_a("ToolEXP", toolXP);
            if (toolXP >= (long)IguanaLevelingLogic.getRequiredXp(tool, tags)) {
                IguanaLevelingLogic.LevelUpTool(tool, player);
                leveled = true;
            }
        }
        if (IguanaConfig.levelingPickaxeBoost && tags.func_74764_b("HeadEXP") && !tags.func_74764_b("HarvestLevelModified") && hLevel >= TConstructRegistry.getMaterial((String)"Copper").harvestLevel() && (!IguanaConfig.pickaxeBoostRequired && hLevel < 6 || IguanaConfig.pickaxeBoostRequired && hLevel < 7)) {
            tags.func_74772_a("HeadEXP", headXP);
            if (headXP >= (long)IguanaLevelingLogic.getRequiredXp(tool, true)) {
                IguanaLevelingLogic.LevelUpPick(tool, player, leveled);
                pickLeveled = true;
            }
        }
        if ((leveled || pickLeveled) && !player.field_70170_p.field_72995_K) {
            player.field_70170_p.func_72956_a((Entity)player, "iguanatweakstconstruct:chime", 1.0f, 1.0f);
        }
        level = tags.func_74762_e("ToolLevel");
        if (tags.func_74764_b("HarvestLevel")) {
            hLevel = tags.func_74762_e("HarvestLevel");
        }
        ArrayList<String> tips = new ArrayList<String>();
        ArrayList<String> modifierTips = new ArrayList<String>();
        if (tool.func_77973_b() instanceof Pickaxe || tool.func_77973_b() instanceof Hammer) {
            tips.add("Mining Level: " + IguanaTweaksTConstruct.getHarvestLevelName(hLevel));
            modifierTips.add("");
        }
        tips.add(IguanaLevelingLogic.getLevelTooltip(level));
        modifierTips.add("");
        if (IguanaConfig.showTooltipXP) {
            if (level <= 5) {
                tips.add(IguanaLevelingLogic.getXpString(tool, false, false));
                modifierTips.add("");
            }
            if (IguanaConfig.levelingPickaxeBoost && hLevel >= TConstructRegistry.getMaterial((String)"Copper").harvestLevel() && hLevel < TConstructRegistry.getMaterial((String)"Manyullyn").harvestLevel() && !tags.func_74764_b("HarvestLevelModified") && (tool.func_77973_b() instanceof Pickaxe || tool.func_77973_b() instanceof Hammer)) {
                tips.add(IguanaLevelingLogic.getXpString(tool, false, true));
                modifierTips.add("");
            }
        }
        int tipNum = 0;
        while (tags.func_74764_b(tip = "Tooltip" + ++tipNum)) {
            String tipString = tags.func_74779_i(tip);
            if (!(tipString.startsWith("XP:") || tipString.startsWith("Head XP:") || tipString.startsWith("Boost XP:") || tipString.startsWith("Skill Level:") || tipString.startsWith("Mining Level:") || tipString.contains("Requires boost"))) {
                tips.add(tipString);
                modifierTips.add(tags.func_74779_i("ModifierTip" + tipNum));
            }
            tags.func_82580_o(tip);
            tags.func_82580_o("ModifierTip" + tipNum);
        }
        if (pickLeveled) {
            tips.add("\u00a76Boosted");
            modifierTips.add("");
        }
        for (int i = 1; i <= tips.size(); ++i) {
            if (tips.get(i - 1) == null) continue;
            tags.func_74778_a("Tooltip" + i, (String)tips.get(i - 1));
            if (modifierTips.get(i - 1) != null) {
                tags.func_74778_a("ModifierTip" + i, (String)modifierTips.get(i - 1));
                continue;
            }
            tags.func_74778_a("ModifierTip" + i, "");
        }
    }

    public static void addXP(ItemStack tool, EntityPlayer player, long xp) {
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        Long toolXP = tags.func_74764_b("ToolEXP") ? tags.func_74763_f("ToolEXP") + xp : -1L;
        Long headXP = tags.func_74764_b("HeadEXP") ? tags.func_74763_f("HeadEXP") + xp : -1L;
        IguanaLevelingLogic.updateXP(tool, player, toolXP, headXP);
    }

    public static int getRequiredXp(ItemStack tool) {
        return IguanaLevelingLogic.getRequiredXp(tool, null);
    }

    public static int getRequiredXp(ItemStack tool, boolean pick) {
        return IguanaLevelingLogic.getRequiredXp(tool, null, pick);
    }

    public static int getRequiredXp(ItemStack tool, NBTTagCompound tags) {
        return IguanaLevelingLogic.getRequiredXp(tool, tags, false);
    }

    public static int getRequiredXp(ItemStack tool, NBTTagCompound tags, boolean pick) {
        if (tags == null) {
            tags = tool.func_77978_p().func_74775_l("InfiTool");
        }
        float base = 400.0f;
        if (tool.func_77973_b() instanceof Weapon || tool.func_77973_b() instanceof Shortbow) {
            if (tool.func_77973_b() instanceof Scythe) {
                base *= 1.5f;
            }
            base *= (float)IguanaConfig.xpRequiredWeaponsPercentage / 100.0f;
        } else {
            int miningSpeed = tags.func_74762_e("MiningSpeed");
            int divider = 1;
            if (tags.func_74764_b("MiningSpeed2")) {
                miningSpeed += tags.func_74762_e("MiningSpeed2");
                ++divider;
            }
            if (tags.func_74764_b("MiningSpeedHandle")) {
                miningSpeed += tags.func_74762_e("MiningSpeedHandle");
                ++divider;
            }
            if (tags.func_74764_b("MiningSpeedExtra")) {
                miningSpeed += tags.func_74762_e("MiningSpeedExtra");
                ++divider;
            }
            base = 100.0f;
            base += (float)miningSpeed / (float)divider / 2.0f;
            if (tool.func_77973_b() instanceof Hatchet) {
                base /= 2.0f;
            } else if (tool.func_77973_b() instanceof Shovel) {
                base *= 2.0f;
            } else if (tool.func_77973_b() instanceof Mattock) {
                base *= 2.5f;
            } else if (tool.func_77973_b() instanceof LumberAxe) {
                base *= 3.0f;
            } else if (tool.func_77973_b() instanceof Hammer) {
                base *= 6.0f;
            } else if (tool.func_77973_b() instanceof Excavator) {
                base *= 9.0f;
            }
            base *= (float)IguanaConfig.xpRequiredToolsPercentage / 100.0f;
        }
        if (pick) {
            int harvestLevelCopper = TConstructRegistry.getMaterial((String)"Copper").harvestLevel();
            int harvestLevel = TConstructRegistry.getMaterial((int)tags.func_74762_e("Head")).harvestLevel();
            if (harvestLevel >= harvestLevelCopper) {
                base = (float)((double)base * Math.pow(IguanaConfig.xpPerLevelMultiplier, harvestLevel - harvestLevelCopper));
            }
            base *= (float)IguanaConfig.levelingPickaxeBoostXpPercentage / 100.0f;
        } else {
            int level = tags.func_74762_e("ToolLevel");
            if (level >= 1) {
                base = (float)((double)base * Math.pow(IguanaConfig.xpPerLevelMultiplier, level - 1));
            }
        }
        return Math.round(base);
    }

    public static void LevelUpTool(ItemStack stack, EntityPlayer player) {
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        World world = player.field_70170_p;
        int level = tags.func_74762_e("ToolLevel");
        tags.func_74768_a("ToolLevel", ++level);
        boolean isTool = stack.func_77973_b() instanceof HarvestTool;
        IguanaLevelingLogic.updateXP(stack, player, 0L, -1L);
        if (!world.field_72995_K) {
            switch (level) {
                case 2: {
                    player.func_71035_c("\u00a73You begin to feel comfortable handling the " + stack.func_82833_r());
                    break;
                }
                case 3: {
                    player.func_71035_c("\u00a73You are now accustomed to the weight of the " + stack.func_82833_r());
                    break;
                }
                case 4: {
                    player.func_71035_c("\u00a73You have become adept at handling the " + stack.func_82833_r());
                    break;
                }
                case 5: {
                    player.func_71035_c("\u00a73You are now an expert at using the " + stack.func_82833_r() + "\u00a73!");
                    break;
                }
                case 6: {
                    player.func_71035_c("\u00a73You have mastered the " + stack.func_82833_r() + "\u00a73!");
                }
            }
            if (!IguanaConfig.toolLevelingRandomBonuses || level % 2 == 0 && IguanaConfig.toolLevelingExtraModifiers) {
                player.func_71035_c("\u00a79You notice room for improvement (+1 modifier).");
            }
        }
        int currentModifiers = tags.func_74762_e("Modifiers");
        if (!IguanaConfig.toolLevelingRandomBonuses || level % 2 == 0 && IguanaConfig.toolLevelingExtraModifiers) {
            tags.func_74768_a("Modifiers", ++currentModifiers);
        }
        if (IguanaConfig.toolLevelingRandomBonuses) {
            tags.func_74768_a("Modifiers", currentModifiers + 1);
            for (int i = 1; i <= 10 && !IguanaLevelingLogic.tryModify(player, stack, world.field_73012_v.nextInt(10), isTool); ++i) {
            }
            tags.func_74768_a("Modifiers", currentModifiers);
        }
    }

    public static void LevelUpPick(ItemStack stack, EntityPlayer player, boolean leveled) {
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        World world = player.field_70170_p;
        tags.func_74762_e("ToolLevel");
        IguanaLevelingLogic.updateXP(stack, player, -1L, 0L);
        if (!world.field_72995_K) {
            if (leveled) {
                player.func_71035_c("\u00a79Suddenly, a flash of light shines from the tip of the pickaxe (+1 mining level)");
            } else {
                player.func_71035_c("\u00a73Suddenly, a flash of light shines from the tip of your " + stack.func_82833_r() + "\u00a73 (+1 mining level)");
            }
        }
        tags.func_74757_a("HarvestLevelModified", true);
        tags.func_74768_a("HarvestLevel", tags.func_74762_e("HarvestLevel") + 1);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean tryModify(EntityPlayer player, ItemStack stack, int rnd, boolean isTool) {
        void var4_16;
        Object var4_4 = null;
        Item item = stack.func_77973_b();
        ItemStack[] nullItemStack = new ItemStack[]{};
        if (rnd < 1) {
            ModInteger modInteger = new ModInteger(nullItemStack, 4, "Moss", IguanaConfig.mossRepairSpeed, "\u00a72", "Auto-Repair");
            if (!player.field_70170_p.field_72995_K) {
                player.func_71035_c("\u00a79It seems to have accumulated a patch of moss (+1 repair)");
            }
        } else if (rnd < 2 && (!isTool && !(item instanceof Shortbow) || isTool && (item instanceof Pickaxe || item instanceof Hammer))) {
            IguanaModLapis iguanaModLapis = new IguanaModLapis(nullItemStack, 10, new int[]{100});
            if (!iguanaModLapis.canModify(stack, nullItemStack)) return false;
            if (!player.field_70170_p.field_72995_K) {
                player.func_71035_c("\u00a79Perhaps holding on to it will bring you luck? (+100 luck)");
            }
        } else if (rnd < 6 && (isTool || item instanceof Shortbow)) {
            IguanaModRedstone iguanaModRedstone = new IguanaModRedstone(nullItemStack, 2, 50);
            if (!iguanaModRedstone.canModify(stack, nullItemStack, true)) return false;
            if (!player.field_70170_p.field_72995_K) {
                player.func_71035_c("\u00a79You spin it around with a flourish (+1 haste)");
            }
        } else if (rnd < 3 && !isTool && !(item instanceof Shortbow)) {
            IguanaModAttack iguanaModAttack = new IguanaModAttack("Quartz", nullItemStack, 11, 30);
            if (!iguanaModAttack.canModify(stack, nullItemStack, true)) return false;
            if (!player.field_70170_p.field_72995_K) {
                player.func_71035_c("\u00a79You take the time to sharpen the dull edges of the blade (+1 attack)");
            }
        } else if (rnd < 4 && !isTool && !(item instanceof Shortbow)) {
            ModInteger modInteger = new ModInteger(nullItemStack, 13, "Beheading", 1, "\u00a7d", "Beheading");
            if (!player.field_70170_p.field_72995_K) {
                player.func_71035_c("\u00a79You could take someones head off with that! (+1 beheading)");
            }
        } else if (rnd < 5 && !isTool && !(item instanceof Shortbow)) {
            IguanaModBlaze iguanaModBlaze = new IguanaModBlaze(nullItemStack, 7, new int[]{25});
            if (!iguanaModBlaze.canModify(stack, nullItemStack)) return false;
            if (!player.field_70170_p.field_72995_K) {
                player.func_71035_c("\u00a79It starts to feels more hot to the touch (+1 fire aspect)");
            }
        } else if (rnd < 6 && !isTool && !(item instanceof Shortbow)) {
            ModInteger modInteger = new ModInteger(nullItemStack, 8, "Necrotic", 1, "\u00a78", "Life Steal");
            if (!player.field_70170_p.field_72995_K) {
                player.func_71035_c("\u00a79It shudders with a strange energy (+1 life steal)");
            }
        } else if (rnd < 7 && !isTool && !(item instanceof Shortbow)) {
            ModSmite modSmite = new ModSmite("Smite", 14, nullItemStack, new int[]{36});
            if (!player.field_70170_p.field_72995_K) {
                player.func_71035_c("\u00a79It begins to radiate a slight glow (+1 smite)");
            }
        } else if (rnd < 8 && !isTool && !(item instanceof Shortbow)) {
            ModAntiSpider modAntiSpider = new ModAntiSpider("Anti-Spider", 15, nullItemStack, new int[]{4});
            if (!player.field_70170_p.field_72995_K) {
                player.func_71035_c("\u00a79A strange odor emanates from the weapon (+1 bane of arthropods)");
            }
        } else if (rnd < 9 && !isTool) {
            IguanaModPiston iguanaModPiston = new IguanaModPiston(nullItemStack, 3, new int[]{10});
            if (!iguanaModPiston.canModify(stack, nullItemStack)) return false;
            if (!player.field_70170_p.field_72995_K) {
                player.func_71035_c("\u00a79Feeling more confident, you can more easily keep your assailants at bay (+1 knockback)");
            }
        } else if (rnd < 10) {
            ModReinforced modReinforced = new ModReinforced(nullItemStack, 16, 1);
            if (!player.field_70170_p.field_72995_K) {
                player.func_71035_c("\u00a79Fixing up the wear and tear should make it last a little longer (+1 reinforced)");
            }
        }
        if (var4_16 == null) {
            return false;
        }
        var4_16.addMatchingEffect(stack);
        var4_16.modify(nullItemStack, stack);
        return true;
    }
}

