/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct;

import iguanaman.iguanatweakstconstruct.IguanaConfig;
import iguanaman.iguanatweakstconstruct.IguanaLog;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import tconstruct.common.TContent;
import tconstruct.library.TConstructRegistry;

public class HarvestLevelTweaks {
    public static int boostMod = 0;
    public static String[][] oreDictLevels = new String[][]{new String[0], {"Copper", "Coal", "Tetrahedrite", "Aluminum", "Aluminium", "NaturalAluminum", "AluminumBrass", "Shard", "Bauxite", "Zinc"}, {"Iron", "Pyrite", "Lead", "Silver"}, {"Tin", "Cassiterite", "Gold", "Lapis", "Steel", "Galena", "Nickel", "Invar", "Electrum", "Sphalerite"}, {"Diamond", "Emerald", "Redstone", "Ruby", "Sapphire", "Cinnabar", "Quartz", "Obsidian", "CertusQuartz", "Tungstate", "Sodalite", "GreenSapphire", "BlackGranite", "RedGranite"}, {"Ardite", "Uranium", "Olivine", "Sheldonite", "Osmium", "Platinum"}, {"Cobalt", "Iridium", "Cooperite", "Titanium"}, {"Manyullyn"}};

    /*
     * WARNING - void declaration
     */
    public static void init() {
        void var15_25;
        IguanaLog.log("Modifying harvest levels of tools");
        ForgeHooks hooks = new ForgeHooks();
        Field f = null;
        try {
            f = ForgeHooks.class.getDeclaredField("toolClasses");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Could not access toolClasses field, report please");
        }
        f.setAccessible(true);
        HashMap toolClasses = null;
        try {
            toolClasses = (HashMap)f.get(hooks);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not access toolClasses field, report please");
        }
        int harvestLevelWood = TConstructRegistry.getMaterial((String)"Wood").harvestLevel();
        int harvestLevelFlint = TConstructRegistry.getMaterial((String)"Flint").harvestLevel();
        int harvestLevelIron = TConstructRegistry.getMaterial((String)"Iron").harvestLevel();
        int harvestLevelObsidian = TConstructRegistry.getMaterial((String)"Obsidian").harvestLevel();
        int harvestLevelArdite = TConstructRegistry.getMaterial((String)"Ardite").harvestLevel();
        int harvestLevelCobalt = TConstructRegistry.getMaterial((String)"Cobalt").harvestLevel();
        int harvestLevelManyullyn = TConstructRegistry.getMaterial((String)"Manyullyn").harvestLevel();
        for (Map.Entry entry : toolClasses.entrySet()) {
            int harvestLevel;
            Item item = (Item)entry.getKey();
            List info = (List)entry.getValue();
            Object[] tmp = info.toArray();
            String string = (String)tmp[0];
            int newHarvestLevel = harvestLevel = ((Integer)tmp[1]).intValue();
            if (item == null || !string.equals("pickaxe")) continue;
            if (IguanaConfig.pickaxeOverrides.containsKey(item.field_77779_bT)) {
                harvestLevel = IguanaConfig.pickaxeOverrides.get(item.field_77779_bT);
            }
            switch (harvestLevel) {
                case 0: {
                    newHarvestLevel = harvestLevelWood;
                    break;
                }
                case 1: {
                    newHarvestLevel = harvestLevelFlint;
                    break;
                }
                case 2: {
                    newHarvestLevel = harvestLevelIron;
                    break;
                }
                case 3: {
                    newHarvestLevel = harvestLevelObsidian;
                    break;
                }
                case 4: {
                    newHarvestLevel = harvestLevelArdite;
                    break;
                }
                case 5: {
                    newHarvestLevel = harvestLevelCobalt;
                    break;
                }
                case 6: {
                    newHarvestLevel = harvestLevelManyullyn;
                    break;
                }
                default: {
                    newHarvestLevel = harvestLevelManyullyn + harvestLevel - 6;
                }
            }
            if (harvestLevel == newHarvestLevel) continue;
            if (IguanaConfig.logMiningLevelChanges) {
                IguanaLog.log("Changing mining level of " + ((Item)entry.getKey()).func_77658_a() + " from " + harvestLevel + " to " + newHarvestLevel);
            }
            entry.setValue(Arrays.asList(string, newHarvestLevel));
        }
        if (IguanaConfig.pickaxeBoostRequired) {
            boostMod = 1;
        }
        int n = TConstructRegistry.getMaterial((String)"Copper").harvestLevel() + boostMod;
        harvestLevelIron += boostMod;
        int harvestLevelBronze = TConstructRegistry.getMaterial((String)"Bronze").harvestLevel() + boostMod;
        harvestLevelObsidian += boostMod;
        harvestLevelArdite += boostMod;
        harvestLevelCobalt += boostMod;
        harvestLevelManyullyn += boostMod;
        IguanaLog.log("Modifying required harvest levels of blocks");
        try {
            f = ForgeHooks.class.getDeclaredField("toolHarvestLevels");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Could not access toolHarvestLevels field, report please");
        }
        f.setAccessible(true);
        HashMap toolHarvestLevels = null;
        try {
            toolHarvestLevels = (HashMap)f.get(hooks);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not access toolHarvestLevels field, report please");
        }
        for (Map.Entry entry : toolHarvestLevels.entrySet()) {
            int requiredHarvestLevel;
            List key = (List)entry.getKey();
            Object[] tmp = key.toArray();
            Block block = (Block)tmp[0];
            int metadata = (Integer)tmp[1];
            String toolClass = (String)tmp[2];
            if (!toolClass.equals("pickaxe")) continue;
            int newRequiredHarvestLevel = requiredHarvestLevel = ((Integer)entry.getValue()).intValue();
            switch (requiredHarvestLevel) {
                case 0: {
                    newRequiredHarvestLevel = harvestLevelWood;
                    break;
                }
                case 1: {
                    newRequiredHarvestLevel = n;
                    break;
                }
                case 2: {
                    newRequiredHarvestLevel = harvestLevelIron;
                    break;
                }
                case 3: {
                    newRequiredHarvestLevel = harvestLevelBronze;
                    break;
                }
                case 4: {
                    newRequiredHarvestLevel = harvestLevelObsidian;
                    break;
                }
                case 5: {
                    newRequiredHarvestLevel = harvestLevelArdite;
                    break;
                }
                case 6: {
                    newRequiredHarvestLevel = harvestLevelCobalt;
                    break;
                }
                case 7: {
                    newRequiredHarvestLevel = harvestLevelManyullyn;
                    break;
                }
                default: {
                    newRequiredHarvestLevel = harvestLevelManyullyn + requiredHarvestLevel - 7;
                }
            }
            if (requiredHarvestLevel == newRequiredHarvestLevel) continue;
            if (IguanaConfig.logHarvestLevelChanges) {
                IguanaLog.log("Changing required harvest level of " + block.func_71917_a() + ":" + metadata + " from " + requiredHarvestLevel + " to " + newRequiredHarvestLevel);
            }
            entry.setValue(newRequiredHarvestLevel);
        }
        boolean bl = false;
        while (var15_25 < oreDictLevels.length) {
            void level = var15_25;
            if (var15_25 > true) {
                level += boostMod;
            }
            for (String materialName : oreDictLevels[var15_25]) {
                for (ItemStack oreStack : OreDictionary.getOres((String)("ore" + materialName))) {
                    HarvestLevelTweaks.SetHarvestLevel(oreStack, (int)level);
                }
                for (ItemStack oreStack : OreDictionary.getOres((String)("oreNether" + materialName))) {
                    HarvestLevelTweaks.SetHarvestLevel(oreStack, (int)level);
                }
                for (ItemStack oreStack : OreDictionary.getOres((String)("block" + materialName))) {
                    HarvestLevelTweaks.SetHarvestLevel(oreStack, (int)level);
                }
                for (ItemStack oreStack : OreDictionary.getOres((String)("stone" + materialName))) {
                    HarvestLevelTweaks.SetHarvestLevel(oreStack, (int)level);
                }
            }
            ++var15_25;
        }
        IguanaLog.log("Modifying required harvest levels of vanilla blocks");
        MinecraftForge.setBlockHarvestLevel((Block)Block.field_72089_ap, (String)"pickaxe", (int)harvestLevelBronze);
        MinecraftForge.setBlockHarvestLevel((Block)Block.field_72073_aw, (String)"pickaxe", (int)harvestLevelBronze);
        MinecraftForge.setBlockHarvestLevel((Block)Block.field_72071_ax, (String)"pickaxe", (int)harvestLevelBronze);
        MinecraftForge.setBlockHarvestLevel((Block)Block.field_72105_ah, (String)"pickaxe", (int)harvestLevelIron);
        MinecraftForge.setBlockHarvestLevel((Block)Block.field_72083_ai, (String)"pickaxe", (int)n);
        MinecraftForge.setBlockHarvestLevel((Block)Block.field_72002_bp, (String)"pickaxe", (int)n);
        MinecraftForge.setBlockHarvestLevel((Block)Block.field_71948_O, (String)"pickaxe", (int)harvestLevelIron);
        MinecraftForge.setBlockHarvestLevel((Block)Block.field_72047_aN, (String)"pickaxe", (int)harvestLevelBronze);
        MinecraftForge.setBlockHarvestLevel((Block)Block.field_72048_aO, (String)"pickaxe", (int)harvestLevelBronze);
        MinecraftForge.setBlockHarvestLevel((Block)TContent.oreGravel, (int)0, (String)"shovel", (int)harvestLevelIron);
        MinecraftForge.setBlockHarvestLevel((Block)TContent.oreGravel, (int)1, (String)"shovel", (int)harvestLevelIron);
        MinecraftForge.setBlockHarvestLevel((Block)TContent.oreGravel, (int)2, (String)"shovel", (int)harvestLevelFlint);
        MinecraftForge.setBlockHarvestLevel((Block)TContent.oreGravel, (int)3, (String)"shovel", (int)harvestLevelIron);
        MinecraftForge.setBlockHarvestLevel((Block)TContent.oreGravel, (int)4, (String)"shovel", (int)harvestLevelFlint);
        MinecraftForge.setBlockHarvestLevel((Block)TContent.oreGravel, (int)5, (String)"shovel", (int)harvestLevelArdite);
        List[] listArray = new List[]{IguanaConfig.harvestLevel0Ids, IguanaConfig.harvestLevel1Ids, IguanaConfig.harvestLevel2Ids, IguanaConfig.harvestLevel3Ids, IguanaConfig.harvestLevel4Ids, IguanaConfig.harvestLevel5Ids, IguanaConfig.harvestLevel6Ids, IguanaConfig.harvestLevel7Ids};
        for (int i = 0; i < oreDictLevels.length; ++i) {
            int level = i;
            if (i > 1) {
                level += boostMod;
            }
            for (String idline : listArray[i]) {
                int blockId = -1;
                int meta = Short.MAX_VALUE;
                try {
                    if (idline.contains(":")) {
                        String[] idlinesplit = idline.split(":");
                        blockId = Integer.parseInt(idlinesplit[0]);
                        meta = Integer.parseInt(idlinesplit[1]);
                    } else {
                        blockId = Integer.parseInt(idline);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Config setting harvestLevel" + i + "Ids contains an invalid line (" + idline + ").  Each id must be on a separate line and in this format: id or id:meta");
                }
                HarvestLevelTweaks.SetHarvestLevel(new ItemStack(blockId, 1, meta), level);
            }
        }
    }

    public static void SetHarvestLevel(ItemStack oreStack, int level) {
        if (oreStack.func_77960_j() == Short.MAX_VALUE) {
            MinecraftForge.setBlockHarvestLevel((Block)Block.field_71973_m[oreStack.field_77993_c], (String)"pickaxe", (int)level);
        } else {
            MinecraftForge.setBlockHarvestLevel((Block)Block.field_71973_m[oreStack.field_77993_c], (int)oreStack.func_77960_j(), (String)"pickaxe", (int)level);
        }
    }
}

