/*
 * Decompiled with CFR 0.152.
 */
package tsteelworks.plugins;

import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.List;
import tsteelworks.lib.TSLogger;
import tsteelworks.plugins.ICompatPlugin;
import tsteelworks.plugins.fmp.ForgeMultiPart;
import tsteelworks.plugins.waila.Waila;

public class PluginController {
    private static PluginController instance;
    private final List<ICompatPlugin> plugins = new ArrayList<ICompatPlugin>();
    private Phase currPhase = Phase.PRELAUNCH;

    public static PluginController getController() {
        if (instance == null) {
            instance = new PluginController();
        }
        return instance;
    }

    private PluginController() {
    }

    public void init() {
        this.currPhase = Phase.INIT;
        for (ICompatPlugin plugin : this.plugins) {
            plugin.init();
        }
    }

    public void postInit() {
        this.currPhase = Phase.POSTINIT;
        for (ICompatPlugin plugin : this.plugins) {
            plugin.postInit();
        }
        this.currPhase = Phase.DONE;
    }

    public void preInit() {
        this.currPhase = Phase.PREINIT;
        for (ICompatPlugin plugin : this.plugins) {
            plugin.preInit();
        }
    }

    public void registerBuiltins() {
        this.registerPlugin(new ForgeMultiPart());
        this.registerPlugin(new Waila());
    }

    public void registerPlugin(ICompatPlugin plugin) {
        if (Loader.isModLoaded((String)plugin.getModId())) {
            TSLogger.info("Registering compat plugin for " + plugin.getModId());
            this.plugins.add(plugin);
            switch (this.currPhase) {
                case DONE: 
                case POSTINIT: {
                    plugin.preInit();
                    plugin.init();
                    plugin.postInit();
                    break;
                }
                case INIT: {
                    plugin.preInit();
                    plugin.init();
                    break;
                }
                case PREINIT: {
                    plugin.preInit();
                    break;
                }
            }
        }
    }

    private static enum Phase {
        PRELAUNCH,
        PREINIT,
        INIT,
        POSTINIT,
        DONE;

    }
}

