/*
 * Decompiled with CFR 0.152.
 */
package tsteelworks.lib.crafting;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import tconstruct.library.crafting.FluidType;
import tsteelworks.util.InventoryHelper;

public class AdvancedSmelting {
    public static AdvancedSmelting instance = new AdvancedSmelting();
    private final HashMap<List<Integer>, FluidStack> meltingList = new HashMap();
    private final HashMap<List<Integer>, Integer> temperatureList = new HashMap();
    private final HashMap<String, List<Integer>> mixItemList = new HashMap();
    private final Multimap<FluidType, List> fluidComboList = ArrayListMultimap.create();
    private final Multimap<ItemStack, List> itemComboList = ArrayListMultimap.create();
    private final HashMap<List<Integer>, ItemStack> renderIndex = new HashMap();

    public static void addMelting(Block block, int metadata, int temperature, FluidStack output) {
        AdvancedSmelting.addMelting(new ItemStack(block, 1, metadata), block.field_71990_ca, metadata, temperature, output);
    }

    public static void addDictionaryMelting(String oreName, FluidType type, int tempDiff, int fluidAmount) {
        for (ItemStack is : OreDictionary.getOres((String)oreName)) {
            AdvancedSmelting.addMelting(type, is, tempDiff, fluidAmount);
        }
    }

    public static void addMelting(FluidType type, ItemStack input, int tempDiff, int fluidAmount) {
        int temp = type.baseTemperature + tempDiff;
        if (temp <= 20) {
            temp = type.baseTemperature;
        }
        AdvancedSmelting.addMelting(input, type.renderBlockID, type.renderMeta, type.baseTemperature + tempDiff, new FluidStack(type.fluid, fluidAmount));
    }

    public static void addMelting(ItemStack itemstack, int blockID, int metadata, int temperature, FluidStack liquid) {
        AdvancedSmelting.instance.meltingList.put(Arrays.asList(itemstack.field_77993_c, itemstack.func_77960_j()), liquid);
        AdvancedSmelting.instance.temperatureList.put(Arrays.asList(itemstack.field_77993_c, itemstack.func_77960_j()), temperature);
        AdvancedSmelting.instance.renderIndex.put(Arrays.asList(itemstack.field_77993_c, itemstack.func_77960_j()), new ItemStack(blockID, itemstack.field_77994_a, metadata));
    }

    public static FluidStack getMeltingResult(int blockID, int metadata) {
        FluidStack stack = AdvancedSmelting.instance.meltingList.get(Arrays.asList(blockID, metadata));
        if (stack == null) {
            return null;
        }
        return stack.copy();
    }

    public static FluidStack getMeltingResult(ItemStack itemstack) {
        if (itemstack == null) {
            return null;
        }
        FluidStack stack = AdvancedSmelting.instance.meltingList.get(Arrays.asList(itemstack.field_77993_c, itemstack.func_77960_j()));
        if (stack == null) {
            return null;
        }
        return stack.copy();
    }

    public static Integer getLiquifyTemperature(ItemStack itemstack) {
        if (itemstack == null) {
            return 20;
        }
        Integer temp = AdvancedSmelting.instance.temperatureList.get(Arrays.asList(itemstack.field_77993_c, itemstack.func_77960_j()));
        if (temp == null) {
            return 20;
        }
        return temp;
    }

    public static Integer getLiquifyTemperature(int blockID, int metadata) {
        return AdvancedSmelting.instance.temperatureList.get(Arrays.asList(blockID, metadata));
    }

    public static ItemStack getRenderIndex(ItemStack itemstack) {
        return AdvancedSmelting.instance.renderIndex.get(Arrays.asList(itemstack.field_77993_c, itemstack.func_77960_j()));
    }

    public static void registerMixItem(String oreName, int type, int consume, int chance) {
        for (ItemStack is : OreDictionary.getOres((String)oreName)) {
            AdvancedSmelting.instance.mixItemList.put(InventoryHelper.getOreDictionaryName(is), Arrays.asList(type, consume, chance));
        }
    }

    public static void registerMixComboForFluidOutput(FluidType fluidout, FluidType fluidin, String i1, String i2, String i3) {
        AdvancedSmelting.instance.fluidComboList.put((Object)fluidout, Arrays.asList(fluidin, i1, i2, i3));
    }

    public static void registerMixComboForSolidOutput(ItemStack stackout, FluidType fluidin, String i1, String i2, String i3) {
        AdvancedSmelting.instance.itemComboList.put((Object)stackout, Arrays.asList(fluidin, i1, i2, i3));
    }

    public static void getMixComboForFluidOutput(FluidType fluidtype) {
        AdvancedSmelting.instance.fluidComboList.get((Object)fluidtype);
    }

    public static void getMixComboForSolidOutput(ItemStack itemstack) {
        AdvancedSmelting.instance.itemComboList.get((Object)itemstack);
    }

    public static Boolean isMixItemListed(ItemStack itemstack) {
        return AdvancedSmelting.instance.mixItemList.containsKey(InventoryHelper.getOreDictionaryName(itemstack));
    }

    public static Integer getMixItemType(ItemStack itemstack) {
        List<Integer> list = AdvancedSmelting.instance.mixItemList.get(InventoryHelper.getOreDictionaryName(itemstack));
        return list.get(0);
    }

    public static Integer getMixItemConsumeAmount(ItemStack item) {
        List<Integer> list = AdvancedSmelting.instance.mixItemList.get(InventoryHelper.getOreDictionaryName(item));
        return list.get(1);
    }

    public static Integer getMixItemConsumeChance(ItemStack itemstack) {
        List<Integer> list = AdvancedSmelting.instance.mixItemList.get(InventoryHelper.getOreDictionaryName(itemstack));
        return list.get(2);
    }

    public static Boolean doesMixItemMeetRequirements(ItemStack itemstack) {
        if (itemstack == null) {
            return true;
        }
        if (!AdvancedSmelting.isMixItemListed(itemstack).booleanValue()) {
            return false;
        }
        return itemstack.field_77994_a >= AdvancedSmelting.getMixItemConsumeAmount(itemstack);
    }

    public static FluidType getMixFluidSmeltingResult(FluidType f1, ItemStack i1, ItemStack i2, ItemStack i3) {
        String ox = InventoryHelper.getOreDictionaryName(i1);
        String re = InventoryHelper.getOreDictionaryName(i2);
        String pu = InventoryHelper.getOreDictionaryName(i3);
        ArrayList<Serializable> inputs = new ArrayList<Serializable>(Arrays.asList(f1, ox, re, pu));
        for (Map.Entry e : AdvancedSmelting.instance.fluidComboList.entries()) {
            FluidType key = (FluidType)e.getKey();
            List value = (List)e.getValue();
            if (!value.equals(inputs) || !AdvancedSmelting.doesMixItemMeetRequirements(i1).booleanValue() || !AdvancedSmelting.doesMixItemMeetRequirements(i2).booleanValue() || !AdvancedSmelting.doesMixItemMeetRequirements(i3).booleanValue()) continue;
            return key;
        }
        return null;
    }

    public static ItemStack getMixItemSmeltingResult(FluidType f1, ItemStack i1, ItemStack i2, ItemStack i3) {
        String ox = InventoryHelper.getOreDictionaryName(i1);
        String re = InventoryHelper.getOreDictionaryName(i2);
        String pu = InventoryHelper.getOreDictionaryName(i3);
        ArrayList<Serializable> inputs = new ArrayList<Serializable>(Arrays.asList(f1, ox, re, pu));
        for (Map.Entry e : AdvancedSmelting.instance.itemComboList.entries()) {
            ItemStack key = (ItemStack)e.getKey();
            List value = (List)e.getValue();
            if (!value.equals(inputs) || !AdvancedSmelting.doesMixItemMeetRequirements(i1).booleanValue() || !AdvancedSmelting.doesMixItemMeetRequirements(i2).booleanValue() || !AdvancedSmelting.doesMixItemMeetRequirements(i3).booleanValue()) continue;
            return key.func_77946_l();
        }
        return null;
    }

    public static HashMap<List<Integer>, FluidStack> getMeltingList() {
        return AdvancedSmelting.instance.meltingList;
    }

    public static HashMap<List<Integer>, ItemStack> getRenderIndex() {
        return AdvancedSmelting.instance.renderIndex;
    }

    public static HashMap<List<Integer>, Integer> getTemperatureList() {
        return AdvancedSmelting.instance.temperatureList;
    }

    public static HashMap<String, List<Integer>> getMixItemsList() {
        return AdvancedSmelting.instance.mixItemList;
    }

    public static Multimap<FluidType, List> getFluidCombosList() {
        return AdvancedSmelting.instance.fluidComboList;
    }

    public static Multimap<ItemStack, List> getItemCombosList() {
        return AdvancedSmelting.instance.itemComboList;
    }
}

