/*
 * Decompiled with CFR 0.152.
 */
package tsteelworks.blocks.logic;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSourceImpl;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IRegistry;
import net.minecraft.dispenser.RegistryDefaulted;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import tconstruct.library.crafting.FluidType;
import tconstruct.library.util.CoordTuple;
import tconstruct.library.util.IActiveLogic;
import tconstruct.library.util.IFacingLogic;
import tconstruct.library.util.IMasterLogic;
import tconstruct.library.util.IServantLogic;
import tsteelworks.TSteelworks;
import tsteelworks.blocks.logic.HighOvenDuctLogic;
import tsteelworks.blocks.logic.TSMultiServantLogic;
import tsteelworks.common.TSContent;
import tsteelworks.inventory.HighOvenContainer;
import tsteelworks.lib.ConfigCore;
import tsteelworks.lib.TSFuelHandler;
import tsteelworks.lib.blocks.TSInventoryLogic;
import tsteelworks.lib.crafting.AdvancedSmelting;
import tsteelworks.util.InventoryHelper;

public class HighOvenLogic
extends TSInventoryLogic
implements IActiveLogic,
IFacingLogic,
IFluidTank,
IMasterLogic {
    public static final int SLOT_OXIDIZER = 0;
    public static final int SLOT_REDUCER = 1;
    public static final int SLOT_PURIFIER = 2;
    public static final int SLOT_FUEL = 3;
    public static final int SLOT_FIRST_MELTABLE = 4;
    public static final int FLUID_AMOUNT_PER_LAYER = 20000;
    public static final int DEFAULT_MAX_TEMP = 2000;
    public static final int ROOM_TEMP = 20;
    public final IRegistry dispenseBehavior = new RegistryDefaulted((Object)new BehaviorDefaultDispenseItem());
    public ArrayList<FluidStack> moltenMetal = new ArrayList();
    boolean structureHasBottom;
    boolean structureHasTop;
    boolean redstoneActivated = false;
    boolean needsUpdate;
    boolean isMeltingItems;
    public boolean validStructure;
    byte direction;
    public CoordTuple outputDuct;
    public CoordTuple centerPos;
    int internalTemp;
    int fuelHeatRate = 3;
    int internalCoolDownRate = 10;
    int tick;
    int maxLiquid;
    int currentLiquid;
    int numBricks;
    int maxTemp = 2000;
    int maxTempUserSet = 2000;
    public int layers;
    public int fuelBurnTime;
    public int[] activeTemps;
    public int[] meltingTemps;
    Random rand = new Random();

    public HighOvenLogic() {
        super(4);
        this.meltingTemps = new int[0];
        this.activeTemps = this.meltingTemps;
    }

    void adjustLayers(int lay, boolean forceAdjust) {
        if (lay != this.layers || forceAdjust) {
            int i;
            this.needsUpdate = true;
            this.layers = lay;
            this.maxLiquid = 20000 * lay;
            this.maxTemp = this.maxTempByLayer();
            int[] tempActive = this.activeTemps;
            this.activeTemps = new int[4 + lay];
            int activeLength = tempActive.length > this.activeTemps.length ? this.activeTemps.length : tempActive.length;
            System.arraycopy(tempActive, 0, this.activeTemps, 0, activeLength);
            int[] tempMelting = this.meltingTemps;
            this.meltingTemps = new int[4 + lay];
            int meltingLength = tempMelting.length > this.meltingTemps.length ? this.meltingTemps.length : tempMelting.length;
            System.arraycopy(tempMelting, 0, this.meltingTemps, 0, meltingLength);
            ItemStack[] tempInv = this.inventory;
            this.inventory = new ItemStack[4 + lay];
            int invLength = tempInv.length > this.inventory.length ? this.inventory.length : tempInv.length;
            System.arraycopy(tempInv, 0, this.inventory, 0, invLength);
            if (this.activeTemps.length > 0 && this.activeTemps.length > tempActive.length) {
                for (i = tempActive.length; i < this.activeTemps.length; ++i) {
                    if (!this.isSmeltingSlot(i)) continue;
                    this.activeTemps[i] = 20;
                    this.meltingTemps[i] = 20;
                }
            }
            if (tempInv.length > this.inventory.length) {
                for (i = this.inventory.length; i < tempInv.length; ++i) {
                    ItemStack stack = tempInv[i];
                    if (stack == null) continue;
                    float jumpX = this.rand.nextFloat() * 0.8f + 0.1f;
                    float jumpY = this.rand.nextFloat() * 0.8f + 0.1f;
                    float jumpZ = this.rand.nextFloat() * 0.8f + 0.1f;
                    int offsetX = 0;
                    int offsetZ = 0;
                    switch (this.getRenderDirection()) {
                        case 2: {
                            offsetZ = -1;
                            break;
                        }
                        case 3: {
                            offsetZ = 1;
                            break;
                        }
                        case 4: {
                            offsetX = -1;
                            break;
                        }
                        case 5: {
                            offsetX = 1;
                        }
                    }
                    while (stack.field_77994_a > 0) {
                        int itemSize = this.rand.nextInt(21) + 10;
                        if (itemSize > stack.field_77994_a) {
                            itemSize = stack.field_77994_a;
                        }
                        stack.field_77994_a -= itemSize;
                        EntityItem entityitem = new EntityItem(this.field_70331_k, (double)((float)this.field_70329_l + jumpX + (float)offsetX), (double)((float)this.field_70330_m + jumpY), (double)((float)this.field_70327_n + jumpZ + (float)offsetZ), new ItemStack(stack.field_77993_c, itemSize, stack.func_77960_j()));
                        if (stack.func_77942_o()) {
                            entityitem.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
                        }
                        float offset = 0.05f;
                        entityitem.field_70159_w = (float)this.rand.nextGaussian() * offset;
                        entityitem.field_70181_x = (float)this.rand.nextGaussian() * offset + 0.2f;
                        entityitem.field_70179_y = (float)this.rand.nextGaussian() * offset;
                        this.field_70331_k.func_72838_d((Entity)entityitem);
                    }
                }
            }
        }
    }

    public int maxTempByLayer() {
        int layerAdjustment = (this.layers - 1) * 500;
        int finalCalc = 2000 + layerAdjustment < 2000 ? 2000 : 2000 + layerAdjustment;
        return finalCalc;
    }

    public boolean canUpdate() {
        return true;
    }

    @Override
    public String getDefaultName() {
        return "crafters.HighOven";
    }

    @Override
    public Container getGuiContainer(InventoryPlayer inventoryplayer, World world, int x, int y, int z) {
        return new HighOvenContainer(inventoryplayer, this);
    }

    @Override
    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this) {
            return false;
        }
        return entityplayer.func_70011_f((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    public byte getRenderDirection() {
        return this.direction;
    }

    public ForgeDirection getForgeDirection() {
        return ForgeDirection.VALID_DIRECTIONS[this.direction];
    }

    public void setDirection(int side) {
    }

    public void setDirection(float yaw, float pitch, EntityLivingBase player) {
        int facing = MathHelper.func_76128_c((double)((double)(yaw / 360.0f) + 0.5)) & 3;
        switch (facing) {
            case 0: {
                this.direction = (byte)2;
                break;
            }
            case 1: {
                this.direction = (byte)5;
                break;
            }
            case 2: {
                this.direction = (byte)3;
                break;
            }
            case 3: {
                this.direction = (byte)4;
            }
        }
    }

    public boolean getActive() {
        return this.validStructure && this.isBurning();
    }

    public void setActive(boolean flag) {
        this.needsUpdate = true;
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public boolean getRSmode() {
        return this.redstoneActivated;
    }

    public void setRSmode(boolean flag) {
        this.redstoneActivated = flag;
        this.setActive(true);
    }

    public void func_70316_g() {
        ++this.tick;
        if (this.tick % 4 == 0) {
            this.heatItems();
        }
        if (this.tick % 20 == 0) {
            if (!this.validStructure) {
                this.checkValidPlacement();
            }
            if (this.isBurning()) {
                this.fuelBurnTime -= 3;
                this.internalTemp = Math.min(this.internalTemp + this.fuelHeatRate, this.maxTempByLayer());
            } else {
                this.internalTemp = Math.max(this.internalTemp - this.internalCoolDownRate, 20);
            }
            if (this.validStructure && this.fuelBurnTime <= 0) {
                this.updateFuelGauge();
            }
            if (this.needsUpdate) {
                this.needsUpdate = false;
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
        }
        if (this.tick % 40 == 0) {
            this.heatFluids();
        }
        if (this.tick == 60) {
            this.tick = 0;
        }
    }

    void heatItems() {
        if (this.internalTemp > 20) {
            boolean hasUse = false;
            for (int i = 4; i < this.layers + 4; ++i) {
                if (this.isStackInSlot(i) && this.meltingTemps[i] > 20) {
                    hasUse = true;
                    if (this.activeTemps[i] < this.internalTemp && this.activeTemps[i] < this.meltingTemps[i]) {
                        int n = i;
                        this.activeTemps[n] = this.activeTemps[n] + (this.internalTemp > 250 ? this.internalTemp / 250 : 1);
                        continue;
                    }
                    if (this.activeTemps[i] > this.internalTemp && this.internalTemp < this.meltingTemps[i]) {
                        int n = i;
                        this.activeTemps[n] = this.activeTemps[n] - 1;
                        continue;
                    }
                    if (this.activeTemps[i] < this.meltingTemps[i] || this.field_70331_k.field_72995_K) continue;
                    FluidStack result = this.getNormalResultFor(this.inventory[i]);
                    ItemStack resultitemstack = this.getSolidMixedResultFor(result);
                    if (resultitemstack != null) {
                        if (resultitemstack == null) continue;
                        this.meltItemsSolidOutput(i, resultitemstack, true);
                        continue;
                    }
                    if (result == null) continue;
                    FluidStack resultEx = this.getLiquidMixedResultFor(result);
                    if (resultEx != null) {
                        this.meltItemsLiquidOutput(i, resultEx, true);
                        continue;
                    }
                    this.meltItemsLiquidOutput(i, result, false);
                    continue;
                }
                this.activeTemps[i] = 20;
            }
            this.isMeltingItems = hasUse;
        }
    }

    void heatFluids() {
        if (this.internalTemp < 1300 || this.moltenMetal.size() < 1) {
            return;
        }
        if (this.getFluid().getFluid() == FluidRegistry.WATER || this.getFluid().getFluid() == FluidRegistry.getFluid((String)"Steam")) {
            FluidStack steam;
            int amount = 0;
            for (FluidStack fluid : this.moltenMetal) {
                if (fluid.getFluid() != FluidRegistry.WATER) continue;
                amount += fluid.amount;
            }
            if (amount > 0 && this.addFluidToTank(steam = new FluidStack(TSContent.steamFluid.getID(), amount), false)) {
                this.moltenMetal.remove(0);
                this.currentLiquid -= amount;
            }
        }
    }

    void meltItemsLiquidOutput(int slot, FluidStack fluid, Boolean doMix) {
        if (this.addFluidToTank(fluid, false)) {
            if (InventoryHelper.itemIsOre(this.inventory[slot])) {
                this.outputTE3Slag();
            }
            if (this.inventory[slot].field_77994_a >= 2) {
                --this.inventory[slot].field_77994_a;
            } else {
                this.inventory[slot] = null;
            }
            this.activeTemps[slot] = 20;
            if (doMix.booleanValue()) {
                this.removeMixItems();
            }
            this.func_70296_d();
        }
    }

    void meltItemsSolidOutput(int slot, ItemStack stack, Boolean doMix) {
        if (this.inventory[slot].field_77994_a >= 2) {
            --this.inventory[slot].field_77994_a;
        } else {
            this.inventory[slot] = null;
        }
        this.activeTemps[slot] = 20;
        if (doMix.booleanValue()) {
            this.removeMixItems();
        }
        this.addSolidItem(stack);
        this.func_70296_d();
    }

    public FluidStack getNormalResultFor(ItemStack stack) {
        return AdvancedSmelting.getMeltingResult(stack);
    }

    public FluidStack getLiquidMixedResultFor(FluidStack stack) {
        FluidType resultType = FluidType.getFluidType((Fluid)stack.getFluid());
        FluidType mixResult = AdvancedSmelting.getMixFluidSmeltingResult(resultType, this.inventory[0], this.inventory[1], this.inventory[2]);
        if (mixResult != null) {
            return new FluidStack(mixResult.fluid, stack.amount);
        }
        return null;
    }

    public ItemStack getSolidMixedResultFor(FluidStack stack) {
        FluidType resultType = FluidType.getFluidType((Fluid)stack.getFluid());
        ItemStack mixResult = AdvancedSmelting.getMixItemSmeltingResult(resultType, this.inventory[0], this.inventory[1], this.inventory[2]);
        if (mixResult != null) {
            return new ItemStack(mixResult.field_77993_c, mixResult.field_77994_a, mixResult.func_77960_j());
        }
        return null;
    }

    private void outputTE3Slag() {
        if (TSteelworks.thermalExpansionAvailable && ConfigCore.enableTE3SlagOutput && new Random().nextInt(100) <= 10) {
            this.addSolidItem(GameRegistry.findItemStack((String)"ThermalExpansion", (String)"slag", (int)1));
        }
    }

    private void removeMixItems() {
        for (int i = 0; i < 3; ++i) {
            if (this.inventory[i] == null) continue;
            int consumeChance = AdvancedSmelting.getMixItemConsumeChance(this.inventory[i]);
            int consumeAmount = AdvancedSmelting.getMixItemConsumeAmount(this.inventory[i]);
            if (new Random().nextInt(100) <= consumeChance && this.inventory[i].field_77994_a >= consumeAmount) {
                this.inventory[i].field_77994_a -= consumeAmount;
            }
            if (this.inventory[i] == null || this.inventory[i].field_77994_a != 0) continue;
            this.inventory[i] = null;
        }
    }

    public int getInternalTemperature() {
        return this.internalTemp;
    }

    public int getTempForSlot(int slot) {
        return this.isSmeltingSlot(slot) ? this.activeTemps[slot] : 20;
    }

    public int getMeltingPointForSlot(int slot) {
        return this.isSmeltingSlot(slot) ? this.meltingTemps[slot] : 20;
    }

    void updateTemperatures() {
        this.isMeltingItems = true;
        for (int i = 4; i < this.layers + 4; ++i) {
            this.meltingTemps[i] = AdvancedSmelting.getLiquifyTemperature(this.inventory[i]);
        }
    }

    public boolean isBurning() {
        return this.fuelBurnTime > 0;
    }

    public boolean hasFuel() {
        return HighOvenLogic.getFuelBurnTime(this.inventory[3]) > 0;
    }

    public int getScaledFuelGague(int scale) {
        int value = this.fuelBurnTime / scale;
        return value < 1 ? 1 : value;
    }

    void updateFuelGauge() {
        if (this.isBurning() || !this.redstoneActivated) {
            return;
        }
        if (this.inventory[3] == null) {
            this.fuelBurnTime = 0;
            return;
        }
        if (HighOvenLogic.getFuelBurnTime(this.inventory[3]) > 0) {
            this.needsUpdate = true;
            this.fuelBurnTime = HighOvenLogic.getFuelBurnTime(this.inventory[3]);
            this.fuelHeatRate = HighOvenLogic.getFuelHeatRate(this.inventory[3]);
            --this.inventory[3].field_77994_a;
            if (this.inventory[3].field_77994_a <= 0) {
                this.inventory[3] = null;
            }
        }
    }

    public void updateFuelDisplay() {
        if (HighOvenLogic.getFuelBurnTime(this.inventory[3]) > 0) {
            this.needsUpdate = true;
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    public static int getFuelBurnTime(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        return TSteelworks.fuelHandler.getHighOvenFuelBurnTime(stack);
    }

    public static int getFuelHeatRate(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        return TSFuelHandler.getHighOvenFuelHeatRate(stack);
    }

    public boolean isSmeltingSlot(int slot) {
        return slot > 3;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        this.updateTemperatures();
        super.func_70296_d();
        this.needsUpdate = true;
    }

    @Override
    public int func_70302_i_() {
        return this.inventory.length;
    }

    @Override
    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    @Override
    public ItemStack func_70298_a(int slot, int quantity) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].field_77994_a <= quantity) {
                ItemStack stack = this.inventory[slot];
                this.inventory[slot] = null;
                return stack;
            }
            ItemStack split = this.inventory[slot].func_77979_a(quantity);
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
            return split;
        }
        return null;
    }

    @Override
    public ItemStack func_70304_b(int slot) {
        return null;
    }

    @Override
    public void func_70299_a(int slot, ItemStack itemstack) {
        this.inventory[slot] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    @Override
    public String func_70303_b() {
        return this.func_94042_c() ? this.invName : this.getDefaultName();
    }

    @Override
    public boolean func_94042_c() {
        return this.invName != null && this.invName.length() > 0;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return slot < this.func_70302_i_() && (this.inventory[slot] == null || itemstack.field_77994_a + this.inventory[slot].field_77994_a <= this.func_70297_j_());
    }

    public void notifyChange(IServantLogic servant, int x, int y, int z) {
        this.checkValidPlacement();
    }

    public void checkValidPlacement() {
        switch (this.getRenderDirection()) {
            case 2: {
                this.alignInitialPlacement(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1);
                break;
            }
            case 3: {
                this.alignInitialPlacement(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1);
                break;
            }
            case 4: {
                this.alignInitialPlacement(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n);
                break;
            }
            case 5: {
                this.alignInitialPlacement(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n);
            }
        }
    }

    public void alignInitialPlacement(int x, int y, int z) {
        this.checkValidStructure(x, y, z);
    }

    @Deprecated
    public void checkValidStructureOld(int x, int y, int z) {
        int checkLayers = 0;
        if (this.checkSameLevel(x, y, z)) {
            ++checkLayers;
            checkLayers += this.recurseStructureUp(x, y + 1, z, 0);
            checkLayers += this.recurseStructureDown(x, y - 1, z, 0);
        }
        if (this.structureHasTop != this.structureHasBottom != this.validStructure || checkLayers != this.layers) {
            if (this.structureHasBottom && this.structureHasTop) {
                this.adjustLayers(checkLayers, false);
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                this.validStructure = true;
            } else {
                this.internalTemp = 20;
                this.validStructure = false;
            }
        }
    }

    public void checkValidStructure(int x, int y, int z) {
        boolean oldStructureHasBottom = this.structureHasBottom;
        boolean oldStructureHasTop = this.structureHasTop;
        this.structureHasBottom = false;
        this.structureHasTop = false;
        int checkedLayers = 0;
        if (this.checkSameLevel(x, y, z)) {
            ++checkedLayers;
            checkedLayers += this.recurseStructureUp(x, y + 1, z, 0);
            checkedLayers += this.recurseStructureDown(x, y - 1, z, 0);
        }
        if (oldStructureHasBottom != this.structureHasBottom || oldStructureHasTop != this.structureHasTop || this.layers != checkedLayers) {
            if (this.structureHasBottom && this.structureHasTop && checkedLayers > 0) {
                this.adjustLayers(checkedLayers, false);
                this.validStructure = true;
            } else {
                this.internalTemp = 20;
                this.validStructure = false;
            }
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    public boolean checkSameLevel(int x, int y, int z) {
        int xPos;
        this.numBricks = 0;
        for (xPos = x; xPos <= x; ++xPos) {
            for (int zPos = z; zPos <= z; ++zPos) {
                Block block = Block.field_71973_m[this.field_70331_k.func_72798_a(xPos, y, zPos)];
                if (block == null || block.isAirBlock(this.field_70331_k, xPos, y, zPos)) continue;
                return false;
            }
        }
        for (xPos = x - 1; xPos <= x + 1; ++xPos) {
            this.numBricks += this.checkBricks(xPos, y, z - 1);
            this.numBricks += this.checkBricks(xPos, y, z + 1);
        }
        for (int zPos = z; zPos <= z; ++zPos) {
            this.numBricks += this.checkBricks(x - 1, y, zPos);
            this.numBricks += this.checkBricks(x + 1, y, zPos);
        }
        return this.numBricks == 8;
    }

    public int recurseStructureUp(int x, int y, int z, int count) {
        int xPos;
        this.numBricks = 0;
        for (xPos = x; xPos <= x; ++xPos) {
            for (int zPos = z; zPos <= z; ++zPos) {
                int blockID = this.field_70331_k.func_72798_a(xPos, y, zPos);
                Block block = Block.field_71973_m[this.field_70331_k.func_72798_a(xPos, y, zPos)];
                if (block == null || block.isAirBlock(this.field_70331_k, xPos, y, zPos)) continue;
                if (this.validBlockID(blockID)) {
                    return this.validateTop(x, y, z, count);
                }
                return count;
            }
        }
        for (xPos = x - 1; xPos <= x + 1; ++xPos) {
            this.numBricks += this.checkBricks(xPos, y, z - 1);
            this.numBricks += this.checkBricks(xPos, y, z + 1);
        }
        for (int zPos = z; zPos <= z; ++zPos) {
            this.numBricks += this.checkBricks(x - 1, y, zPos);
            this.numBricks += this.checkBricks(x + 1, y, zPos);
        }
        if (this.numBricks != 8) {
            return count;
        }
        return this.recurseStructureUp(x, y + 1, z, ++count);
    }

    public int recurseStructureDown(int x, int y, int z, int count) {
        int xPos;
        this.numBricks = 0;
        for (xPos = x; xPos <= x; ++xPos) {
            for (int zPos = z; zPos <= z; ++zPos) {
                int blockID = this.field_70331_k.func_72798_a(xPos, y, zPos);
                Block block = Block.field_71973_m[blockID];
                if (block == null || block.isAirBlock(this.field_70331_k, xPos, y, zPos)) continue;
                if (this.validBlockID(blockID)) {
                    return this.validateBottom(x, y, z, count);
                }
                return count;
            }
        }
        for (xPos = x - 1; xPos <= x + 1; ++xPos) {
            this.numBricks += this.checkBricks(xPos, y, z - 1);
            this.numBricks += this.checkBricks(xPos, y, z + 1);
        }
        for (int zPos = z; zPos <= z; ++zPos) {
            this.numBricks += this.checkBricks(x - 1, y, zPos);
            this.numBricks += this.checkBricks(x + 1, y, zPos);
        }
        if (this.numBricks != 8) {
            return count;
        }
        return this.recurseStructureDown(x, y - 1, z, ++count);
    }

    public int validateTop(int x, int y, int z, int count) {
        int topBricks = 0;
        for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
            for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                if (!this.validBlockID(this.field_70331_k.func_72798_a(xPos, y, zPos)) || this.field_70331_k.func_72805_g(xPos, y, zPos) < 1) continue;
                topBricks += this.checkBricks(xPos, y, zPos);
            }
        }
        this.structureHasTop = topBricks == 9;
        return count;
    }

    public int validateBottom(int x, int y, int z, int count) {
        int bottomBricks = 0;
        for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
            for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                if (!this.validBlockID(this.field_70331_k.func_72798_a(xPos, y, zPos)) || this.field_70331_k.func_72805_g(xPos, y, zPos) < 1) continue;
                bottomBricks += this.checkBricks(xPos, y, zPos);
            }
        }
        boolean bl = this.structureHasBottom = bottomBricks == 9;
        if (this.structureHasBottom) {
            this.centerPos = new CoordTuple(x, y + 1, z);
        }
        return count;
    }

    int checkBricks(int x, int y, int z) {
        int tempBricks = 0;
        int blockID = this.field_70331_k.func_72798_a(x, y, z);
        if (this.validBlockID(blockID)) {
            TileEntity te = this.field_70331_k.func_72796_p(x, y, z);
            if (te == this) {
                ++tempBricks;
            } else if (te instanceof TSMultiServantLogic) {
                TSMultiServantLogic servant = (TSMultiServantLogic)te;
                if (servant.hasValidMaster()) {
                    if (servant.verifyMaster(this, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n)) {
                        ++tempBricks;
                    }
                } else if (servant.setMaster(this.field_70329_l, this.field_70330_m, this.field_70327_n)) {
                    ++tempBricks;
                }
            }
        }
        return tempBricks;
    }

    boolean validBlockID(int blockID) {
        return blockID == TSContent.highoven.field_71990_ca;
    }

    boolean addFluidToTank(FluidStack liquid, boolean first) {
        this.needsUpdate = true;
        if (this.moltenMetal.size() == 0) {
            this.moltenMetal.add(liquid.copy());
            this.currentLiquid += liquid.amount;
            return true;
        }
        if (liquid.amount + this.currentLiquid > this.maxLiquid) {
            return false;
        }
        this.currentLiquid += liquid.amount;
        boolean added = false;
        for (int i = 0; i < this.moltenMetal.size(); ++i) {
            FluidStack l = this.moltenMetal.get(i);
            if (l.isFluidEqual(liquid)) {
                l.amount += liquid.amount;
                added = true;
            }
            if (l.amount > 0) continue;
            this.moltenMetal.remove(l);
            --i;
        }
        if (!added) {
            if (first) {
                this.moltenMetal.add(0, liquid.copy());
            } else {
                this.moltenMetal.add(liquid.copy());
            }
        }
        return true;
    }

    void addSolidItem(ItemStack stack) {
        boolean transferred = false;
        if (this.outputDuct != null) {
            TileEntity te = this.field_70331_k.func_72796_p(this.outputDuct.x, this.outputDuct.y, this.outputDuct.z);
            if (te != null && te instanceof HighOvenDuctLogic) {
                transferred = this.sendItemToDuct((HighOvenDuctLogic)te, stack);
            } else {
                this.outputDuct = null;
            }
        }
        if (!transferred) {
            this.dispenseSolidItem(stack);
        }
    }

    boolean sendItemToDuct(HighOvenDuctLogic duct, ItemStack stack) {
        boolean effective = false;
        ItemStack copystack = new ItemStack(stack.field_77993_c, stack.field_77994_a, stack.func_77960_j());
        for (int slot = 0; slot < duct.func_70302_i_(); ++slot) {
            ItemStack getstack = duct.func_70301_a(slot);
            if (duct.func_94041_b(slot, copystack)) {
                int max;
                boolean flag = false;
                if (copystack == null) break;
                if (getstack == null) {
                    max = Math.min(stack.func_77976_d(), duct.func_70297_j_());
                    if (max >= copystack.field_77994_a) {
                        duct.func_70299_a(slot, copystack);
                        copystack = null;
                        effective = flag = true;
                    } else {
                        duct.func_70299_a(slot, copystack.func_77979_a(max));
                        copystack = null;
                        effective = flag = true;
                    }
                } else if (InventoryHelper.areItemStacksEqualItem(getstack, copystack) && (max = Math.min(copystack.func_77976_d(), duct.func_70297_j_())) > getstack.field_77994_a) {
                    int l = Math.min(copystack.field_77994_a, max - getstack.field_77994_a);
                    copystack.field_77994_a -= l;
                    getstack.field_77994_a += l;
                    if (copystack.field_77994_a < 1) {
                        copystack = null;
                    }
                    effective = flag = l > 0;
                }
            }
            if (!effective) continue;
            duct.func_70296_d();
        }
        return effective;
    }

    void dispenseSolidItem(ItemStack stack) {
        BlockSourceImpl blocksourceimpl = new BlockSourceImpl(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        IBehaviorDispenseItem ibehaviordispenseitem = (IBehaviorDispenseItem)this.dispenseBehavior.func_82594_a((Object)stack.func_77973_b());
        if (ibehaviordispenseitem != IBehaviorDispenseItem.field_82483_a) {
            ibehaviordispenseitem.func_82482_a((IBlockSource)blocksourceimpl, stack);
        }
    }

    public int getCapacity() {
        return this.maxLiquid;
    }

    public int getTotalLiquid() {
        return this.currentLiquid;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.moltenMetal.size() == 0) {
            return null;
        }
        FluidStack liquid = this.moltenMetal.get(0);
        if (liquid != null) {
            if (liquid.amount - maxDrain <= 0) {
                FluidStack liq = liquid.copy();
                if (doDrain) {
                    this.moltenMetal.remove(liquid);
                    this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                    this.currentLiquid = 0;
                    this.needsUpdate = true;
                }
                return liq;
            }
            if (doDrain && maxDrain > 0) {
                liquid.amount -= maxDrain;
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                this.currentLiquid -= maxDrain;
                this.needsUpdate = true;
            }
            return new FluidStack(liquid.fluidID, maxDrain, liquid.tag);
        }
        return new FluidStack(0, 0);
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null && this.currentLiquid < this.maxLiquid) {
            int amount;
            boolean first;
            boolean bl = first = resource.getFluid() == FluidRegistry.WATER;
            if (resource.amount + this.currentLiquid > this.maxLiquid) {
                resource.amount = this.maxLiquid - this.currentLiquid;
            }
            if ((amount = resource.amount) > 0 && doFill) {
                this.addFluidToTank(resource, first);
                this.needsUpdate = true;
                this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
            return amount;
        }
        return 0;
    }

    public FluidStack getFluid() {
        if (this.moltenMetal.size() == 0) {
            return null;
        }
        return this.moltenMetal.get(0);
    }

    public int getTotalFluidAmount() {
        if (this.moltenMetal.size() == 0) {
            return this.currentLiquid;
        }
        int amt = 0;
        for (int i = 0; i < this.moltenMetal.size(); ++i) {
            FluidStack l = this.moltenMetal.get(i);
            amt += l.amount;
        }
        return amt;
    }

    public int getFillRatio() {
        return this.currentLiquid <= 0 ? 0 : this.maxLiquid / this.getTotalFluidAmount();
    }

    public int getFluidAmount() {
        return this.currentLiquid;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public FluidTankInfo[] getMultiTankInfo() {
        FluidTankInfo[] info = new FluidTankInfo[this.moltenMetal.size() + 1];
        for (int i = 0; i < this.moltenMetal.size(); ++i) {
            FluidStack fluid = this.moltenMetal.get(i);
            info[i] = new FluidTankInfo(fluid.copy(), fluid.amount);
        }
        info[this.moltenMetal.size()] = new FluidTankInfo(null, this.maxLiquid - this.currentLiquid);
        return info;
    }

    @Override
    public void func_70307_a(NBTTagCompound tags) {
        this.layers = tags.func_74762_e("Layers");
        this.maxTemp = tags.func_74762_e("MaxTemp");
        this.inventory = new ItemStack[4 + this.layers];
        int[] duct = tags.func_74759_k("OutputDuct");
        if (duct.length > 2) {
            this.outputDuct = new CoordTuple(duct[0], duct[1], duct[2]);
        }
        super.func_70307_a(tags);
        this.redstoneActivated = tags.func_74767_n("RedstoneActivated");
        this.internalTemp = tags.func_74762_e("InternalTemp");
        this.isMeltingItems = tags.func_74767_n("InUse");
        int[] center = tags.func_74759_k("CenterPos");
        this.centerPos = center.length > 2 ? new CoordTuple(center[0], center[1], center[2]) : new CoordTuple(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.direction = tags.func_74771_c("Direction");
        this.fuelBurnTime = tags.func_74762_e("UseTime");
        this.fuelHeatRate = tags.func_74762_e("FuelHeatRate");
        this.currentLiquid = tags.func_74762_e("CurrentLiquid");
        this.maxLiquid = tags.func_74762_e("MaxLiquid");
        this.meltingTemps = tags.func_74759_k("MeltingTemps");
        this.activeTemps = tags.func_74759_k("ActiveTemps");
        NBTTagList liquidTag = tags.func_74761_m("Liquids");
        this.moltenMetal.clear();
        for (int iter = 0; iter < liquidTag.func_74745_c(); ++iter) {
            NBTTagCompound nbt = (NBTTagCompound)liquidTag.func_74743_b(iter);
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
            if (fluid == null) continue;
            this.moltenMetal.add(fluid);
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound tags) {
        super.func_70310_b(tags);
        tags.func_74757_a("RedstoneActivated", this.redstoneActivated);
        tags.func_74768_a("InternalTemp", this.internalTemp);
        tags.func_74757_a("InUse", this.isMeltingItems);
        int[] duct = new int[3];
        if (this.outputDuct != null) {
            duct = new int[]{this.outputDuct.x, this.outputDuct.y, this.outputDuct.z};
        }
        tags.func_74783_a("OutputDuct", duct);
        int[] center = new int[3];
        center = this.centerPos == null ? new int[]{this.field_70329_l, this.field_70330_m, this.field_70327_n} : new int[]{this.centerPos.x, this.centerPos.y, this.centerPos.z};
        tags.func_74783_a("CenterPos", center);
        tags.func_74774_a("Direction", this.direction);
        tags.func_74768_a("UseTime", this.fuelBurnTime);
        tags.func_74768_a("FuelHeatRate", this.fuelHeatRate);
        tags.func_74768_a("CurrentLiquid", this.currentLiquid);
        tags.func_74768_a("MaxLiquid", this.maxLiquid);
        tags.func_74768_a("Layers", this.layers);
        tags.func_74768_a("MaxTemp", this.maxTemp);
        tags.func_74783_a("MeltingTemps", this.meltingTemps);
        tags.func_74783_a("ActiveTemps", this.activeTemps);
        NBTTagList taglist = new NBTTagList();
        for (FluidStack liquid : this.moltenMetal) {
            NBTTagCompound nbt = new NBTTagCompound();
            liquid.writeToNBT(nbt);
            taglist.func_74742_a((NBTBase)nbt);
        }
        tags.func_74782_a("Liquids", (NBTBase)taglist);
    }

    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70310_b(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, tag);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.func_70307_a(packet.field_73331_e);
        this.func_70296_d();
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.needsUpdate = true;
    }

    @Override
    public void func_70295_k_() {
    }

    @Override
    public void func_70305_f() {
    }

    public CoordTuple getCoord() {
        return new CoordTuple(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public boolean isValid() {
        return this.validStructure;
    }

    public int getBlockId() {
        return this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }
}

