/*
 * Decompiled with CFR 0.152.
 */
package tsteelworks.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import tconstruct.library.util.CoordTuple;
import tsteelworks.blocks.TSBaseFluid;
import tsteelworks.common.TSContent;

public class CementFluidBlock
extends TSBaseFluid {
    public CoordTuple origin;

    public CementFluidBlock(int id, Fluid fluid, Material material, String texture) {
        super(id, fluid, material, texture);
    }

    @SideOnly(value=Side.CLIENT)
    public void setRenderColorByMeta() {
    }

    public void func_71861_g(World world, int x, int y, int z) {
        world.func_72836_a(x, y, z, this.field_71990_ca, this.tickRate);
        this.origin = new CoordTuple(x, y, z);
    }

    public void func_71863_a(World world, int x, int y, int z, int blockId) {
        world.func_72836_a(x, y, z, this.field_71990_ca, this.tickRate);
    }

    public void func_71847_b(World world, int x, int y, int z, Random rand) {
        int quantaRemaining = this.quantaPerBlock - world.func_72805_g(x, y, z);
        int expQuanta = -101;
        if (quantaRemaining < this.quantaPerBlock) {
            int y2 = y - this.densityDir;
            if (world.func_72798_a(x, y2, z) == this.field_71990_ca || world.func_72798_a(x - 1, y2, z) == this.field_71990_ca || world.func_72798_a(x + 1, y2, z) == this.field_71990_ca || world.func_72798_a(x, y2, z - 1) == this.field_71990_ca || world.func_72798_a(x, y2, z + 1) == this.field_71990_ca) {
                expQuanta = this.quantaPerBlock - 1;
            } else {
                int maxQuanta = -100;
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, x - 1, y, z, maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, x + 1, y, z, maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, x, y, z - 1, maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, x, y, z + 1, maxQuanta);
                expQuanta = maxQuanta - 1;
            }
            if (expQuanta != quantaRemaining) {
                quantaRemaining = expQuanta;
                if (expQuanta <= 0) {
                    this.checkForHarden(world, x, y, z);
                } else {
                    world.func_72921_c(x, y, z, this.quantaPerBlock - expQuanta, 3);
                    world.func_72836_a(x, y, z, this.field_71990_ca, this.tickRate);
                    world.func_72898_h(x, y, z, this.field_71990_ca);
                }
            }
        } else if (quantaRemaining >= this.quantaPerBlock) {
            world.func_72921_c(x, y, z, 0, 2);
        }
        if (this.canDisplace((IBlockAccess)world, x, y + this.densityDir, z)) {
            this.flowIntoBlock(world, x, y + this.densityDir, z, 1);
            this.checkForHarden(world, x, y, z);
            return;
        }
        int flowMeta = this.quantaPerBlock - quantaRemaining + 1;
        if (flowMeta >= this.quantaPerBlock) {
            this.checkForHarden(world, x, y, z);
            this.traceToSource(world, x, y, z);
            return;
        }
        if (this.isSourceBlock((IBlockAccess)world, x, y, z) || !this.isFlowingVertically((IBlockAccess)world, x, y, z)) {
            boolean[] flowTo;
            if (world.func_72798_a(x, y - this.densityDir, z) == this.field_71990_ca) {
                flowMeta = 1;
            }
            if ((flowTo = this.getOptimalFlowDirections(world, x, y, z))[0]) {
                this.flowIntoBlock(world, x - 1, y, z, flowMeta);
            }
            if (flowTo[1]) {
                this.flowIntoBlock(world, x + 1, y, z, flowMeta);
            }
            if (flowTo[2]) {
                this.flowIntoBlock(world, x, y, z - 1, flowMeta);
            }
            if (flowTo[3]) {
                this.flowIntoBlock(world, x, y, z + 1, flowMeta);
            }
        }
    }

    protected void flowIntoBlock(World world, int x, int y, int z, int meta) {
        if (meta < 0) {
            return;
        }
        if (this.displaceIfPossible(world, x, y, z)) {
            world.func_72832_d(x, y, z, this.field_71990_ca, meta, 3);
        }
    }

    private void checkForHarden(World world, int x, int y, int z) {
        if (world.func_72798_a(x, y, z) == this.field_71990_ca || world.func_72798_a(x, y, z) == TSContent.cementBlock.field_71990_ca) {
            boolean harden = false;
            if (!this.isFlowingVertically((IBlockAccess)world, x, y, z)) {
                if (harden || this.validHardenCoords(world, x, y, z - 1)) {
                    // empty if block
                }
                if ((harden = true) || this.validHardenCoords(world, x, y, z + 1)) {
                    // empty if block
                }
                if ((harden = true) || this.validHardenCoords(world, x - 1, y, z)) {
                    // empty if block
                }
                if ((harden = true) || this.validHardenCoords(world, x - 1, y, z)) {
                    // empty if block
                }
                if ((harden = true) || this.validHardenCoords(world, x + 1, y, z + 1)) {
                    // empty if block
                }
                if ((harden = true) || this.validHardenCoords(world, x + 1, y, z - 1)) {
                    // empty if block
                }
                if ((harden = true) || this.validHardenCoords(world, x - 1, y, z - 1)) {
                    // empty if block
                }
                if ((harden = true) || this.validHardenCoords(world, x + 1, y, z + 1)) {
                    // empty if block
                }
                harden = true;
            }
            if (harden || this.validHardenCoords(world, x, y - 1, z)) {
                // empty if block
            }
            if ((harden = true) || this.validHardenCoords(world, x, y + 1, z)) {
                // empty if block
            }
            if (harden = true) {
                world.func_94575_c(x, y, z, TSContent.cementBlock.field_71990_ca);
                if (this.isFlowingVertically((IBlockAccess)world, x, y, z)) {
                    this.func_71863_a(world, x, y, z, this.field_71990_ca);
                }
                return;
            }
        }
    }

    public void traceToSource(World world, int x, int y, int z) {
        for (int xScan = 0; xScan < 8; ++xScan) {
            for (int yScan = 0; yScan < 8; ++yScan) {
                for (int zScan = 0; zScan < 8; ++zScan) {
                    if (world.func_72798_a(x - xScan, y - yScan, z - zScan) != this.field_71990_ca || world.func_72805_g(x - xScan, y - yScan, z - zScan) != 0 && world.func_72805_g(x - xScan, y - yScan, z - zScan) != 1) continue;
                    world.func_94575_c(x - xScan, y - yScan, z - zScan, TSContent.cementBlock.field_71990_ca);
                }
            }
        }
    }

    public boolean validHardenCoords(World world, int x, int y, int z) {
        return world.func_72803_f(x, y, z) == Material.field_76249_a || world.func_72798_a(x, y, z) == TSContent.cementBlock.field_71990_ca;
    }

    protected void triggerCementMixEffects(World world, int x, int y, int z) {
        world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "random.fizz", 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
    }
}

