/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.util;

import modtweaker.util.TweakerBaseFunction;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.minetweaker.api.TweakerExecuteException;
import stanhebben.minetweaker.api.value.TweakerArray;
import stanhebben.minetweaker.api.value.TweakerItemStack;
import stanhebben.minetweaker.api.value.TweakerLiquidStack;
import stanhebben.minetweaker.api.value.TweakerValue;

public class TweakerHelper {
    public static TweakerValue[] arguments;
    public static int index;

    public static TweakerItemStack GetItemOld(int arg, TweakerValue ... values) {
        return TweakerHelper.notNull(values[arg], arg).toItemStack("argument " + arg + " must be an item");
    }

    public static TweakerLiquidStack getFluid(int arg, TweakerValue ... values) {
        return TweakerHelper.notNull(values[arg], arg).toFluidStack("argument " + arg + " must be a valid fluid");
    }

    public static boolean getBoolean(int arg, TweakerValue ... values) {
        return TweakerHelper.notNull(values[arg], arg).toBool("argument " + arg + " must be true or false").get();
    }

    public static int getInt(int arg, TweakerValue ... values) {
        return TweakerHelper.notNull(values[arg], arg).toInt("argument " + arg + " must be an integer").get();
    }

    public static float getFloat(int arg, TweakerValue ... values) {
        return TweakerHelper.notNull(values[arg], arg).toFloat("argument " + arg + " must be a float").get();
    }

    public static TweakerArray getArray(int arg, TweakerValue ... values) {
        return TweakerHelper.notNull(values[arg], arg).toArray("argument " + arg + " must be an array of items");
    }

    public static TweakerItemStack getItemNull(int arg, TweakerValue ... values) {
        return values[arg].asItemStack();
    }

    public static TweakerLiquidStack getFluidNull(int arg, TweakerValue ... values) {
        return values[arg].asFluidStack();
    }

    public static int getDimension(int arg, TweakerValue ... values) {
        String dim = TweakerHelper.getString(arg, values);
        if (dim.equalsIgnoreCase("any")) {
            return Short.MAX_VALUE;
        }
        if (dim.equalsIgnoreCase("nether")) {
            return -1;
        }
        if (dim.equalsIgnoreCase("end")) {
            return 1;
        }
        if (dim.equalsIgnoreCase("overworld")) {
            return 0;
        }
        return Short.MAX_VALUE;
    }

    public static String getString(int arg, TweakerValue ... values) {
        return TweakerHelper.notNull(values[arg], arg).toBasicString();
    }

    public static int getHex(int arg, TweakerValue ... values) {
        return Integer.parseInt(TweakerHelper.getString(arg, values), 16);
    }

    public static void throwException(String label, int args) {
        throw new TweakerExecuteException(label + " requires " + args + " arguments");
    }

    public static boolean canContinue(int size, TweakerValue ... args) {
        if (args.length == size) {
            arguments = args;
            index = 0;
            return true;
        }
        return false;
    }

    public static boolean canContinue(int[] size, TweakerValue ... args) {
        for (int i : size) {
            if (!TweakerHelper.canContinue(i, args)) continue;
            return true;
        }
        return false;
    }

    public static int getInt() {
        int i = TweakerHelper.notNull(arguments[index], index).toInt("argument " + index + " must be an integer").get();
        ++index;
        return i;
    }

    public static ItemStack getItem() {
        ItemStack stack = TweakerHelper.notNull(arguments[index], index).toItemStack("argument " + index + " must be an item").get();
        if (stack != null) {
            ++index;
        }
        return stack;
    }

    public static ItemStack[] getItems() {
        TweakerArray array = TweakerHelper.notNull(arguments[index], index).toArray("argument " + index + " must be an array of items");
        if (array != null) {
            ItemStack[] input = new ItemStack[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                input[i] = array.get(i).asItemStack().get();
            }
            ++index;
            return input;
        }
        return null;
    }

    public static FluidStack getFluid() {
        FluidStack stack = TweakerHelper.notNull(arguments[index], index).toFluidStack("argument " + index + " must be a fluid").get();
        if (stack != null) {
            ++index;
        }
        return stack;
    }

    public static FluidStack[] getFluids() {
        TweakerArray array = TweakerHelper.notNull(arguments[index], index).toArray("argument " + index + " must be an array of fluids");
        if (array != null) {
            FluidStack[] input = new FluidStack[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                input[i] = array.get(i).asFluidStack().get();
            }
            ++index;
            return input;
        }
        return null;
    }

    public static TweakerValue notNull(TweakerValue value, int arg) {
        return TweakerValue.notNull((TweakerValue)value, (String)("argument " + arg + " must not be null"));
    }

    public static void throwException(TweakerBaseFunction label, int args) {
        throw new TweakerExecuteException(label.toString() + " requires " + args + " arguments");
    }

    public static void throwException(TweakerBaseFunction label, int[] args) {
        String nums = "";
        for (int i : args) {
            nums = nums + i + " ";
            if (i >= args.length) continue;
            nums = nums + "or ";
        }
        throw new TweakerExecuteException(label.toString() + " requires " + args.toString() + "arguments");
    }
}

