/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.tconstruct;

import java.util.Arrays;
import modtweaker.tconstruct.TConstructHacks;
import modtweaker.util.TweakerBaseFunction;
import modtweaker.util.TweakerHelper;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.Tweaker;
import stanhebben.minetweaker.api.TweakerExecuteException;
import stanhebben.minetweaker.api.value.TweakerValue;
import tconstruct.library.crafting.Smeltery;

public class MeltingAddRecipe
extends TweakerBaseFunction {
    public static final MeltingAddRecipe INSTANCE = new MeltingAddRecipe();

    private MeltingAddRecipe() {
        super("tconstruct.smeltery.addMelting");
    }

    @Override
    public void perform(TweakerValue ... args) {
        if (TweakerHelper.canContinue(new int[]{3, 4}, args)) {
            ItemStack input = TweakerHelper.getItem();
            FluidStack output = TweakerHelper.getFluid();
            int temp = TweakerHelper.getInt();
            ItemStack block = input.func_77946_l();
            if (args.length == 4) {
                block = TweakerHelper.getItem();
            }
            if (Block.field_71973_m[block.field_77993_c] == null) {
                throw new TweakerExecuteException("Item must be a block, or you must specify a block to render as");
            }
            Tweaker.apply((IUndoableAction)new Action(input, block.field_77993_c, block.func_77960_j(), temp, output));
        } else {
            TweakerHelper.throwException((TweakerBaseFunction)this, new int[]{3, 4});
        }
    }

    private static class Action
    implements IUndoableAction {
        private final ItemStack input;
        private final int blockID;
        private final int metadata;
        private final int temperature;
        private final FluidStack liquid;

        public Action(ItemStack input, int blockID, int metadata, int temperature, FluidStack liquid) {
            this.input = input;
            this.blockID = blockID;
            this.metadata = metadata;
            this.temperature = temperature;
            this.liquid = liquid;
        }

        public void apply() {
            Smeltery.addMelting((ItemStack)this.input, (int)this.blockID, (int)this.metadata, (int)this.temperature, (FluidStack)this.liquid);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            TConstructHacks.smeltingList.remove(Arrays.asList(this.input.field_77993_c, this.input.func_77960_j()));
            TConstructHacks.temperatureList.remove(Arrays.asList(this.input.field_77993_c, this.input.func_77960_j()));
            TConstructHacks.renderIndex.remove(Arrays.asList(this.input.field_77993_c, this.input.func_77960_j()));
        }

        public String describe() {
            return "Adding Smeltery Recipe: " + this.input.func_82833_r();
        }

        public String describeUndo() {
            return "Removing Smeltery Recipe: " + this.input.func_82833_r();
        }
    }
}

