/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.tconstruct;

import modtweaker.tconstruct.TConstructHacks;
import modtweaker.util.TweakerBaseFunction;
import modtweaker.util.TweakerHelper;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.Tweaker;
import stanhebben.minetweaker.api.value.TweakerValue;
import tconstruct.library.crafting.AlloyMix;
import tconstruct.library.crafting.Smeltery;

public class AlloyRemoveRecipe
extends TweakerBaseFunction {
    public static final AlloyRemoveRecipe INSTANCE = new AlloyRemoveRecipe();

    private AlloyRemoveRecipe() {
        super("tconstruct.smeltery.removeAlloy");
    }

    @Override
    public void perform(TweakerValue ... args) {
        if (TweakerHelper.canContinue(1, args)) {
            FluidStack output = TweakerHelper.getFluid();
            Tweaker.apply((IUndoableAction)new Action(output));
        } else {
            TweakerHelper.throwException((TweakerBaseFunction)this, 1);
        }
    }

    private static class Action
    implements IUndoableAction {
        private final FluidStack output;
        private FluidStack[] mixers;

        public Action(FluidStack output) {
            this.output = output;
        }

        public void apply() {
            int k;
            for (k = 0; k < TConstructHacks.alloys.size(); ++k) {
                AlloyMix mix = TConstructHacks.alloys.get(k);
                if (!mix.result.isFluidStackIdentical(this.output)) continue;
                this.mixers = (FluidStack[])mix.mixers.toArray();
                break;
            }
            TConstructHacks.alloys.remove(k);
        }

        public boolean canUndo() {
            return TConstructHacks.alloys != null;
        }

        public void undo() {
            Smeltery.addAlloyMixing((FluidStack)this.output, (FluidStack[])this.mixers);
        }

        public String describe() {
            return "Removing Alloy Recipe: " + this.output.getFluid().getLocalizedName();
        }

        public String describeUndo() {
            return "Restoring Alloy Recipe: " + this.output.getFluid().getLocalizedName();
        }
    }
}

