/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mariculture.action;

import java.util.List;
import java.util.Map;
import mariculture.api.core.RecipeVat;
import modtweaker.mariculture.MaricultureHacks;
import modtweaker.util.ItemHelper;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.value.TweakerLiquidStack;

public class VatRemoveFluidRecipeAction
implements IUndoableAction {
    private final TweakerLiquidStack output;
    private List<? extends Object> remove;
    private RecipeVat recipe;

    public VatRemoveFluidRecipeAction(TweakerLiquidStack output) {
        this.output = output;
    }

    public void apply() {
        this.remove = null;
        for (Map.Entry<List<? extends Object>, RecipeVat> vat : MaricultureHacks.vat.entrySet()) {
            if (!ItemHelper.getName(vat.getValue().outputFluid).equals(ItemHelper.getName(this.output.get()))) continue;
            this.remove = vat.getKey();
            break;
        }
        if (this.remove != null) {
            this.recipe = MaricultureHacks.vat.get(this.remove);
            MaricultureHacks.vat.remove(this.remove);
        }
    }

    public boolean canUndo() {
        return MaricultureHacks.vat != null;
    }

    public void undo() {
        MaricultureHacks.vat.put(this.remove, this.recipe);
    }

    public String describe() {
        return "Removing Vat Fluid Recipe: " + this.output.getDisplayName();
    }

    public String describeUndo() {
        return "Removing Vat Fluid Recipe: " + this.output.getDisplayName();
    }
}

