/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mariculture.action;

import mariculture.api.core.FuelInfo;
import mariculture.core.helpers.OreDicHelper;
import modtweaker.mariculture.MaricultureHacks;
import modtweaker.util.ItemHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.minetweaker.api.IUndoableAction;

public class CrucibleAddFuelAction
implements IUndoableAction {
    private String key;
    private final Object fuel;
    private final FuelInfo info;

    public CrucibleAddFuelAction(Object fuel, FuelInfo info) {
        this.fuel = fuel;
        this.info = info;
    }

    public void apply() {
        if (this.fuel instanceof ItemStack) {
            this.key = OreDicHelper.convert((Object)((ItemStack)this.fuel));
        }
        if (this.fuel instanceof FluidStack) {
            this.key = ItemHelper.getName((FluidStack)this.fuel);
        }
        MaricultureHacks.fuels.put(this.key, this.info);
    }

    public boolean canUndo() {
        return MaricultureHacks.fuels != null;
    }

    public void undo() {
        MaricultureHacks.fuels.remove(this.key);
    }

    public String asString() {
        if (this.fuel instanceof ItemStack) {
            return ((ItemStack)this.fuel).func_82833_r();
        }
        if (this.fuel instanceof FluidStack) {
            return ((FluidStack)this.fuel).getFluid().getLocalizedName();
        }
        return "";
    }

    public String describe() {
        return "Adding Crucible Furnace Fuel: " + this.asString();
    }

    public String describeUndo() {
        return "Removing Crucible Furnace Fuel: " + this.asString();
    }
}

