/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mariculture;

import mariculture.api.core.RecipeCasting;
import modtweaker.mariculture.MaricultureHacks;
import modtweaker.util.TweakerBaseFunction;
import modtweaker.util.TweakerHelper;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.Tweaker;
import stanhebben.minetweaker.api.value.TweakerValue;

public class CastingRemoveIngot
extends TweakerBaseFunction {
    public static final CastingRemoveIngot INSTANCE = new CastingRemoveIngot();

    private CastingRemoveIngot() {
        super("mariculture.casting.removeIngotCasting");
    }

    @Override
    public void perform(TweakerValue ... args) {
        if (TweakerHelper.canContinue(1, args)) {
            FluidStack input = TweakerHelper.getFluid();
            Tweaker.apply((IUndoableAction)new Action(input));
        } else {
            TweakerHelper.throwException((TweakerBaseFunction)this, 1);
        }
    }

    private static class Action
    implements IUndoableAction {
        private RecipeCasting.RecipeIngotCasting casting;
        private final FluidStack input;

        public Action(FluidStack input) {
            this.input = input;
        }

        public void apply() {
            this.casting = (RecipeCasting.RecipeIngotCasting)MaricultureHacks.ingotCasting.get(this.input.getFluid().getName());
            MaricultureHacks.ingotCasting.remove(this.input.getFluid().getName());
        }

        public boolean canUndo() {
            return MaricultureHacks.ingotCasting != null;
        }

        public void undo() {
            MaricultureHacks.ingotCasting.put(this.input.getFluid().getName(), (RecipeCasting)this.casting);
        }

        public String describe() {
            return "Removing Ingot Casting Recipe: " + this.casting.output.func_82833_r();
        }

        public String describeUndo() {
            return "Restoring Ingot Casting Recipe: " + this.casting.output.func_82833_r();
        }
    }
}

