/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.world;

import java.util.Comparator;
import java.util.Random;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.IPlantable;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;

public class WorldGenMassiveTree
extends WorldGenerator {
    static final byte[] otherCoordPairs = new byte[]{2, 0, 0, 1, 2, 1};
    Random rand = new Random();
    World worldObj;
    int[] basePos = new int[]{0, 0, 0};
    int heightLimit = 0;
    int minHeight = -1;
    int height;
    double heightAttenuation = 0.45;
    double branchDensity = 5.0;
    double branchSlope = 0.45;
    double scaleWidth = 4.0;
    double leafDensity = 5.0;
    TreeSet<Chunk> modifiedChunks = new TreeSet<Chunk>(new ChunkComp());
    int trunkSize = 5;
    int heightLimitLimit = 190;
    int leafDistanceLimit = 4;
    int[][] leafNodes;

    public WorldGenMassiveTree(boolean bl) {
        super(bl);
    }

    public WorldGenMassiveTree() {
    }

    void generateLeafNodeList() {
        int n;
        this.height = (int)((double)this.heightLimit * this.heightAttenuation);
        if (this.height >= this.heightLimit) {
            this.height = this.heightLimit - 1;
        }
        if ((n = (int)(1.382 + Math.pow(this.leafDensity * (double)this.heightLimit / 13.0, 2.0))) < 1) {
            n = 1;
        }
        int[][] nArray = new int[n * this.heightLimit][4];
        int n2 = this.basePos[1] + this.heightLimit - this.leafDistanceLimit;
        int n3 = 1;
        int n4 = this.basePos[1] + this.height;
        int n5 = n2 - this.basePos[1];
        nArray[0][0] = this.basePos[0];
        nArray[0][1] = n2--;
        nArray[0][2] = this.basePos[2];
        nArray[0][3] = n4;
        while (n5 >= 0) {
            float f = this.layerSize(n5);
            if (f < 0.0f) {
                --n2;
                --n5;
                continue;
            }
            double d = 0.5;
            for (int i = 0; i < n; ++i) {
                int[] nArray2;
                int n6;
                double d2;
                double d3 = this.scaleWidth * (double)f * ((double)this.rand.nextFloat() + 0.328);
                int n7 = MathHelper.func_76128_c((double)(d3 * Math.sin(d2 = (double)this.rand.nextFloat() * 2.0 * Math.PI) + (double)this.basePos[0] + d));
                int[] nArray3 = new int[]{n7, n2, n6 = MathHelper.func_76128_c((double)(d3 * Math.cos(d2) + (double)this.basePos[2] + d))};
                if (this.checkBlockLine(nArray3, nArray2 = new int[]{n7, n2 + this.leafDistanceLimit, n6}) != -1) continue;
                int[] nArray4 = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
                double d4 = Math.sqrt(Math.pow(Math.abs(this.basePos[0] - nArray3[0]), 2.0) + Math.pow(Math.abs(this.basePos[2] - nArray3[2]), 2.0));
                double d5 = d4 * this.branchSlope;
                nArray4[1] = (double)nArray3[1] - d5 > (double)n4 ? n4 : (int)((double)nArray3[1] - d5);
                if (this.checkBlockLine(nArray4, nArray3) != -1) continue;
                nArray[n3][0] = n7;
                nArray[n3][1] = n2;
                nArray[n3][2] = n6;
                nArray[n3][3] = nArray4[1];
                ++n3;
            }
            --n2;
            --n5;
        }
        this.leafNodes = new int[n3][4];
        System.arraycopy(nArray, 0, this.leafNodes, 0, n3);
    }

    void genTreeLayer(int n, int n2, int n3, float f, byte by, int n4) {
        int n5 = (int)((double)f + 0.618);
        byte by2 = otherCoordPairs[by];
        byte by3 = otherCoordPairs[by + 3];
        int[] nArray = new int[]{n, n2, n3};
        int[] nArray2 = new int[]{0, 0, 0};
        int n6 = -n5;
        nArray2[by] = nArray[by];
        for (int i = -n5; i <= n5; ++i) {
            nArray2[by2] = nArray[by2] + i;
            n6 = -n5;
            while (n6 <= n5) {
                double d = Math.pow((double)Math.abs(i) + 0.5, 2.0) + Math.pow((double)Math.abs(n6) + 0.5, 2.0);
                if (d > (double)(f * f)) {
                    ++n6;
                    continue;
                }
                nArray2[by3] = nArray[by3] + n6;
                int n7 = this.worldObj.func_72798_a(nArray2[0], nArray2[1], nArray2[2]);
                if (n7 != 0 && n7 != MineFactoryReloadedCore.rubberLeavesBlock.field_71990_ca) {
                    ++n6;
                    continue;
                }
                this.func_76485_a(this.worldObj, nArray2[0], nArray2[1], nArray2[2], n4, 4);
                ++n6;
            }
        }
    }

    float layerSize(int n) {
        if ((double)n < (double)this.heightLimit * 0.3) {
            return -1.618f;
        }
        float f = (float)this.heightLimit / 2.0f;
        float f2 = (float)this.heightLimit / 2.0f - (float)n;
        float f3 = f2 == 0.0f ? f : (Math.abs(f2) >= f ? 0.0f : (float)Math.sqrt(Math.pow(Math.abs(f), 2.0) - Math.pow(Math.abs(f2), 2.0)));
        return f3 *= 0.5f;
    }

    float leafSize(int n) {
        return n >= 0 && n < this.leafDistanceLimit ? (n != 0 && n != this.leafDistanceLimit - 1 ? 3.0f : 2.0f) : -1.0f;
    }

    void generateLeafNode(int n, int n2, int n3) {
        int n4 = n2 + this.leafDistanceLimit;
        for (int i = n2; i < n4; ++i) {
            float f = this.leafSize(i - n2);
            this.genTreeLayer(n, i, n3, f, (byte)1, MineFactoryReloadedCore.rubberLeavesBlock.field_71990_ca);
        }
    }

    void placeBlockLine(int[] nArray, int[] nArray2, int n, int n2) {
        int[] nArray3 = new int[]{0, 0, 0};
        int n3 = 0;
        for (int n4 = 0; n4 < 3; n4 = (int)((byte)(n4 + 1))) {
            nArray3[n4] = nArray2[n4] - nArray[n4];
            if (Math.abs(nArray3[n4]) <= Math.abs(nArray3[n3])) continue;
            n3 = n4;
        }
        if (nArray3[n3] != 0) {
            byte by = otherCoordPairs[n3];
            byte by2 = otherCoordPairs[n3 + 3];
            int n5 = nArray3[n3] > 0 ? 1 : -1;
            double d = (double)nArray3[by] / (double)nArray3[n3];
            double d2 = (double)nArray3[by2] / (double)nArray3[n3];
            int[] nArray4 = new int[]{0, 0, 0};
            int n6 = nArray3[n3] + n5;
            for (int i = 0; i != n6; i += n5) {
                int n7;
                nArray4[n3] = MathHelper.func_76128_c((double)((double)(nArray[n3] + i) + 0.5));
                nArray4[by] = MathHelper.func_76128_c((double)((double)nArray[by] + (double)i * d + 0.5));
                nArray4[by2] = MathHelper.func_76128_c((double)((double)nArray[by2] + (double)i * d2 + 0.5));
                int n8 = 0;
                int n9 = Math.abs(nArray4[0] - nArray[0]);
                int n10 = Math.max(n9, n7 = Math.abs(nArray4[2] - nArray[2]));
                if (n10 > 0) {
                    if (n9 == n10) {
                        n8 = 4;
                    } else if (n7 == n10) {
                        n8 = 8;
                    }
                }
                this.func_76485_a(this.worldObj, nArray4[0], nArray4[1], nArray4[2], n, n2 | n8);
            }
        }
    }

    void generateLeaves() {
        int n = this.leafNodes.length;
        for (int i = 0; i < n; ++i) {
            int n2 = this.leafNodes[i][0];
            int n3 = this.leafNodes[i][1];
            int n4 = this.leafNodes[i][2];
            this.generateLeafNode(n2, n3, n4);
        }
    }

    boolean leafNodeNeedsBase(int n) {
        return (double)n >= (double)this.heightLimit * 0.2;
    }

    void generateTrunk() {
        int n = this.basePos[0];
        int n2 = this.basePos[1];
        int n3 = this.basePos[1] + this.height;
        int n4 = this.basePos[2];
        int[] nArray = new int[]{n, n2, n4};
        int[] nArray2 = new int[]{n, n3, n4};
        for (int i = -this.trunkSize; i <= this.trunkSize; ++i) {
            nArray[0] = n + i;
            nArray2[0] = n + i;
            for (int j = -this.trunkSize; j <= this.trunkSize; ++j) {
                if ((j * j + i * i) * 2 >= this.trunkSize * this.trunkSize * 3) continue;
                nArray[2] = n4 + j;
                nArray2[2] = n4 + j;
                this.placeBlockLine(nArray, nArray2, MineFactoryReloadedCore.rubberWoodBlock.field_71990_ca, 1);
            }
        }
    }

    void generateLeafNodeBases() {
        int n = this.leafNodes.length;
        int[] nArray = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
        for (int i = 0; i < n; ++i) {
            int[] nArray2 = this.leafNodes[i];
            int[] nArray3 = new int[]{nArray2[0], nArray2[1], nArray2[2]};
            nArray[1] = nArray2[3];
            int n2 = nArray[1] - this.basePos[1];
            if (!this.leafNodeNeedsBase(n2)) continue;
            this.placeBlockLine(nArray, nArray3, MineFactoryReloadedCore.rubberWoodBlock.field_71990_ca, 13);
        }
    }

    int checkBlockLine(int[] nArray, int[] nArray2) {
        int n;
        int[] nArray3 = new int[]{0, 0, 0};
        int n2 = 0;
        for (int n3 = 0; n3 < 3; n3 = (int)((byte)(n3 + 1))) {
            nArray3[n3] = nArray2[n3] - nArray[n3];
            if (Math.abs(nArray3[n3]) <= Math.abs(nArray3[n2])) continue;
            n2 = n3;
        }
        if (nArray3[n2] == 0) {
            return -1;
        }
        byte by = otherCoordPairs[n2];
        byte by2 = otherCoordPairs[n2 + 3];
        int n4 = nArray3[n2] > 0 ? 1 : -1;
        double d = (double)nArray3[by] / (double)nArray3[n2];
        double d2 = (double)nArray3[by2] / (double)nArray3[n2];
        int[] nArray4 = new int[]{0, 0, 0};
        int n5 = nArray3[n2] + n4;
        for (n = 0; n != n5; n += n4) {
            nArray4[n2] = nArray[n2] + n;
            nArray4[by] = MathHelper.func_76128_c((double)((double)nArray[by] + (double)n * d));
            nArray4[by2] = MathHelper.func_76128_c((double)((double)nArray[by2] + (double)n * d2));
            int n6 = this.worldObj.func_72798_a(nArray4[0], nArray4[1], nArray4[2]);
            if (n6 == Block.field_71986_z.field_71990_ca) break;
        }
        return n == n5 ? -1 : Math.abs(n);
    }

    boolean validTreeLocation() {
        int n = Math.min(this.heightLimit + this.basePos[1], 255) - this.basePos[1];
        if (n < this.minHeight) {
            return false;
        }
        this.heightLimit = n;
        int n2 = this.worldObj.func_72798_a(this.basePos[0], this.basePos[1] - 1, this.basePos[2]);
        Block block = Block.field_71973_m[n2];
        if (block == null || !block.canSustainPlant(this.worldObj, this.basePos[0], this.basePos[1] - 1, this.basePos[2], ForgeDirection.UP, (IPlantable)((BlockSapling)MineFactoryReloadedCore.rubberSaplingBlock))) {
            return false;
        }
        int[] nArray = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
        int[] nArray2 = new int[]{this.basePos[0], this.basePos[1] + this.heightLimit - 1, this.basePos[2]};
        n = this.checkBlockLine(nArray, nArray2);
        if (n == -1) {
            return true;
        }
        if (n < this.minHeight) {
            return false;
        }
        this.heightLimit = n;
        return true;
    }

    public void func_76487_a(double d, double d2, double d3) {
        this.heightLimitLimit = (int)(d * 12.0);
        if (d > 0.5) {
            this.leafDistanceLimit = 5;
        }
        this.scaleWidth = d2;
        this.leafDensity = d3;
    }

    public boolean func_76484_a(World world, Random random, int n, int n2, int n3) {
        this.worldObj = world;
        long l = random.nextLong();
        this.rand.setSeed(l);
        this.basePos[0] = n;
        this.basePos[1] = n2;
        this.basePos[2] = n3;
        if (this.heightLimit == 0) {
            this.heightLimit = 200;
        }
        if (this.minHeight == -1) {
            this.minHeight = 80;
        }
        if (!this.validTreeLocation()) {
            return false;
        }
        this.generateLeafNodeList();
        this.generateLeaves();
        this.generateTrunk();
        this.generateLeafNodeBases();
        while (this.modifiedChunks.size() > 0) {
            MineFactoryReloadedCore.proxy.relightChunk(this.modifiedChunks.pollFirst());
        }
        return true;
    }

    public void func_76485_a(World world, int n, int n2, int n3, int n4, int n5) {
        if (n2 < 0 | n2 > 255) {
            return;
        }
        Chunk chunk = world.func_72938_d(n, n3);
        this.modifiedChunks.add(chunk);
        chunk.func_76627_f(n & 0xF, n2, n3 & 0xF);
        ExtendedBlockStorage[] extendedBlockStorageArray = chunk.func_76587_i();
        ExtendedBlockStorage extendedBlockStorage = extendedBlockStorageArray[n2 >> 4];
        if (extendedBlockStorage == null) {
            extendedBlockStorageArray[n2 >> 4] = extendedBlockStorage = new ExtendedBlockStorage(n2 & 0xFFFFFFF0, !this.worldObj.field_73011_w.field_76576_e);
        }
        extendedBlockStorage.func_76655_a(n & 0xF, n2 & 0xF, n3 & 0xF, n4);
        extendedBlockStorage.func_76654_b(n & 0xF, n2 & 0xF, n3 & 0xF, n5);
        extendedBlockStorage.func_76677_d(n & 0xF, n2 & 0xF, n3 & 0xF, 0);
    }

    static class ChunkComp
    implements Comparator<Chunk> {
        ChunkComp() {
        }

        @Override
        public int compare(Chunk chunk, Chunk chunk2) {
            if (chunk.field_76635_g != chunk2.field_76635_g) {
                return chunk.field_76635_g - chunk2.field_76635_g;
            }
            return chunk.field_76647_h - chunk2.field_76647_h;
        }
    }
}

